/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.internal.CheckpointInstance;
import io.delta.standalone.internal.CheckpointInstance$;
import io.delta.standalone.internal.Checkpoints;
import io.delta.standalone.internal.DeltaHistoryManager;
import io.delta.standalone.internal.DeltaLogImpl;
import io.delta.standalone.internal.InitialSnapshotImpl;
import io.delta.standalone.internal.LogSegment;
import io.delta.standalone.internal.SnapshotImpl;
import io.delta.standalone.internal.SnapshotProtocolMetadataHint;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.util.FileNames$;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001E4\u0011b\u0004\t\u0011\u0002\u0007\u0005\u0001\u0003\u00078\t\u000b}\u0001A\u0011A\u0011\t\u000f\u0015\u0002\u0001\u0019!C\tM!9q\u0006\u0001a\u0001\n#\u0001\u0004\"B\u001a\u0001\t\u00031\u0003\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0002\u001c\u0001\t\u00039\u0004\"B\u001f\u0001\t\u0003q\u0004\"B!\u0001\t\u0013)\u0004\"\u0002\"\u0001\t#\u0019\u0005b\u0002(\u0001#\u0003%\tb\u0014\u0005\u00065\u0002!\tB\n\u0005\u00067\u0002!I\u0001\u0018\u0005\u0006=\u0002!Ia\u0018\u0005\u0006O\u0002!I\u0001\u001b\u0002\u0013':\f\u0007o\u001d5pi6\u000bg.Y4f[\u0016tGO\u0003\u0002\u0012%\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0014)\u0005Q1\u000f^1oI\u0006dwN\\3\u000b\u0005U1\u0012!\u00023fYR\f'\"A\f\u0002\u0005%|7C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fM\u00061A%\u001b8ji\u0012\u001a\u0001\u0001F\u0001#!\tQ2%\u0003\u0002%7\t!QK\\5u\u0003=\u0019WO\u001d:f]R\u001cf.\u00199tQ>$X#A\u0014\u0011\u0005!JS\"\u0001\t\n\u0005)\u0002\"\u0001D*oCB\u001c\bn\u001c;J[Bd\u0007F\u0001\u0002-!\tQR&\u0003\u0002/7\tAao\u001c7bi&dW-A\ndkJ\u0014XM\u001c;T]\u0006\u00048\u000f[8u?\u0012*\u0017\u000f\u0006\u0002#c!9!gAA\u0001\u0002\u00049\u0013a\u0001=%c\u0005A1O\\1qg\"|G/\u0001\u0004va\u0012\fG/\u001a\u000b\u0002O\u0005Ir-\u001a;T]\u0006\u00048\u000f[8u\r>\u0014h+\u001a:tS>t\u0017i](g)\t9\u0003\bC\u0003:\r\u0001\u0007!(A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0005iY\u0014B\u0001\u001f\u001c\u0005\u0011auN\\4\u00027\u001d,Go\u00158baNDw\u000e\u001e$peRKW.Z:uC6\u0004\u0018i](g)\t9s\bC\u0003A\u000f\u0001\u0007!(A\u0005uS6,7\u000f^1na\u0006qQ\u000f\u001d3bi\u0016Le\u000e^3s]\u0006d\u0017aF4fi2{wmU3h[\u0016tGOR8s-\u0016\u00148/[8o)\r!u\t\u0014\t\u0003Q\u0015K!A\u0012\t\u0003\u00151{wmU3h[\u0016tG\u000fC\u0003I\u0013\u0001\u0007\u0011*A\bti\u0006\u0014Ho\u00115fG.\u0004x.\u001b8u!\rQ\"JO\u0005\u0003\u0017n\u0011aa\u00149uS>t\u0007bB'\n!\u0003\u0005\r!S\u0001\u000em\u0016\u00148/[8o)>du.\u00193\u0002C\u001d,G\u000fT8h'\u0016<W.\u001a8u\r>\u0014h+\u001a:tS>tG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003AS#!S),\u0003I\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u0013Ut7\r[3dW\u0016$'BA,\u001c\u0003)\tgN\\8uCRLwN\\\u0005\u00033R\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003E9W\r^*oCB\u001c\bn\u001c;Bi&s\u0017\u000e^\u0001\u000eO\u0016$8K\\1qg\"|G/\u0011;\u0015\u0005\u001dj\u0006\"B\u001d\r\u0001\u0004Q\u0014AD2sK\u0006$Xm\u00158baNDw\u000e\u001e\u000b\u0005O\u0001\u0014G\rC\u0003b\u001b\u0001\u0007A)A\u0004tK\u001elWM\u001c;\t\u000b\rl\u0001\u0019\u0001\u001e\u0002'1\f7\u000f^\"p[6LG\u000fV5nKN$\u0018-\u001c9\t\u000b\u0015l\u0001\u0019\u00014\u0002'A\u0014XM^5pkN\u001cf.\u00199tQ>$x\n\u001d;\u0011\u0007iQu%A\nwKJLg-\u001f#fYR\fg+\u001a:tS>t7\u000f\u0006\u0002#S\")!N\u0004a\u0001W\u0006Aa/\u001a:tS>t7\u000fE\u0002\u001bYjJ!!\\\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005!z\u0017B\u00019\u0011\u00051!U\r\u001c;b\u0019><\u0017*\u001c9m\u0001")
public interface SnapshotManagement {
    public SnapshotImpl currentSnapshot();

    public void currentSnapshot_$eq(SnapshotImpl var1);

    public static /* synthetic */ SnapshotImpl snapshot$(SnapshotManagement $this) {
        return $this.snapshot();
    }

    default public SnapshotImpl snapshot() {
        return this.currentSnapshot();
    }

    public static /* synthetic */ SnapshotImpl update$(SnapshotManagement $this) {
        return $this.update();
    }

    default public SnapshotImpl update() {
        return (SnapshotImpl)((DeltaLogImpl)this).lockInterruptibly((Function0 & Serializable & scala.Serializable)() -> this.updateInternal());
    }

    public static /* synthetic */ SnapshotImpl getSnapshotForVersionAsOf$(SnapshotManagement $this, long version) {
        return $this.getSnapshotForVersionAsOf(version);
    }

    default public SnapshotImpl getSnapshotForVersionAsOf(long version) {
        ((DeltaLogImpl)this).history().checkVersionExists(version);
        return this.getSnapshotAt(version);
    }

    public static /* synthetic */ SnapshotImpl getSnapshotForTimestampAsOf$(SnapshotManagement $this, long timestamp) {
        return $this.getSnapshotForTimestampAsOf(timestamp);
    }

    default public SnapshotImpl getSnapshotForTimestampAsOf(long timestamp) {
        DeltaHistoryManager.Commit latestCommit = ((DeltaLogImpl)this).history().getActiveCommitAtTime(new Timestamp(timestamp), ((DeltaLogImpl)this).history().getActiveCommitAtTime$default$2(), ((DeltaLogImpl)this).history().getActiveCommitAtTime$default$3(), ((DeltaLogImpl)this).history().getActiveCommitAtTime$default$4());
        return this.getSnapshotAt(latestCommit.version());
    }

    private SnapshotImpl updateInternal() {
        try {
            LogSegment newSegment;
            LogSegment logSegment = newSegment = this.getLogSegmentForVersion(this.currentSnapshot().logSegment().checkpointVersion(), this.getLogSegmentForVersion$default$2());
            LogSegment logSegment2 = this.currentSnapshot().logSegment();
            if (logSegment == null ? logSegment2 != null : !((Object)logSegment).equals(logSegment2)) {
                String startingFrom = (String)newSegment.checkpointVersion().map((Function1 & Serializable & scala.Serializable)v -> SnapshotManagement.$anonfun$updateInternal$1(BoxesRunTime.unboxToLong((Object)v))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".");
                ((Logging)((Object)this)).logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Loading version ").append(newSegment.version()).append(startingFrom).toString());
                SnapshotImpl newSnapshot = this.createSnapshot(newSegment, newSegment.lastCommitTimestamp(), (Option<SnapshotImpl>)new Some((Object)this.currentSnapshot()));
                if (this.currentSnapshot().version() > -1L) {
                    String string = this.currentSnapshot().metadataScala().id();
                    String string2 = newSnapshot.metadataScala().id();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        ((Logging)((Object)this)).logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append("Change in the table id detected while updating snapshot. ").append("\nPrevious snapshot = ").append(this.currentSnapshot()).append("\nNew snapshot = ").append(newSnapshot).append(".").toString());
                    }
                }
                ((Logging)((Object)this)).logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Updated snapshot to ").append(newSnapshot).toString());
                this.currentSnapshot_$eq(newSnapshot);
            }
        }
        catch (FileNotFoundException e) {
            if (Option$.MODULE$.apply((Object)e.getMessage()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("reconstruct state at version")))) {
                throw e;
            }
            ((Logging)((Object)this)).logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("No delta log found for the Delta table at ").append(((DeltaLogImpl)this).logPath()).toString());
            this.currentSnapshot_$eq(new InitialSnapshotImpl(((DeltaLogImpl)this).hadoopConf(), ((DeltaLogImpl)this).logPath(), (DeltaLogImpl)this));
        }
        return this.currentSnapshot();
    }

    public static /* synthetic */ LogSegment getLogSegmentForVersion$(SnapshotManagement $this, Option startCheckpoint, Option versionToLoad) {
        return $this.getLogSegmentForVersion((Option<Object>)startCheckpoint, (Option<Object>)versionToLoad);
    }

    default public LogSegment getLogSegmentForVersion(Option<Object> startCheckpoint, Option<Object> versionToLoad) {
        FileStatus[] newFiles = (FileStatus[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(((DeltaLogImpl)this).store().listFrom(FileNames$.MODULE$.checkpointPrefix(((DeltaLogImpl)this).logPath(), BoxesRunTime.unboxToLong((Object)startCheckpoint.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))), ((DeltaLogImpl)this).hadoopConf())).asScala()).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$2(file))).filterNot((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$3(file))).takeWhile((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)versionToLoad.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)v -> FileNames$.MODULE$.getFileVersion(f.getPath()) <= v))).toArray(ClassTag$.MODULE$.apply(FileStatus.class));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).isEmpty() && startCheckpoint.isEmpty()) {
            throw DeltaErrors$.MODULE$.emptyDirectoryException(((DeltaLogImpl)this).logPath().toString());
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).isEmpty()) {
            return this.getLogSegmentForVersion((Option<Object>)None$.MODULE$, versionToLoad);
        }
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileNames$.MODULE$.isCheckpointFile(f.getPath())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileStatus[] checkpoints = (FileStatus[])tuple2._1();
        FileStatus[] deltas = (FileStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)checkpoints, (Object)deltas);
        FileStatus[] checkpoints2 = (FileStatus[])tuple22._1();
        FileStatus[] deltas2 = (FileStatus[])tuple22._2();
        CheckpointInstance lastCheckpoint = (CheckpointInstance)versionToLoad.map((Function1 & Serializable & scala.Serializable)x$3 -> SnapshotManagement.$anonfun$getLogSegmentForVersion$7(BoxesRunTime.unboxToLong((Object)x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> CheckpointInstance$.MODULE$.MaxValue());
        CheckpointInstance[] checkpointFiles = (CheckpointInstance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkpoints2)).map((Function1 & Serializable & scala.Serializable)f -> CheckpointInstance$.MODULE$.apply(f.getPath()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CheckpointInstance.class)));
        Option<CheckpointInstance> newCheckpoint = ((Checkpoints)((Object)this)).getLatestCompleteCheckpointFromList(checkpointFiles, lastCheckpoint);
        if (newCheckpoint.isDefined()) {
            long newCheckpointVersion = ((CheckpointInstance)newCheckpoint.get()).version();
            Set newCheckpointPaths = ((CheckpointInstance)newCheckpoint.get()).getCorrespondingFiles(((DeltaLogImpl)this).logPath()).toSet();
            FileStatus[] deltasAfterCheckpoint = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$10(newCheckpointVersion, file)));
            long[] deltaVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltasAfterCheckpoint)).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)FileNames$.MODULE$.deltaVersion(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).nonEmpty()) {
                this.verifyDeltaVersions(deltaVersions);
                Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).head()) == newCheckpointVersion + 1L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Did not get the first delta ").append("file version: ").append(newCheckpointVersion + 1L).append(" to compute Snapshot").toString());
                versionToLoad.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).last()) == version, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Did not get the last delta file version: ").append(version).append(" to compute Snapshot").toString()));
            }
            long newVersion = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).lastOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((CheckpointInstance)newCheckpoint.get()).version()));
            FileStatus[] newCheckpointFiles = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkpoints2)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)newCheckpointPaths.contains((Object)f.getPath())));
            Predef$.MODULE$.assert(newCheckpointFiles.length == newCheckpointPaths.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Failed in getting the file information for:\n").append(newCheckpointPaths.mkString(" -", "\n -", "")).append("\n").append("among\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkpoints2)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).mkString(" -", "\n -", "")).toString());
            long lastCommitTimestamp = ((FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).last()).getModificationTime();
            return new LogSegment(((DeltaLogImpl)this).logPath(), newVersion, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])deltasAfterCheckpoint), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])newCheckpointFiles), (Option<Object>)newCheckpoint.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.version())), lastCommitTimestamp);
        }
        if (startCheckpoint.isDefined()) {
            throw DeltaErrors$.MODULE$.missingPartFilesException(BoxesRunTime.unboxToLong((Object)startCheckpoint.get()), new FileNotFoundException(new StringBuilder(45).append("Checkpoint file to load version: ").append(startCheckpoint.get()).append(" is missing.").toString()));
        }
        long[] deltaVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)FileNames$.MODULE$.deltaVersion(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        this.verifyDeltaVersions(deltaVersions);
        if (BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).head()) != 0L) {
            throw DeltaErrors$.MODULE$.logFileNotFoundException(FileNames$.MODULE$.deltaFile(((DeltaLogImpl)this).logPath(), 0L), BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).last()));
        }
        versionToLoad.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).last()) == version, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Did not get the last delta file version: ").append(version).append(" to compute Snapshot").toString()));
        FileStatus latestCommit = (FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).last();
        return new LogSegment(((DeltaLogImpl)this).logPath(), FileNames$.MODULE$.deltaVersion(latestCommit.getPath()), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])deltas2), (Seq<FileStatus>)Nil$.MODULE$, (Option<Object>)None$.MODULE$, latestCommit.getModificationTime());
    }

    public static /* synthetic */ Option getLogSegmentForVersion$default$2$(SnapshotManagement $this) {
        return $this.getLogSegmentForVersion$default$2();
    }

    default public Option<Object> getLogSegmentForVersion$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ SnapshotImpl getSnapshotAtInit$(SnapshotManagement $this) {
        return $this.getSnapshotAtInit();
    }

    /*
     * WARNING - void declaration
     */
    default public SnapshotImpl getSnapshotAtInit() {
        InitialSnapshotImpl initialSnapshotImpl;
        try {
            void var3_3;
            LogSegment logSegment = this.getLogSegmentForVersion((Option<Object>)((Checkpoints)((Object)this)).lastCheckpoint().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.version())), this.getLogSegmentForVersion$default$2());
            String startCheckpoint = (String)logSegment.checkpointVersion().map((Function1 & Serializable & scala.Serializable)v -> SnapshotManagement.$anonfun$getSnapshotAtInit$2(BoxesRunTime.unboxToLong((Object)v))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".");
            ((Logging)((Object)this)).logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Loading version ").append(logSegment.version()).append(startCheckpoint).toString());
            SnapshotImpl snapshot = this.createSnapshot(logSegment, logSegment.lastCommitTimestamp(), (Option<SnapshotImpl>)None$.MODULE$);
            ((Logging)((Object)this)).logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Returning initial snapshot ").append(snapshot).toString());
            initialSnapshotImpl = var3_3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ((Logging)((Object)this)).logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Creating initial snapshot without metadata, because the directory is empty");
            initialSnapshotImpl = new InitialSnapshotImpl(((DeltaLogImpl)this).hadoopConf(), ((DeltaLogImpl)this).logPath(), (DeltaLogImpl)this);
        }
        return initialSnapshotImpl;
    }

    private SnapshotImpl getSnapshotAt(long version) {
        if (this.snapshot().version() == version) {
            return this.snapshot();
        }
        Option<CheckpointInstance> startingCheckpoint = ((Checkpoints)((Object)this)).findLastCompleteCheckpoint(new CheckpointInstance(version, (Option<Object>)None$.MODULE$));
        LogSegment segment = this.getLogSegmentForVersion((Option<Object>)startingCheckpoint.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.version())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)version)));
        None$ previousSnapshotOpt = this.currentSnapshot().version() <= version ? new Some((Object)this.currentSnapshot()) : None$.MODULE$;
        return this.createSnapshot(segment, segment.lastCommitTimestamp(), (Option<SnapshotImpl>)previousSnapshotOpt);
    }

    private SnapshotImpl createSnapshot(LogSegment segment, long lastCommitTimestamp, Option<SnapshotImpl> previousSnapshotOpt) {
        previousSnapshotOpt.foreach((Function1 & Serializable & scala.Serializable)previousSnapshot -> {
            Predef$.MODULE$.assert(previousSnapshot.version() <= segment.version(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("Trying to create a Snapshot at version ").append(segment$1.version()).append(" yet you are passing a ").append("newer `previousSnapshotOpt` with version ").append(previousSnapshot.version()).append(".").toString());
            return BoxedUnit.UNIT;
        });
        return new SnapshotImpl(((DeltaLogImpl)this).hadoopConf(), ((DeltaLogImpl)this).logPath(), segment.version(), segment, ((DeltaLogImpl)this).minFileRetentionTimestamp(), (DeltaLogImpl)this, lastCommitTimestamp, (Option<SnapshotProtocolMetadataHint>)previousSnapshotOpt.map((Function1 & Serializable & scala.Serializable)previousSnapshot -> new SnapshotProtocolMetadataHint(previousSnapshot.protocolScala(), previousSnapshot.metadataScala(), previousSnapshot.version())));
    }

    private void verifyDeltaVersions(long[] versions) {
        Vector deltaVersions = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).toVector();
        if (deltaVersions.nonEmpty()) {
            NumericRange.Inclusive inclusive = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)deltaVersions.head()))).to(deltaVersions.last());
            Vector vector = deltaVersions;
            if (inclusive == null ? vector != null : !inclusive.equals(vector)) {
                throw DeltaErrors$.MODULE$.deltaVersionsNotContiguousException((Seq<Object>)deltaVersions);
            }
        }
    }

    public static /* synthetic */ String $anonfun$updateInternal$1(long v) {
        return new StringBuilder(35).append(" starting from checkpoint version ").append(v).append(".").toString();
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$2(FileStatus file) {
        return FileNames$.MODULE$.isCheckpointFile(file.getPath()) || FileNames$.MODULE$.isDeltaFile(file.getPath());
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$3(FileStatus file) {
        return FileNames$.MODULE$.isCheckpointFile(file.getPath()) && file.getLen() == 0L;
    }

    public static /* synthetic */ CheckpointInstance $anonfun$getLogSegmentForVersion$7(long x$3) {
        return new CheckpointInstance(x$3, (Option<Object>)None$.MODULE$);
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$10(long newCheckpointVersion$1, FileStatus file) {
        return FileNames$.MODULE$.deltaVersion(file.getPath()) > newCheckpointVersion$1;
    }

    public static /* synthetic */ String $anonfun$getSnapshotAtInit$2(long v) {
        return new StringBuilder(27).append(" starting from checkpoint ").append(v).append(".").toString();
    }

    public static void $init$(SnapshotManagement $this) {
        $this.currentSnapshot_$eq($this.getSnapshotAtInit());
    }
}

