/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.expressions;

import io.delta.standalone.data.RowRecord;
import io.delta.standalone.expressions.Expression;
import io.delta.standalone.expressions.Predicate;
import io.delta.standalone.internal.expressions.Util;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class In
implements Predicate {
    private final Expression value;
    private final List<? extends Expression> elems;
    private final Comparator<Object> comparator;

    public In(Expression expression, List<? extends Expression> list) {
        if (null == expression) {
            throw new IllegalArgumentException("'In' expression 'value' cannot be null");
        }
        if (null == list) {
            throw new IllegalArgumentException("'In' expression 'elems' cannot be null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("'In' expression 'elems' cannot be empty");
        }
        boolean bl = list.stream().allMatch(expression2 -> expression2.dataType().equivalent(expression.dataType()));
        if (!bl) {
            throw new IllegalArgumentException("In expression 'elems' and 'value' must all be of the same DataType");
        }
        this.value = expression;
        this.elems = list;
        this.comparator = Util.createComparator(expression.dataType());
    }

    @Override
    public Boolean eval(RowRecord rowRecord) {
        Object object = this.value.eval(rowRecord);
        if (null == object) {
            return null;
        }
        Boolean bl = false;
        for (Expression expression : this.elems) {
            Object object2 = expression.eval(rowRecord);
            if (object2 == null) {
                bl = null;
                continue;
            }
            if (this.comparator.compare(object, object2) != 0) continue;
            return true;
        }
        return bl;
    }

    @Override
    public String toString() {
        String string = this.elems.stream().map(Expression::toString).collect(Collectors.joining(", "));
        return this.value + " IN (" + string + ")";
    }

    @Override
    public List<Expression> children() {
        return Stream.concat(Stream.of(this.value), this.elems.stream()).collect(Collectors.toList());
    }
}

