/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.internal.CheckpointInstance;
import io.delta.standalone.internal.CheckpointInstance$;
import io.delta.standalone.internal.CheckpointMetaData;
import io.delta.standalone.internal.Checkpoints$;
import io.delta.standalone.internal.DeltaLogImpl;
import io.delta.standalone.internal.MetadataCleanup;
import io.delta.standalone.internal.SnapshotImpl;
import io.delta.standalone.internal.SnapshotManagement;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.sources.StandaloneHadoopConf$;
import io.delta.standalone.internal.util.FileNames$;
import io.delta.standalone.internal.util.JsonUtils$;
import io.delta.storage.CloseableIterator;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.util.control.NonFatal$;
import shadedelta.com.fasterxml.jackson.module.scala.ScalaObjectMapper;

@ScalaSignature(bytes="\u0006\u0001E4\u0011BD\b\u0011\u0002\u0007\u0005qbF/\t\u000by\u0001A\u0011\u0001\u0011\t\u000f\u0011\u0002!\u0019!C\u0001K!)!\u0007\u0001C\u0001g!)1\b\u0001C\u0001A!)1\b\u0001C\u0001y!)!\t\u0001C\u0005\u0007\")\u0011\n\u0001C\u0005\u0015\")\u0001\u000b\u0001C\t#\")A\u000b\u0001C\t+\u001e1\u0001m\u0004E\u0001\u001f\u00054aAD\b\t\u0002=\u0011\u0007\"B5\f\t\u0003Q\u0007\"B6\f\t\u0003a'aC\"iK\u000e\\\u0007o\\5oiNT!\u0001E\t\u0002\u0011%tG/\u001a:oC2T!AE\n\u0002\u0015M$\u0018M\u001c3bY>tWM\u0003\u0002\u0015+\u0005)A-\u001a7uC*\ta#\u0001\u0002j_N\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%\u0007\u0001!\u0012!\t\t\u00033\tJ!a\t\u000e\u0003\tUs\u0017\u000e^\u0001\u0010\u0019\u0006\u001bFkX\"I\u000b\u000e[\u0005kT%O)V\ta\u0005\u0005\u0002(a5\t\u0001F\u0003\u0002*U\u0005\u0011am\u001d\u0006\u0003W1\na\u0001[1e_>\u0004(BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001eL!!\r\u0015\u0003\tA\u000bG\u000f[\u0001\u000fY\u0006\u001cHo\u00115fG.\u0004x.\u001b8u+\u0005!\u0004cA\r6o%\u0011aG\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005aJT\"A\b\n\u0005iz!AE\"iK\u000e\\\u0007o\\5oi6+G/\u0019#bi\u0006\f!b\u00195fG.\u0004x.\u001b8u)\t\tS\bC\u0003?\u000b\u0001\u0007q(\u0001\u000bt]\u0006\u00048\u000f[8u)>\u001c\u0005.Z2la>Lg\u000e\u001e\t\u0003q\u0001K!!Q\b\u0003\u0019Ms\u0017\r]:i_RLU\u000e\u001d7\u0002)1|\u0017\rZ'fi\u0006$\u0017\r^1Ge>lg)\u001b7f)\t!D\tC\u0003F\r\u0001\u0007a)A\u0003ue&,7\u000f\u0005\u0002\u001a\u000f&\u0011\u0001J\u0007\u0002\u0004\u0013:$\u0018AF7b]V\fG\u000e\\=M_\u0006$7\t[3dWB|\u0017N\u001c;\u0015\u0005]Z\u0005\"\u0002'\b\u0001\u0004i\u0015AA2w!\tAd*\u0003\u0002P\u001f\t\u00112\t[3dWB|\u0017N\u001c;J]N$\u0018M\\2f\u0003i1\u0017N\u001c3MCN$8i\\7qY\u0016$Xm\u00115fG.\u0004x.\u001b8u)\t\u00116\u000bE\u0002\u001ak5CQ\u0001\u0014\u0005A\u00025\u000b1eZ3u\u0019\u0006$Xm\u001d;D_6\u0004H.\u001a;f\u0007\",7m\u001b9pS:$hI]8n\u0019&\u001cH\u000fF\u0002S-nCQaV\u0005A\u0002a\u000b\u0011\"\u001b8ti\u0006t7-Z:\u0011\u0007eIV*\u0003\u0002[5\t)\u0011I\u001d:bs\")A,\u0003a\u0001\u001b\u0006aan\u001c;MCR,'\u000f\u00165b]B\u0011\u0001HX\u0005\u0003?>\u0011A\u0002R3mi\u0006dunZ%na2\f1b\u00115fG.\u0004x.\u001b8ugB\u0011\u0001hC\n\u0004\u0017a\u0019\u0007C\u00013h\u001b\u0005)'B\u00014\u0010\u0003\u001dawnZ4j]\u001eL!\u0001[3\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!Y\u0001\u0010oJLG/Z\"iK\u000e\\\u0007o\\5oiR\u0019q'\\8\t\u000b9l\u0001\u0019A/\u0002\u0011\u0011,G\u000e^1M_\u001eDQ\u0001]\u0007A\u0002}\n\u0001b\u001d8baNDw\u000e\u001e")
public interface Checkpoints {
    public static CheckpointMetaData writeCheckpoint(DeltaLogImpl deltaLogImpl, SnapshotImpl snapshotImpl) {
        return Checkpoints$.MODULE$.writeCheckpoint(deltaLogImpl, snapshotImpl);
    }

    public void io$delta$standalone$internal$Checkpoints$_setter_$LAST_CHECKPOINT_$eq(Path var1);

    public Path LAST_CHECKPOINT();

    public static /* synthetic */ Option lastCheckpoint$(Checkpoints $this) {
        return $this.lastCheckpoint();
    }

    default public Option<CheckpointMetaData> lastCheckpoint() {
        return this.loadMetadataFromFile(0);
    }

    public static /* synthetic */ void checkpoint$(Checkpoints $this) {
        $this.checkpoint();
    }

    default public void checkpoint() {
        this.checkpoint(((SnapshotManagement)((Object)this)).snapshot());
    }

    public static /* synthetic */ void checkpoint$(Checkpoints $this, SnapshotImpl snapshotToCheckpoint) {
        $this.checkpoint(snapshotToCheckpoint);
    }

    default public void checkpoint(SnapshotImpl snapshotToCheckpoint) {
        if (!((DeltaLogImpl)this).hadoopConf().getBoolean(StandaloneHadoopConf$.MODULE$.CHECKPOINTING_ENABLED(), true)) {
            ((Logging)((Object)this)).logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Skipping writing Delta checkpoint for version ").append(snapshotToCheckpoint.version()).toString());
            return;
        }
        if (snapshotToCheckpoint.version() < 0L) {
            throw DeltaErrors$.MODULE$.checkpointNonExistTable(((DeltaLogImpl)this).dataPath());
        }
        CheckpointMetaData checkpointMetaData = Checkpoints$.MODULE$.writeCheckpoint((DeltaLogImpl)this, snapshotToCheckpoint);
        String json = JsonUtils$.MODULE$.toJson(checkpointMetaData, ManifestFactory$.MODULE$.classType(CheckpointMetaData.class));
        ((DeltaLogImpl)this).store().write(this.LAST_CHECKPOINT(), (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{json}))).asJava(), Predef$.MODULE$.boolean2Boolean(true), ((DeltaLogImpl)this).hadoopConf());
        ((MetadataCleanup)((Object)this)).doLogCleanup();
    }

    private Option<CheckpointMetaData> loadMetadataFromFile(int tries) {
        Option option;
        block10: {
            try (CloseableIterator checkpointMetadataJson = null;){
                try {
                    checkpointMetadataJson = ((DeltaLogImpl)this).store().read(this.LAST_CHECKPOINT(), ((DeltaLogImpl)this).hadoopConf());
                    CheckpointMetaData checkpointMetadata = (CheckpointMetaData)((ScalaObjectMapper)((Object)JsonUtils$.MODULE$.mapper())).readValue((String)checkpointMetadataJson.next(), ManifestFactory$.MODULE$.classType(CheckpointMetaData.class));
                    option = new Some((Object)checkpointMetadata);
                }
                catch (Throwable throwable) {
                    Option option2;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileNotFoundException) {
                        option = None$.MODULE$;
                        break block10;
                    }
                    Option option3 = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option3.isEmpty()) {
                        Throwable e = (Throwable)option3.get();
                        if (tries < 3) {
                            ((Logging)((Object)this)).logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Failed to parse ").append(this.LAST_CHECKPOINT()).append(". This may happen if there was an error ").append("during read operation, or a file appears to be partial. Sleeping and trying again.").toString(), e);
                            Thread.sleep(1000L);
                            option = this.loadMetadataFromFile(tries + 1);
                            break block10;
                        }
                    }
                    if (!(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option2.get();
                        ((Logging)((Object)this)).logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append(this.LAST_CHECKPOINT()).append(" is corrupted. Will search the checkpoint files directly").toString(), e);
                        Option<CheckpointInstance> verifiedCheckpoint = this.findLastCompleteCheckpoint(new CheckpointInstance(-1L, (Option<Object>)None$.MODULE$));
                        option = verifiedCheckpoint.map((Function1 & Serializable & scala.Serializable)cv -> this.manuallyLoadCheckpoint((CheckpointInstance)cv));
                        break block10;
                    }
                    throw throwable;
                }
            }
        }
        return option;
    }

    private CheckpointMetaData manuallyLoadCheckpoint(CheckpointInstance cv) {
        return new CheckpointMetaData(cv.version(), -1L, cv.numParts());
    }

    public static /* synthetic */ Option findLastCompleteCheckpoint$(Checkpoints $this, CheckpointInstance cv) {
        return $this.findLastCompleteCheckpoint(cv);
    }

    default public Option<CheckpointInstance> findLastCompleteCheckpoint(CheckpointInstance cv) {
        LongRef cur = LongRef.create((long)package$.MODULE$.max(cv.version(), 0L));
        while (cur.elem >= 0L) {
            CheckpointInstance[] checkpoints = (CheckpointInstance[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(((DeltaLogImpl)this).store().listFrom(FileNames$.MODULE$.checkpointPrefix(((DeltaLogImpl)this).logPath(), package$.MODULE$.max(0L, cur.elem - 1000L)), ((DeltaLogImpl)this).hadoopConf())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath()).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)FileNames$.MODULE$.isCheckpointFile(path))).map((Function1 & Serializable & scala.Serializable)x$4 -> CheckpointInstance$.MODULE$.apply((Path)x$4)).takeWhile((Function1 & Serializable & scala.Serializable)tv -> BoxesRunTime.boxToBoolean((boolean)Checkpoints.$anonfun$findLastCompleteCheckpoint$4(cur, cv, tv))).toArray(ClassTag$.MODULE$.apply(CheckpointInstance.class));
            Option<CheckpointInstance> lastCheckpoint = this.getLatestCompleteCheckpointFromList(checkpoints, cv);
            if (lastCheckpoint.isDefined()) {
                return lastCheckpoint;
            }
            cur.elem -= 1000L;
        }
        return None$.MODULE$;
    }

    public static /* synthetic */ Option getLatestCompleteCheckpointFromList$(Checkpoints $this, CheckpointInstance[] instances, CheckpointInstance notLaterThan) {
        return $this.getLatestCompleteCheckpointFromList(instances, notLaterThan);
    }

    default public Option<CheckpointInstance> getLatestCompleteCheckpointFromList(CheckpointInstance[] instances, CheckpointInstance notLaterThan) {
        Map complete = (Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instances)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isNotLaterThan(notLaterThan))))).groupBy((Function1 & Serializable & scala.Serializable)x -> (CheckpointInstance)Predef$.MODULE$.identity(x)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Checkpoints.$anonfun$getLatestCompleteCheckpointFromList$3(x0$1)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])complete.keys().toArray(ClassTag$.MODULE$.apply(CheckpointInstance.class)))).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())))).lastOption();
    }

    public static /* synthetic */ boolean $anonfun$findLastCompleteCheckpoint$4(LongRef cur$1, CheckpointInstance cv$1, CheckpointInstance tv) {
        return (cur$1.elem == 0L || tv.version() <= cur$1.elem) && tv.isEarlierThan(cv$1);
    }

    public static /* synthetic */ boolean $anonfun$getLatestCompleteCheckpointFromList$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Option<Object> option;
            CheckpointInstance checkpointInstance = (CheckpointInstance)tuple2._1();
            CheckpointInstance[] inst = (CheckpointInstance[])tuple2._2();
            if (checkpointInstance != null && None$.MODULE$.equals(option = checkpointInstance.numParts())) {
                return inst.length == 1;
            }
        }
        if (tuple2 != null) {
            Option<Object> option;
            CheckpointInstance checkpointInstance = (CheckpointInstance)tuple2._1();
            CheckpointInstance[] inst = (CheckpointInstance[])tuple2._2();
            if (checkpointInstance != null && (option = checkpointInstance.numParts()) instanceof Some) {
                Some some = (Some)option;
                int parts = BoxesRunTime.unboxToInt((Object)some.value());
                return inst.length == parts;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(Checkpoints $this) {
        $this.io$delta$standalone$internal$Checkpoints$_setter_$LAST_CHECKPOINT_$eq(new Path(((DeltaLogImpl)$this).logPath(), "_last_checkpoint"));
    }
}

