/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.util;

import io.delta.standalone.internal.logging.Logging;
import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;

public final class DeltaFileOperations$
implements Logging {
    public static final DeltaFileOperations$ MODULE$ = new DeltaFileOperations$();
    private static transient Logger io$delta$standalone$internal$logging$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    public Path tryRelativizePath(FileSystem fs, Path basePath, Path child, boolean ignoreError) {
        Path path;
        if (child.isAbsolute()) {
            try {
                path = new Path(fs.makeQualified(basePath).toUri().relativize(fs.makeQualified(child).toUri()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (ignoreError) {
                    path = child;
                }
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(33).append("Failed to relativize the path (").append(child).append(") ").toString()).append(new StringBuilder(48).append("with the base path (").append(basePath).append(") and the file system URI (").append(fs.getUri()).append(")").toString()).toString(), illegalArgumentException);
                throw new IllegalStateException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(941).append("Failed to relativize the path (").append(child).append("). This can happen when absolute paths make\n               |it into the transaction log, which start with the scheme\n               |s3://, wasbs:// or adls://. This is a bug that has existed before DBR 5.0.\n               |To fix this issue, please upgrade your writer jobs to DBR 5.0 and please run:\n               |%scala com.databricks.delta.Delta.fixAbsolutePathsInLog(\"").append(child).append("\").\n               |\n               |If this table was created with a shallow clone across file systems\n               |(different buckets/containers) and this table is NOT USED IN PRODUCTION, you can\n               |set the SQL configuration spark.databricks.delta.vacuum.relativize.ignoreError\n               |to true. Using this SQL configuration could lead to accidental data loss,\n               |therefore we do not recommend the use of this flag unless\n               |this is a shallow clone for testing purposes.\n             ").toString())));
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        } else {
            path = child;
        }
        return path;
    }

    public boolean tryRelativizePath$default$4() {
        return false;
    }

    private DeltaFileOperations$() {
    }
}

