/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.internal.BufferingLogDeletionIterator;
import io.delta.standalone.internal.CheckpointMetaData;
import io.delta.standalone.internal.Checkpoints;
import io.delta.standalone.internal.DeltaConfigs$;
import io.delta.standalone.internal.DeltaLogImpl;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.util.FileNames$;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0005Y3\u0011\u0002C\u0005\u0011\u0002\u0007\u0005\u0011\"\u0005*\t\u000ba\u0001A\u0011\u0001\u000e\t\u000by\u0001A\u0011A\u0010\t\u000b\r\u0002A\u0011\u0001\u0013\t\u000b!\u0002A\u0011\u0001\u000e\t\u000b%\u0002A\u0011\u0001\u000e\t\u000b)\u0002A\u0011B\u0016\t\u000b\u0019\u0003A\u0011B$\u0003\u001f5+G/\u00193bi\u0006\u001cE.Z1okBT!AC\u0006\u0002\u0011%tG/\u001a:oC2T!\u0001D\u0007\u0002\u0015M$\u0018M\u001c3bY>tWM\u0003\u0002\u000f\u001f\u0005)A-\u001a7uC*\t\u0001#\u0001\u0002j_N\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%\u0007\u0001!\u0012a\u0007\t\u0003'qI!!\b\u000b\u0003\tUs\u0017\u000e^\u0001\u0018K:\f'\r\\3FqBL'/\u001a3M_\u001e\u001cE.Z1okB,\u0012\u0001\t\t\u0003'\u0005J!A\t\u000b\u0003\u000f\t{w\u000e\\3b]\u0006!B-\u001a7uCJ+G/\u001a8uS>tW*\u001b7mSN,\u0012!\n\t\u0003'\u0019J!a\n\u000b\u0003\t1{gnZ\u0001\rI>dunZ\"mK\u0006tW\u000f]\u0001\u0013G2,\u0017M\\+q\u000bb\u0004\u0018N]3e\u0019><7/\u0001\u000bmSN$X\t\u001f9je\u0016$G)\u001a7uC2{wm\u001d\u000b\u0003Y\u0011\u00032!L\u001b9\u001d\tq3G\u0004\u00020e5\t\u0001G\u0003\u000223\u00051AH]8pizJ\u0011!F\u0005\u0003iQ\tq\u0001]1dW\u0006<W-\u0003\u00027o\tA\u0011\n^3sCR|'O\u0003\u00025)A\u0011\u0011HQ\u0007\u0002u)\u00111\bP\u0001\u0003MNT!!\u0010 \u0002\r!\fGm\\8q\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rS$A\u0003$jY\u0016\u001cF/\u0019;vg\")QI\u0002a\u0001K\u0005qa-\u001b7f\u0007V$xJ\u001a4US6,\u0017a\u0003;sk:\u001c\u0017\r^3ECf$\"\u0001\u0013)\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001B;uS2T\u0011!T\u0001\u0005U\u00064\u0018-\u0003\u0002P\u0015\nA1)\u00197f]\u0012\f'\u000fC\u0003R\u000f\u0001\u0007Q%\u0001\u0006uS6,W*\u001b7mSN\u0004\"a\u0015+\u000e\u0003%I!!V\u0005\u0003\u0019\u0011+G\u000e^1M_\u001eLU\u000e\u001d7")
public interface MetadataCleanup {
    public static /* synthetic */ boolean enableExpiredLogCleanup$(MetadataCleanup $this) {
        return $this.enableExpiredLogCleanup();
    }

    default public boolean enableExpiredLogCleanup() {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_EXPIRED_LOG_CLEANUP().fromMetadata(((DeltaLogImpl)this).metadata()));
    }

    public static /* synthetic */ long deltaRetentionMillis$(MetadataCleanup $this) {
        return $this.deltaRetentionMillis();
    }

    default public long deltaRetentionMillis() {
        return DeltaConfigs$.MODULE$.getMilliSeconds(DeltaConfigs$.MODULE$.LOG_RETENTION().fromMetadata(((DeltaLogImpl)this).metadata()));
    }

    public static /* synthetic */ void doLogCleanup$(MetadataCleanup $this) {
        $this.doLogCleanup();
    }

    default public void doLogCleanup() {
        block0: {
            if (!this.enableExpiredLogCleanup()) break block0;
            this.cleanUpExpiredLogs();
        }
    }

    public static /* synthetic */ void cleanUpExpiredLogs$(MetadataCleanup $this) {
        $this.cleanUpExpiredLogs();
    }

    default public void cleanUpExpiredLogs() {
        LazyRef formattedDate$lzy = new LazyRef();
        Date fileCutOffTime = this.truncateDay(((DeltaLogImpl)this).clock().getTimeMillis() - this.deltaRetentionMillis()).getTime();
        ((Logging)((Object)this)).logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Starting the deletion of log files older than ").append(MetadataCleanup.formattedDate$1(formattedDate$lzy, fileCutOffTime)).toString());
        IntRef numDeleted = IntRef.create((int)0);
        this.listExpiredDeltaLogs(fileCutOffTime.getTime()).map((Function1 & Serializable)x$1 -> x$1.getPath()).foreach((Function1 & Serializable)path -> {
            MetadataCleanup.$anonfun$cleanUpExpiredLogs$3(this, numDeleted, path);
            return BoxedUnit.UNIT;
        });
        ((Logging)((Object)this)).logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Deleted ").append(numDeleted$1.elem).append(" log files older than ").append(MetadataCleanup.formattedDate$1(formattedDate$lzy, fileCutOffTime)).toString());
    }

    private Iterator<FileStatus> listExpiredDeltaLogs(long fileCutOffTime) {
        Option<CheckpointMetaData> latestCheckpoint = ((Checkpoints)((Object)this)).lastCheckpoint();
        if (latestCheckpoint.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        long threshold = ((CheckpointMetaData)latestCheckpoint.get()).version() - 1L;
        Iterator files = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(((DeltaLogImpl)this).store().listFrom(FileNames$.MODULE$.checkpointPrefix(((DeltaLogImpl)this).logPath(), 0L), ((DeltaLogImpl)this).hadoopConf())).asScala()).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$listExpiredDeltaLogs$1(f)));
        return new BufferingLogDeletionIterator((Iterator<FileStatus>)files, fileCutOffTime, threshold, (Function1<Path, Object>)(Function1 & Serializable)filePath -> BoxesRunTime.boxToLong((long)MetadataCleanup.getVersion$1(filePath)));
    }

    private Calendar truncateDay(long timeMillis) {
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.setTimeInMillis(timeMillis);
        return DateUtils.truncate((Calendar)date, (int)5);
    }

    private static /* synthetic */ String formattedDate$lzycompute$1(LazyRef formattedDate$lzy$1, Date fileCutOffTime$1) {
        String string;
        LazyRef lazyRef = formattedDate$lzy$1;
        synchronized (lazyRef) {
            string = formattedDate$lzy$1.initialized() ? (String)formattedDate$lzy$1.value() : (String)formattedDate$lzy$1.initialize((Object)fileCutOffTime$1.toGMTString());
        }
        return string;
    }

    private static String formattedDate$1(LazyRef formattedDate$lzy$1, Date fileCutOffTime$1) {
        return formattedDate$lzy$1.initialized() ? (String)formattedDate$lzy$1.value() : MetadataCleanup.formattedDate$lzycompute$1(formattedDate$lzy$1, fileCutOffTime$1);
    }

    public static /* synthetic */ void $anonfun$cleanUpExpiredLogs$3(MetadataCleanup $this, IntRef numDeleted$1, Path path) {
        block0: {
            if (!((DeltaLogImpl)$this).fs().delete(path, false)) break block0;
            ++numDeleted$1.elem;
        }
    }

    public static /* synthetic */ boolean $anonfun$listExpiredDeltaLogs$1(FileStatus f) {
        return FileNames$.MODULE$.isCheckpointFile(f.getPath()) || FileNames$.MODULE$.isDeltaFile(f.getPath());
    }

    private static long getVersion$1(Path filePath) {
        return FileNames$.MODULE$.isCheckpointFile(filePath) ? FileNames$.MODULE$.checkpointVersion(filePath) : FileNames$.MODULE$.deltaVersion(filePath);
    }

    public static void $init$(MetadataCleanup $this) {
    }
}

