/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.CommitResult;
import io.delta.standalone.DeltaScan;
import io.delta.standalone.Operation;
import io.delta.standalone.OptimisticTransaction;
import io.delta.standalone.exceptions.DeltaStandaloneException;
import io.delta.standalone.expressions.Expression;
import io.delta.standalone.expressions.Literal;
import io.delta.standalone.internal.ConflictChecker;
import io.delta.standalone.internal.CurrentTransactionInfo;
import io.delta.standalone.internal.DeltaConfigs$;
import io.delta.standalone.internal.DeltaLogImpl;
import io.delta.standalone.internal.IsolationLevel;
import io.delta.standalone.internal.Serializable$;
import io.delta.standalone.internal.SnapshotImpl;
import io.delta.standalone.internal.SnapshotIsolation$;
import io.delta.standalone.internal.actions.Action;
import io.delta.standalone.internal.actions.AddFile;
import io.delta.standalone.internal.actions.CommitInfo;
import io.delta.standalone.internal.actions.CommitInfo$;
import io.delta.standalone.internal.actions.FileAction;
import io.delta.standalone.internal.actions.Format;
import io.delta.standalone.internal.actions.Metadata;
import io.delta.standalone.internal.actions.Protocol;
import io.delta.standalone.internal.actions.Protocol$;
import io.delta.standalone.internal.actions.RemoveFile;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.scan.DeltaScanImpl;
import io.delta.standalone.internal.sources.StandaloneHadoopConf$;
import io.delta.standalone.internal.util.ConversionUtils$;
import io.delta.standalone.internal.util.DeltaFileOperations$;
import io.delta.standalone.internal.util.FileNames$;
import io.delta.standalone.internal.util.SchemaMergingUtils$;
import io.delta.standalone.internal.util.SchemaUtils$;
import io.delta.standalone.package$;
import io.delta.standalone.types.StructType;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.util.Iterator;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\rh!\u0002\u001e<\u0001m\u001a\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011q\u0003!\u0011!Q\u0001\nuCQ\u0001\u0019\u0001\u0005\u0002\u0005Dq!\u001a\u0001C\u0002\u0013\u0005a\r\u0003\u0004n\u0001\u0001\u0006Ia\u001a\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019\u0019\b\u0001)A\u0005a\"AA\u000f\u0001b\u0001\n\u0003YT\u000fC\u0004\u0002\u0012\u0001\u0001\u000b\u0011\u0002<\t\u0013\u0005M\u0001A1A\u0005\n\u0005U\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\u0006\t\u0013\u0005\u001d\u0002A1A\u0005\n\u0005%\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\u000b\t\u0013\u0005}\u0002\u00011A\u0005\n\u0005\u0005\u0003\"CA%\u0001\u0001\u0007I\u0011BA&\u0011!\t9\u0006\u0001Q!\n\u0005\r\u0003\"CA-\u0001\u0001\u0007I\u0011BA!\u0011%\tY\u0006\u0001a\u0001\n\u0013\ti\u0006\u0003\u0005\u0002b\u0001\u0001\u000b\u0015BA\"\u0011%\t\u0019\u0007\u0001a\u0001\n\u0013\t)\u0007C\u0005\u0002t\u0001\u0001\r\u0011\"\u0003\u0002v!A\u0011\u0011\u0010\u0001!B\u0013\t9\u0007C\u0005\u0002|\u0001\u0001\r\u0011\"\u0003\u0002~!I\u0011q\u0011\u0001A\u0002\u0013%\u0011\u0011\u0012\u0005\t\u0003\u001b\u0003\u0001\u0015)\u0003\u0002\u0000!I\u0011q\u0012\u0001A\u0002\u0013%\u0011\u0011\t\u0005\n\u0003#\u0003\u0001\u0019!C\u0005\u0003'C\u0001\"a&\u0001A\u0003&\u00111\t\u0005\f\u00033\u0003\u0001\u0019!a\u0001\n\u0013\tY\nC\u0006\u0002$\u0002\u0001\r\u00111A\u0005\n\u0005\u0015\u0006bCAU\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;Cq!a+\u0001\t\u0003\ti\u000bC\u0004\u00020\u0002!\t!!-\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u0011q\u0018\u0001\u0005B\u0005\u0005\u0007bBA}\u0001\u0011\u0005\u00131 \u0005\b\u0005\u000f\u0001A\u0011\tB\u0005\u0011\u001d\u0011y\u0001\u0001C!\u0005#AqAa\u0005\u0001\t\u0003\u0012)\u0002C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t}\u0001\u0001\"\u0003\u0003\"!9!1\b\u0001\u0005\u0012\tu\u0002b\u0002B(\u0001\u0011%!\u0011\u000b\u0005\b\u00053\u0002A\u0011\u0002B.\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005GBqAa\u001d\u0001\t\u0013\u0011)\bC\u0004\u0003z\u0001!IAa\u001f\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\"9!\u0011\u0015\u0001\u0005\n\t\r\u0006b\u0002BU\u0001\u0011%\u00111\u0014\u0005\b\u0005W\u0003A\u0011\u0002BW\u0011)\u0011\t\f\u0001EC\u0002\u0013E!1\u0017\u0005\b\u0005k\u0003A\u0011\tB\\\u0011\u001d\u0011\u0019\r\u0001C!\u0005\u000bDqAa1\u0001\t\u0003\u0012I\rC\u0004\u0003X\u0002!\tE!7\t\u000f\t]\u0007\u0001\"\u0011\u0003^\nIr\n\u001d;j[&\u001cH/[2Ue\u0006t7/Y2uS>t\u0017*\u001c9m\u0015\taT(\u0001\u0005j]R,'O\\1m\u0015\tqt(\u0001\u0006ti\u0006tG-\u00197p]\u0016T!\u0001Q!\u0002\u000b\u0011,G\u000e^1\u000b\u0003\t\u000b!![8\u0014\t\u0001!E\n\u0015\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000bA\u0001\\1oO*\t\u0011*\u0001\u0003kCZ\f\u0017BA&G\u0005\u0019y%M[3diB\u0011QJT\u0007\u0002{%\u0011q*\u0010\u0002\u0016\u001fB$\u0018.\\5ti&\u001cGK]1og\u0006\u001cG/[8o!\t\tF+D\u0001S\u0015\t\u00196(A\u0004m_\u001e<\u0017N\\4\n\u0005U\u0013&a\u0002'pO\u001eLgnZ\u0001\tI\u0016dG/\u0019'pO\u000e\u0001\u0001CA-[\u001b\u0005Y\u0014BA.<\u00051!U\r\u001c;b\u0019><\u0017*\u001c9m\u0003!\u0019h.\u00199tQ>$\bCA-_\u0013\ty6H\u0001\u0007T]\u0006\u00048\u000f[8u\u00136\u0004H.\u0001\u0004=S:LGO\u0010\u000b\u0004E\u000e$\u0007CA-\u0001\u0011\u001516\u00011\u0001Y\u0011\u0015a6\u00011\u0001^\u0003}!U\t\u0014+B?6\u000b\u0005l\u0018*F)JKvlQ(N\u001b&#v,\u0011+U\u000b6\u0003FkU\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\t!.A\u0003tG\u0006d\u0017-\u0003\u0002mS\n\u0019\u0011J\u001c;\u0002A\u0011+E\nV!`\u001b\u0006CvLU#U%f{6iT'N\u0013R{\u0016\t\u0016+F\u001bB#6\u000bI\u0001\u0006ibt\u0017\nZ\u000b\u0002aB\u0011Q)]\u0005\u0003e\u001a\u0013aa\u0015;sS:<\u0017A\u0002;y]&#\u0007%A\u0004sK\u0006$G\u000b\u001f8\u0016\u0003Y\u00042a\u001e?\u007f\u001b\u0005A(BA={\u0003\u001diW\u000f^1cY\u0016T!a_5\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002~q\nY\u0011I\u001d:bs\n+hMZ3s!\ry\u0018Q\u0002\b\u0005\u0003\u0003\tI\u0001E\u0002\u0002\u0004%l!!!\u0002\u000b\u0007\u0005\u001dq+\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017I\u0017A\u0002)sK\u0012,g-C\u0002s\u0003\u001fQ1!a\u0003j\u0003!\u0011X-\u00193Uq:\u0004\u0013A\u0004:fC\u0012\u0004&/\u001a3jG\u0006$Xm]\u000b\u0003\u0003/\u0001Ba\u001e?\u0002\u001aA!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 u\n1\"\u001a=qe\u0016\u001c8/[8og&!\u00111EA\u000f\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0010e\u0016\fG\r\u0015:fI&\u001c\u0017\r^3tA\u0005I!/Z1e\r&dWm]\u000b\u0003\u0003W\u0001Ra^A\u0017\u0003cI1!a\fy\u0005\u001dA\u0015m\u001d5TKR\u0004B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oY\u0014aB1di&|gn]\u0005\u0005\u0003w\t)DA\u0004BI\u00124\u0015\u000e\\3\u0002\u0015I,\u0017\r\u001a$jY\u0016\u001c\b%A\tsK\u0006$G\u000b[3XQ>dW\rV1cY\u0016,\"!a\u0011\u0011\u0007!\f)%C\u0002\u0002H%\u0014qAQ8pY\u0016\fg.A\u000bsK\u0006$G\u000b[3XQ>dW\rV1cY\u0016|F%Z9\u0015\t\u00055\u00131\u000b\t\u0004Q\u0006=\u0013bAA)S\n!QK\\5u\u0011%\t)fDA\u0001\u0002\u0004\t\u0019%A\u0002yIE\n!C]3bIRCWm\u00165pY\u0016$\u0016M\u00197fA\u0005I1m\\7nSR$X\rZ\u0001\u000eG>lW.\u001b;uK\u0012|F%Z9\u0015\t\u00055\u0013q\f\u0005\n\u0003+\u0012\u0012\u0011!a\u0001\u0003\u0007\n!bY8n[&$H/\u001a3!\u0003-qWm^'fi\u0006$\u0017\r^1\u0016\u0005\u0005\u001d\u0004#\u00025\u0002j\u00055\u0014bAA6S\n1q\n\u001d;j_:\u0004B!a\r\u0002p%!\u0011\u0011OA\u001b\u0005!iU\r^1eCR\f\u0017a\u00048fo6+G/\u00193bi\u0006|F%Z9\u0015\t\u00055\u0013q\u000f\u0005\n\u0003+*\u0012\u0011!a\u0001\u0003O\nAB\\3x\u001b\u0016$\u0018\rZ1uC\u0002\n1B\\3x!J|Go\\2pYV\u0011\u0011q\u0010\t\u0006Q\u0006%\u0014\u0011\u0011\t\u0005\u0003g\t\u0019)\u0003\u0003\u0002\u0006\u0006U\"\u0001\u0003)s_R|7m\u001c7\u0002\u001f9,w\u000f\u0015:pi>\u001cw\u000e\\0%KF$B!!\u0014\u0002\f\"I\u0011Q\u000b\r\u0002\u0002\u0003\u0007\u0011qP\u0001\r]\u0016<\bK]8u_\u000e|G\u000eI\u0001\u0013SN\u001c%/Z1uS:<g*Z<UC\ndW-\u0001\fjg\u000e\u0013X-\u0019;j]\u001etUm\u001e+bE2,w\fJ3r)\u0011\ti%!&\t\u0013\u0005U3$!AA\u0002\u0005\r\u0013aE5t\u0007J,\u0017\r^5oO:+w\u000fV1cY\u0016\u0004\u0013AF2p[6LG/\u0011;uK6\u0004Ho\u0015;beR$\u0016.\\3\u0016\u0005\u0005u\u0005c\u00015\u0002 &\u0019\u0011\u0011U5\u0003\t1{gnZ\u0001\u001bG>lW.\u001b;BiR,W\u000e\u001d;Ti\u0006\u0014H\u000fV5nK~#S-\u001d\u000b\u0005\u0003\u001b\n9\u000bC\u0005\u0002Vy\t\t\u00111\u0001\u0002\u001e\u000692m\\7nSR\fE\u000f^3naR\u001cF/\u0019:u)&lW\rI\u0001\taJ|Go\\2pYV\u0011\u0011\u0011Q\u0001\u000e[\u0016$\u0018\rZ1uCN\u001b\u0017\r\\1\u0016\u0005\u00055\u0014\u0001C7fi\u0006$\u0017\r^1\u0015\u0005\u0005]\u0006\u0003BA]\u0003{k!!a/\u000b\u0007\u0005]R(\u0003\u0003\u0002r\u0005m\u0016AB2p[6LG/\u0006\u0003\u0002D\u0006eG\u0003CAc\u0003\u0017\fY/!>\u0011\u00075\u000b9-C\u0002\u0002Jv\u0012AbQ8n[&$(+Z:vYRDq!!4$\u0001\u0004\ty-\u0001\u0005bGRLwN\\:K!\u0015)\u0015\u0011[Ak\u0013\r\t\u0019N\u0012\u0002\t\u0013R,'/\u00192mKB!\u0011q[Am\u0019\u0001!q!a7$\u0005\u0004\tiNA\u0001U#\u0011\ty.!:\u0011\u0007!\f\t/C\u0002\u0002d&\u0014qAT8uQ&tw\r\u0005\u0003\u0002:\u0006\u001d\u0018\u0002BAu\u0003w\u0013a!Q2uS>t\u0007bBAwG\u0001\u0007\u0011q^\u0001\u0003_B\u00042!TAy\u0013\r\t\u00190\u0010\u0002\n\u001fB,'/\u0019;j_:Da!a>$\u0001\u0004q\u0018AC3oO&tW-\u00138g_\u0006yQ.\u0019:l\r&dWm]!t%\u0016\fG\r\u0006\u0003\u0002~\n\r\u0001cA'\u0002\u0000&\u0019!\u0011A\u001f\u0003\u0013\u0011+G\u000e^1TG\u0006t\u0007b\u0002B\u0003I\u0001\u0007\u0011\u0011D\u0001\u000ee\u0016\fG\r\u0015:fI&\u001c\u0017\r^3\u0002\u001dU\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCR!\u0011Q\nB\u0006\u0011\u001d\u0011i!\na\u0001\u0003o\u000b\u0011\"\\3uC\u0012\fG/\u0019&\u0002\u001dI,\u0017\rZ,i_2,G+\u00192mKR\u0011\u0011QJ\u0001\u000bibtg+\u001a:tS>tG\u0003BAO\u0005/AaA!\u0007(\u0001\u0004q\u0018AA5e\u0003-\u0011X-\u00193WKJ\u001c\u0018n\u001c8\u0015\u0005\u0005u\u0015!\u00049sKB\f'/Z\"p[6LG\u000f\u0006\u0003\u0003$\te\u0002C\u0002B\u0013\u0005_\u0011)D\u0004\u0003\u0003(\t-b\u0002BA\u0002\u0005SI\u0011A[\u0005\u0004\u0005[I\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005c\u0011\u0019DA\u0002TKFT1A!\fj!\u0011\t\u0019Da\u000e\n\t\u0005%\u0018Q\u0007\u0005\b\u0003oI\u0003\u0019\u0001B\u0012\u0003a!wnQ8n[&$(+\u001a;ss&#XM]1uSZ,G.\u001f\u000b\t\u0003;\u0013yDa\u0011\u0003F!9!\u0011\t\u0016A\u0002\u0005u\u0015AD1ui\u0016l\u0007\u000f\u001e,feNLwN\u001c\u0005\b\u0003oQ\u0003\u0019\u0001B\u0012\u0011\u001d\u00119E\u000ba\u0001\u0005\u0013\na\"[:pY\u0006$\u0018n\u001c8MKZ,G\u000eE\u0002Z\u0005\u0017J1A!\u0014<\u00059I5o\u001c7bi&|g\u000eT3wK2\f\u0001\u0002Z8D_6l\u0017\u000e\u001e\u000b\t\u0003;\u0013\u0019F!\u0016\u0003X!9!\u0011I\u0016A\u0002\u0005u\u0005bBA\u001cW\u0001\u0007!1\u0005\u0005\b\u0005\u000fZ\u0003\u0019\u0001B%\u0003)\u0001xn\u001d;D_6l\u0017\u000e\u001e\u000b\u0005\u0003\u001b\u0012i\u0006C\u0004\u0003`1\u0002\r!!(\u0002\u001b\r|W.\\5u-\u0016\u00148/[8o\u0003E\u0019\u0007.Z2l\r>\u00148i\u001c8gY&\u001cGo\u001d\u000b\u000b\u0003;\u0013)G!\u001b\u0003l\t=\u0004b\u0002B4[\u0001\u0007\u0011QT\u0001\rG\",7m\u001b,feNLwN\u001c\u0005\b\u0003oi\u0003\u0019\u0001B\u0012\u0011\u0019\u0011i'\fa\u0001O\u0006i\u0011\r\u001e;f[B$h*^7cKJDqA!\u001d.\u0001\u0004\u0011I%\u0001\u000bd_6l\u0017\u000e^%t_2\fG/[8o\u0019\u00164X\r\\\u0001\u0012m\u0016\u0014\u0018NZ=OK^lU\r^1eCR\fG\u0003BA'\u0005oBq!a-/\u0001\u0004\ti'A\u000bdQ\u0016\u001c7\u000eU1si&$\u0018n\u001c8D_2,XN\\:\u0015\r\u00055#Q\u0010BB\u0011\u001d\u0011yh\fa\u0001\u0005\u0003\u000bQ\u0002]1si&$\u0018n\u001c8D_2\u001c\b#\u0002B\u0013\u0005_q\bb\u0002BC_\u0001\u0007!qQ\u0001\u0007g\u000eDW-\\1\u0011\t\t%%qR\u0007\u0003\u0005\u0017S1A!$>\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0011\tJa#\u0003\u0015M#(/^2u)f\u0004X-A\rwKJLg-_*dQ\u0016l\u0017mQ8na\u0006$\u0018NY5mSRLH\u0003CA'\u0005/\u0013YJa(\t\u000f\te\u0005\u00071\u0001\u0003\b\u0006qQ\r_5ti&twmU2iK6\f\u0007b\u0002BOa\u0001\u0007!qQ\u0001\n]\u0016<8k\u00195f[\u0006Dq!a\u000e1\u0001\u0004\u0011\u0019#\u0001\ttQ>,H\u000eZ\"iK\u000e\\\u0007o\\5oiR!\u00111\tBS\u0011\u001d\u00119+\ra\u0001\u0003;\u000b\u0001cY8n[&$H/\u001a3WKJ\u001c\u0018n\u001c8\u0002+\u001d,GOT3yi\u0006#H/Z7qiZ+'o]5p]\u0006Ar/\u001b;i\u000f2|'-\u00197D_:4\u0017n\u001a#fM\u0006,H\u000e^:\u0015\t\u00055$q\u0016\u0005\b\u0003g\u001b\u0004\u0019AA7\u0003%awn\u001a)sK\u001aL\u00070F\u0001\u007f\u0003\u001dawnZ%oM>$B!!\u0014\u0003:\"A!1X\u001b\u0005\u0002\u0004\u0011i,A\u0002ng\u001e\u0004B\u0001\u001bB`}&\u0019!\u0011Y5\u0003\u0011q\u0012\u0017P\\1nKz\n!\u0002\\8h/\u0006\u0014h.\u001b8h)\u0011\tiEa2\t\u0011\tmf\u0007\"a\u0001\u0005{#b!!\u0014\u0003L\n5\u0007\u0002\u0003B^o\u0011\u0005\rA!0\t\u000f\t=w\u00071\u0001\u0003R\u0006IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0005\u0005K\u0011\u0019.\u0003\u0003\u0003V\nM\"!\u0003+ie><\u0018M\u00197f\u0003!awnZ#se>\u0014H\u0003BA'\u00057D\u0001Ba/9\t\u0003\u0007!Q\u0018\u000b\u0007\u0003\u001b\u0012yN!9\t\u0011\tm\u0016\b\"a\u0001\u0005{CqAa4:\u0001\u0004\u0011\t\u000e")
public class OptimisticTransactionImpl
implements OptimisticTransaction,
Logging {
    private String logPrefix;
    private final DeltaLogImpl deltaLog;
    private final SnapshotImpl snapshot;
    private final int DELTA_MAX_RETRY_COMMIT_ATTEMPTS;
    private String txnId;
    private final ArrayBuffer<String> readTxn;
    private final ArrayBuffer<Expression> readPredicates;
    private final HashSet<AddFile> readFiles;
    private boolean readTheWholeTable;
    private boolean committed;
    private Option<Metadata> newMetadata;
    private Option<Protocol> newProtocol;
    private boolean isCreatingNewTable;
    private long commitAttemptStartTime;
    private transient Logger io$delta$standalone$internal$logging$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return this.io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        this.io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    public int DELTA_MAX_RETRY_COMMIT_ATTEMPTS() {
        return this.DELTA_MAX_RETRY_COMMIT_ATTEMPTS;
    }

    private String txnId() {
        return this.txnId;
    }

    public ArrayBuffer<String> readTxn() {
        return this.readTxn;
    }

    private ArrayBuffer<Expression> readPredicates() {
        return this.readPredicates;
    }

    private HashSet<AddFile> readFiles() {
        return this.readFiles;
    }

    private boolean readTheWholeTable() {
        return this.readTheWholeTable;
    }

    private void readTheWholeTable_$eq(boolean x$1) {
        this.readTheWholeTable = x$1;
    }

    private boolean committed() {
        return this.committed;
    }

    private void committed_$eq(boolean x$1) {
        this.committed = x$1;
    }

    private Option<Metadata> newMetadata() {
        return this.newMetadata;
    }

    private void newMetadata_$eq(Option<Metadata> x$1) {
        this.newMetadata = x$1;
    }

    private Option<Protocol> newProtocol() {
        return this.newProtocol;
    }

    private void newProtocol_$eq(Option<Protocol> x$1) {
        this.newProtocol = x$1;
    }

    private boolean isCreatingNewTable() {
        return this.isCreatingNewTable;
    }

    private void isCreatingNewTable_$eq(boolean x$1) {
        this.isCreatingNewTable = x$1;
    }

    private long commitAttemptStartTime() {
        return this.commitAttemptStartTime;
    }

    private void commitAttemptStartTime_$eq(long x$1) {
        this.commitAttemptStartTime = x$1;
    }

    public Protocol protocol() {
        return (Protocol)this.newProtocol().getOrElse((Function0 & Serializable)() -> $this.snapshot.protocolScala());
    }

    public Metadata metadataScala() {
        return (Metadata)this.newMetadata().getOrElse((Function0 & Serializable)() -> $this.snapshot.metadataScala());
    }

    @Override
    public io.delta.standalone.actions.Metadata metadata() {
        return ConversionUtils$.MODULE$.convertMetadata(this.metadataScala());
    }

    @Override
    public <T extends io.delta.standalone.actions.Action> CommitResult commit(Iterable<T> actionsJ, Operation op, String engineInfo) {
        CommitInfo commitInfo;
        ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(actionsJ).asScala()).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends T, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof io.delta.standalone.actions.Metadata) {
                    io.delta.standalone.actions.Metadata metadata = (io.delta.standalone.actions.Metadata)A1;
                    return (B1)metadata;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(T x1) {
                T t = x1;
                return t instanceof io.delta.standalone.actions.Metadata;
            }
        })).foreach((Function1 & Serializable)m -> {
            this.updateMetadata(m);
            return BoxedUnit.UNIT;
        });
        Seq actions = ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(actionsJ).asScala()).map((Function1 & Serializable)external -> ConversionUtils$.MODULE$.convertActionJ((io.delta.standalone.actions.Action)external))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$commit$4(x$2)))).toSeq();
        Seq preparedActions = this.prepareCommit((Seq<Action>)actions);
        boolean noDataChanged = ((IterableOnceOps)actions.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof FileAction) {
                    FileAction fileAction = (FileAction)A1;
                    return (B1)BoxesRunTime.boxToBoolean((boolean)fileAction.dataChange());
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Action x2) {
                Action action = x2;
                return action instanceof FileAction;
            }
        })).forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$commit$5(BoxesRunTime.unboxToBoolean((Object)x$3))));
        IsolationLevel isolationLevelToUse = noDataChanged ? SnapshotIsolation$.MODULE$ : Serializable$.MODULE$;
        boolean dependsOnFiles = this.readPredicates().nonEmpty() || this.readFiles().nonEmpty();
        boolean onlyAddFiles = ((IterableOnceOps)preparedActions.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 instanceof FileAction) {
                    FileAction fileAction = (FileAction)A1;
                    return (B1)fileAction;
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Action x3) {
                Action action = x3;
                return action instanceof FileAction;
            }
        })).forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$commit$6(x$4)));
        boolean isBlindAppend = onlyAddFiles && !dependsOnFiles;
        CommitInfo commitInfo2 = commitInfo = CommitInfo$.MODULE$.apply(this.deltaLog.clock().getTimeMillis(), op.getName().toString(), (Map<String, String>)(op.getParameters() == null ? null : ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(op.getParameters()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.readVersion())).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$5 -> x$5 >= 0L), (Option<String>)Option$.MODULE$.apply((Object)((IsolationLevel)isolationLevelToUse).toString()), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)isBlindAppend)), (Option<Map<String, String>>)new Some((Object)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(op.getMetrics()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), (Option<String>)(op.getUserMetadata().isPresent() ? new Some((Object)op.getUserMetadata().get()) : None$.MODULE$), (Option<String>)new Some((Object)new StringBuilder(2).append(engineInfo.replaceAll("\\s", "-")).append(" ").append(package$.MODULE$.NAME().replaceAll("\\s", "-")).append("/").append(package$.MODULE$.VERSION()).toString()));
        preparedActions = (Seq)preparedActions.$plus$colon((Object)commitInfo2);
        this.commitAttemptStartTime_$eq(this.deltaLog.clock().getTimeMillis());
        long commitVersion = this.doCommitRetryIteratively(this.snapshot.version() + 1L, (Seq<Action>)preparedActions, isolationLevelToUse);
        this.postCommit(commitVersion);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Committed delta #").append(commitVersion).append(" to ").append($this.deltaLog.logPath()).toString());
        return new CommitResult(commitVersion);
    }

    @Override
    public DeltaScan markFilesAsRead(Expression readPredicate) {
        DeltaScanImpl scan = this.snapshot.scanScala(readPredicate);
        AddFile[] matchedFiles = scan.getFilesScala();
        Object object = scan.getPushedPredicate().isPresent() ? this.readPredicates().$plus$eq((Object)scan.getPushedPredicate().get()) : BoxedUnit.UNIT;
        this.readFiles().$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])matchedFiles));
        return scan;
    }

    @Override
    public void updateMetadata(io.delta.standalone.actions.Metadata metadataJ) {
        ObjectRef latestMetadata = ObjectRef.create((Object)ConversionUtils$.MODULE$.convertMetadataJ(metadataJ));
        if (this.newMetadata().contains((Object)((Metadata)latestMetadata.elem))) {
            return;
        }
        Predef$.MODULE$.assert(this.newMetadata().isEmpty(), (Function0 & Serializable)() -> "Cannot change the metadata more than once in a transaction.");
        if (this.readVersion() == -1L || this.isCreatingNewTable()) {
            latestMetadata.elem = this.withGlobalConfigDefaults((Metadata)latestMetadata.elem);
            this.isCreatingNewTable_$eq(true);
        }
        String string = this.snapshot.metadataScala().schemaString();
        String string2 = ((Metadata)latestMetadata.elem).schemaString();
        if (string == null ? string2 != null : !string.equals(string2)) {
            SchemaUtils$.MODULE$.checkUnenforceableNotNullConstraints(((Metadata)latestMetadata.elem).schema());
        }
        this.verifyNewMetadata((Metadata)latestMetadata.elem);
        this.checkPartitionColumns(((Metadata)latestMetadata.elem).partitionColumns(), ((Metadata)latestMetadata.elem).schema());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Updated metadata from ").append(this.newMetadata().getOrElse((Function0 & Serializable)() -> "-")).append(" to ").append((Metadata)latestMetadata$1.elem).toString());
        this.newMetadata_$eq((Option<Metadata>)new Some((Object)((Metadata)latestMetadata.elem)));
    }

    @Override
    public void readWholeTable() {
        this.readPredicates().$plus$eq((Object)Literal.True);
        this.readTheWholeTable_$eq(true);
    }

    @Override
    public long txnVersion(String id) {
        this.readTxn().$plus$eq((Object)id);
        return BoxesRunTime.unboxToLong((Object)this.snapshot.transactions().getOrElse((Object)id, (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    @Override
    public long readVersion() {
        return this.snapshot.version();
    }

    private Seq<Action> prepareCommit(Seq<Action> actions) {
        Seq finalActions;
        block4: {
            Option protocolOpt;
            Predef$.MODULE$.assert(!this.committed(), (Function0 & Serializable)() -> "Transaction already committed.");
            boolean customCommitInfo = actions.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$prepareCommit$2(x$6)));
            Predef$.MODULE$.assert(!customCommitInfo, (Function0 & Serializable)() -> "Cannot commit a custom CommitInfo in a transaction.");
            boolean relativizeIgnoreError = this.deltaLog.hadoopConf().getBoolean(StandaloneHadoopConf$.MODULE$.RELATIVE_PATH_IGNORE(), false);
            finalActions = (Seq)actions.map((Function1 & Serializable)x0$1 -> {
                Action action = x0$1;
                if (action instanceof AddFile) {
                    AddFile addFile = (AddFile)action;
                    return addFile.copy(DeltaFileOperations$.MODULE$.tryRelativizePath($this.deltaLog.fs(), $this.deltaLog.getPath(), new Path(addFile.path()), relativizeIgnoreError).toString(), addFile.copy$default$2(), addFile.copy$default$3(), addFile.copy$default$4(), addFile.copy$default$5(), addFile.copy$default$6(), addFile.copy$default$7());
                }
                if (action != null) {
                    Action action2 = action;
                    return action2;
                }
                throw new MatchError((Object)action);
            });
            this.newMetadata().foreach((Function1 & Serializable)m -> {
                this.verifySchemaCompatibility(this.snapshot.metadataScala().schema(), m.schema(), (Seq<Action>)actions);
                return BoxedUnit.UNIT;
            });
            finalActions = (Seq)Option$.MODULE$.option2Iterable(this.newMetadata()).toSeq().$plus$plus((IterableOnce)finalActions);
            if (this.snapshot.version() == -1L) {
                this.deltaLog.ensureLogDirectoryExist();
                if (!finalActions.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$prepareCommit$6(x$7)))) {
                    Protocol protocol = this.protocol();
                    finalActions = (Seq)finalActions.$plus$colon((Object)protocol);
                }
                if (!finalActions.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$prepareCommit$7(x$8)))) {
                    throw DeltaErrors$.MODULE$.metadataAbsentException();
                }
            }
            if ((protocolOpt = finalActions.collectFirst((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Protocol) {
                        Protocol protocol = (Protocol)A1;
                        return (B1)protocol;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    return action instanceof Protocol;
                }
            })).isDefined()) {
                Object object = protocolOpt.get();
                Protocol protocol = new Protocol(Protocol$.MODULE$.apply$default$1(), Protocol$.MODULE$.apply$default$2());
                Predef$.MODULE$.assert(!(object != null ? !object.equals(protocol) : protocol != null), (Function0 & Serializable)() -> new StringBuilder(92).append("Invalid Protocol ").append(((Protocol)protocolOpt.get()).simpleString()).append(". ").append("Currently only Protocol readerVersion 1 and writerVersion 2 is supported.").toString());
            }
            scala.collection.immutable.Set partitionColumns = this.metadataScala().partitionColumns().toSet();
            finalActions.foreach((Function1 & Serializable)x0$2 -> {
                OptimisticTransactionImpl.$anonfun$prepareCommit$9(partitionColumns, x0$2);
                return BoxedUnit.UNIT;
            });
            this.deltaLog.assertProtocolWrite(this.snapshot.protocolScala());
            Seq removes = (Seq)actions.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof RemoveFile) {
                        RemoveFile removeFile = (RemoveFile)A1;
                        return (B1)removeFile;
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Action x2) {
                    Action action = x2;
                    return action instanceof RemoveFile;
                }
            });
            if (!removes.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.dataChange()))) break block4;
            this.deltaLog.assertRemovable();
        }
        return finalActions;
    }

    public long doCommitRetryIteratively(long attemptVersion, Seq<Action> actions, IsolationLevel isolationLevel) {
        return BoxesRunTime.unboxToLong(this.deltaLog.lockInterruptibly((JFunction0.mcJ.sp & Serializable)() -> {
            boolean tryCommit = true;
            long commitVersion = attemptVersion;
            int attemptNumber = 0;
            while (tryCommit) {
                try {
                    long l;
                    if (attemptNumber == 0) {
                        l = this.doCommit(commitVersion, actions, isolationLevel);
                    } else {
                        if (attemptNumber > this.DELTA_MAX_RETRY_COMMIT_ATTEMPTS()) {
                            long totalCommitAttemptTime = $this.deltaLog.clock().getTimeMillis() - this.commitAttemptStartTime();
                            throw DeltaErrors$.MODULE$.maxCommitRetriesExceededException(attemptNumber, commitVersion, attemptVersion, actions.length(), totalCommitAttemptTime);
                        }
                        commitVersion = this.checkForConflicts(commitVersion, actions, attemptNumber, isolationLevel);
                        l = this.doCommit(commitVersion, actions, isolationLevel);
                    }
                    tryCommit = false;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    ++attemptNumber;
                }
            }
            return commitVersion;
        }));
    }

    private long doCommit(long attemptVersion, Seq<Action> actions, IsolationLevel isolationLevel) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Attempting to commit version ").append(attemptVersion).append(" with ").append(actions.size()).append(" actions with ").append(isolationLevel).append(" isolation level").toString());
        if (this.readVersion() > -1L) {
            String string = this.metadata().getId();
            String string2 = this.snapshot.getMetadata().getId();
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(123).append("Change in the table id detected in txn. Table id for txn on table at ").append($this.deltaLog.dataPath()).append(" was ").append($this.snapshot.getMetadata().getId()).append(" when the txn was created and ").append("is now changed to ").append(this.metadata().getId()).append(".").toString());
            }
        }
        this.deltaLog.store().write(FileNames$.MODULE$.deltaFile(this.deltaLog.logPath(), attemptVersion), (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(((IterableOnceOps)actions.map((Function1 & Serializable)x$10 -> x$10.json())).toIterator()).asJava(), Predef$.MODULE$.boolean2Boolean(false), this.deltaLog.hadoopConf());
        SnapshotImpl postCommitSnapshot = this.deltaLog.update();
        if (postCommitSnapshot.version() < attemptVersion) {
            throw new IllegalStateException(new StringBuilder(54).append("The committed version is ").append(attemptVersion).append(" ").append("but the current version is ").append(postCommitSnapshot.version()).append(".").toString());
        }
        return attemptVersion;
    }

    private void postCommit(long commitVersion) {
        this.committed_$eq(true);
        if (this.shouldCheckpoint(commitVersion)) {
            try {
                this.deltaLog.checkpoint(this.deltaLog.getSnapshotForVersionAsOf(commitVersion));
            }
            catch (IllegalStateException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to checkpoint table state.", e);
            }
            return;
        }
    }

    private long checkForConflicts(long checkVersion, Seq<Action> actions, int attemptNumber, IsolationLevel commitIsolationLevel) {
        long nextAttemptVersion = this.getNextAttemptVersion();
        CurrentTransactionInfo currentTransactionInfo = new CurrentTransactionInfo((Seq<Expression>)this.readPredicates().toSeq(), (scala.collection.immutable.Set<AddFile>)this.readFiles().toSet(), this.readTheWholeTable(), (scala.collection.immutable.Set<String>)this.readTxn().toSet(), this.metadataScala(), actions, this.deltaLog);
        String logPrefixStr = new StringBuilder(10).append("[attempt ").append(attemptNumber).append("]").toString();
        LongRef adds = LongRef.create((long)0L);
        LongRef removes = LongRef.create((long)0L);
        currentTransactionInfo.actions().foreach((Function1 & Serializable)x0$1 -> {
            OptimisticTransactionImpl.$anonfun$checkForConflicts$1(adds, removes, x0$1);
            return BoxedUnit.UNIT;
        });
        String txnDetailsLogStr = new StringBuilder(46).append(adds.elem).append(" adds, ").append(removes.elem).append(" removes, ").append(this.readPredicates().size()).append(" read predicates, ").append(this.readFiles().size()).append(" read files").toString();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append(logPrefixStr).append(" Checking for conflicts with versions ").append("[").append(checkVersion).append(", ").append(nextAttemptVersion).append(") with current txn having ").append(txnDetailsLogStr).toString());
        new RichLong(Predef$.MODULE$.longWrapper(checkVersion)).until((Object)BoxesRunTime.boxToLong((long)nextAttemptVersion)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)otherCommitVersion -> {
            ConflictChecker conflictChecker = new ConflictChecker(currentTransactionInfo, otherCommitVersion, commitIsolationLevel, logPrefixStr);
            conflictChecker.checkConflicts();
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append(logPrefixStr).append(" No conflicts in version ").append(otherCommitVersion).append(", ").append($this.deltaLog.clock().getTimeMillis() - this.commitAttemptStartTime()).append(" ms since start").toString());
        });
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append(logPrefixStr).append(" No conflicts with versions [").append(checkVersion).append(", ").append(nextAttemptVersion).append(") ").append("with current txn having ").append(txnDetailsLogStr).append(", ").append($this.deltaLog.clock().getTimeMillis() - this.commitAttemptStartTime()).append(" ms since start").toString());
        return nextAttemptVersion;
    }

    private void verifyNewMetadata(Metadata metadata) {
        SchemaMergingUtils$.MODULE$.checkColumnNameDuplication(metadata.schema(), "in the metadata update");
        SchemaUtils$.MODULE$.checkFieldNames(SchemaMergingUtils$.MODULE$.explodeNestedFieldNames(metadata.dataSchema()));
        try {
            SchemaUtils$.MODULE$.checkFieldNames(metadata.partitionColumns());
        }
        catch (DeltaStandaloneException e) {
            throw DeltaErrors$.MODULE$.invalidPartitionColumn(e);
        }
        Protocol$.MODULE$.checkMetadataProtocolProperties(metadata, this.protocol());
    }

    private void checkPartitionColumns(Seq<String> partitionCols, StructType schema) {
        scala.collection.immutable.Set schemaCols = Predef$.MODULE$.wrapRefArray((Object[])schema.getFieldNames()).toSet();
        Seq partitionsColsNotInSchema = partitionCols.toSet().diff((Set)schemaCols).toSeq();
        if (partitionsColsNotInSchema.nonEmpty()) {
            throw DeltaErrors$.MODULE$.partitionColumnsNotFoundException((Seq<String>)partitionsColsNotInSchema, schema);
        }
        if (partitionCols.length() == schemaCols.size()) {
            throw DeltaErrors$.MODULE$.nonPartitionColumnAbsentException();
        }
    }

    private void verifySchemaCompatibility(StructType existingSchema, StructType newSchema, Seq<Action> actions) {
        boolean tableEmpty;
        LazyBoolean allCurrentFilesRemoved$lzy = new LazyBoolean();
        boolean bl = tableEmpty = this.snapshot.numOfFiles() == 0L;
        if (tableEmpty || this.allCurrentFilesRemoved$1(allCurrentFilesRemoved$lzy, actions)) {
            return;
        }
        if (!existingSchema.isWriteCompatible(newSchema)) {
            throw DeltaErrors$.MODULE$.schemaChangedException(existingSchema, newSchema);
        }
    }

    private boolean shouldCheckpoint(long committedVersion) {
        boolean checkpointingEnabled = this.deltaLog.hadoopConf().getBoolean(StandaloneHadoopConf$.MODULE$.CHECKPOINTING_ENABLED(), true);
        return checkpointingEnabled && committedVersion != 0L && committedVersion % (long)this.deltaLog.checkpointInterval() == 0L;
    }

    private long getNextAttemptVersion() {
        this.deltaLog.update();
        return this.deltaLog.snapshot().version() + 1L;
    }

    private Metadata withGlobalConfigDefaults(Metadata metadata) {
        Map<String, String> x$1 = DeltaConfigs$.MODULE$.mergeGlobalConfigs(this.deltaLog.hadoopConf(), metadata.configuration());
        String x$2 = metadata.copy$default$1();
        String x$3 = metadata.copy$default$2();
        String x$4 = metadata.copy$default$3();
        Format x$5 = metadata.copy$default$4();
        String x$6 = metadata.copy$default$5();
        Seq<String> x$7 = metadata.copy$default$6();
        Option<Object> x$8 = metadata.copy$default$8();
        return metadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
    }

    private String logPrefix$lzycompute() {
        OptimisticTransactionImpl optimisticTransactionImpl = this;
        synchronized (optimisticTransactionImpl) {
            if (!this.bitmap$0) {
                this.logPrefix = new StringBuilder(18).append("[tableId=").append(OptimisticTransactionImpl.truncate$1(this.snapshot.metadataScala().id())).append(",txnId=").append(OptimisticTransactionImpl.truncate$1(this.txnId())).append("] ").toString();
                this.bitmap$0 = true;
            }
        }
        this.txnId = null;
        return this.logPrefix;
    }

    public String logPrefix() {
        if (!this.bitmap$0) {
            return this.logPrefix$lzycompute();
        }
        return this.logPrefix;
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, (Function0 & Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString());
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, (Function0 & Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString());
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, (Function0 & Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString(), throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, (Function0 & Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString());
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, (Function0 & Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString(), throwable);
    }

    public static final /* synthetic */ boolean $anonfun$commit$4(Action x$2) {
        return !(x$2 instanceof Metadata);
    }

    public static final /* synthetic */ boolean $anonfun$commit$5(boolean x$3) {
        return !x$3;
    }

    public static final /* synthetic */ boolean $anonfun$commit$6(FileAction x$4) {
        return x$4 instanceof AddFile;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommit$2(Action x$6) {
        return x$6 instanceof CommitInfo;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommit$6(Action x$7) {
        return x$7 instanceof Protocol;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommit$7(Action x$8) {
        return x$8 instanceof Metadata;
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$9(scala.collection.immutable.Set partitionColumns$1, Action x0$2) {
        Action action = x0$2;
        if (action instanceof AddFile) {
            AddFile addFile = (AddFile)action;
            scala.collection.immutable.Set set = partitionColumns$1;
            scala.collection.immutable.Set set2 = addFile.partitionValues().keySet();
            if (set == null ? set2 != null : !set.equals(set2)) {
                throw DeltaErrors$.MODULE$.addFilePartitioningMismatchException((Seq<String>)addFile.partitionValues().keySet().toSeq(), (Seq<String>)partitionColumns$1.toSeq());
            }
        }
    }

    public static final /* synthetic */ void $anonfun$checkForConflicts$1(LongRef adds$1, LongRef removes$1, Action x0$1) {
        Action action = x0$1;
        if (action instanceof AddFile) {
            ++adds$1.elem;
            return;
        }
        if (action instanceof RemoveFile) {
            ++removes$1.elem;
            return;
        }
    }

    private final /* synthetic */ boolean allCurrentFilesRemoved$lzycompute$1(LazyBoolean allCurrentFilesRemoved$lzy$1, Seq actions$4) {
        boolean bl;
        LazyBoolean lazyBoolean = allCurrentFilesRemoved$lzy$1;
        synchronized (lazyBoolean) {
            boolean bl2;
            if (allCurrentFilesRemoved$lzy$1.initialized()) {
                bl2 = allCurrentFilesRemoved$lzy$1.value();
            } else {
                Seq removeFiles = (Seq)actions$4.collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof RemoveFile) {
                            RemoveFile removeFile = (RemoveFile)A1;
                            return (B1)removeFile;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Action x1) {
                        Action action = x1;
                        return action instanceof RemoveFile;
                    }
                });
                scala.collection.immutable.Set set = ((IterableOnceOps)removeFiles.map((Function1 & Serializable)x$11 -> x$11.path())).toSet();
                scala.collection.immutable.Set set2 = ((IterableOnceOps)this.snapshot.allFilesScala().map((Function1 & Serializable)x$12 -> x$12.path())).toSet();
                bl2 = allCurrentFilesRemoved$lzy$1.initialize(!(set != null ? !set.equals(set2) : set2 != null));
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean allCurrentFilesRemoved$1(LazyBoolean allCurrentFilesRemoved$lzy$1, Seq actions$4) {
        if (allCurrentFilesRemoved$lzy$1.initialized()) {
            return allCurrentFilesRemoved$lzy$1.value();
        }
        return this.allCurrentFilesRemoved$lzycompute$1(allCurrentFilesRemoved$lzy$1, actions$4);
    }

    private static final String truncate$1(String uuid) {
        return (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])uuid.split("-")));
    }

    public OptimisticTransactionImpl(DeltaLogImpl deltaLog, SnapshotImpl snapshot) {
        this.deltaLog = deltaLog;
        this.snapshot = snapshot;
        Logging.$init$(this);
        this.DELTA_MAX_RETRY_COMMIT_ATTEMPTS = 10000000;
        this.txnId = UUID.randomUUID().toString();
        this.readTxn = new ArrayBuffer();
        this.readPredicates = new ArrayBuffer();
        this.readFiles = new HashSet();
        this.readTheWholeTable = false;
        this.committed = false;
        this.newMetadata = None$.MODULE$;
        this.newProtocol = None$.MODULE$;
        this.isCreatingNewTable = false;
    }
}

