/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.storage;

import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.storage.HadoopFileSystemLogStore;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua!B\u0006\r\u000191\u0002\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011I\u0012\t\u0013A\u0002!\u0011!Q\u0001\n\u0011\n\u0004\"\u0002\u001a\u0001\t\u0003\u0019\u0004b\u0002\u001c\u0001\u0005\u0004%\ta\u000e\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001d\t\u000b\u0005\u0003A\u0011\t\"\t\u000b)\u0004A\u0011I6\t\u000b9\u0004A\u0011B8\t\u000by\u0004A\u0011B@\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e\ta\u0001\n\u0012$T\u0019><7\u000b^8sK*\u0011QBD\u0001\bgR|'/Y4f\u0015\ty\u0001#\u0001\u0005j]R,'O\\1m\u0015\t\t\"#\u0001\u0006ti\u0006tG-\u00197p]\u0016T!a\u0005\u000b\u0002\u000b\u0011,G\u000e^1\u000b\u0003U\t!![8\u0014\u0007\u000192\u0004\u0005\u0002\u001935\tA\"\u0003\u0002\u001b\u0019\tA\u0002*\u00193p_B4\u0015\u000e\\3TsN$X-\u001c'pON#xN]3\u0011\u0005qyR\"A\u000f\u000b\u0005yq\u0011a\u00027pO\u001eLgnZ\u0005\u0003Au\u0011q\u0001T8hO&tw-\u0001\bj]&$\b*\u00193p_B\u001cuN\u001c4\u0004\u0001U\tA\u0005\u0005\u0002&]5\taE\u0003\u0002(Q\u0005!1m\u001c8g\u0015\tI#&\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014x-\u0003\u00020M\ti1i\u001c8gS\u001e,(/\u0019;j_:\fq\"\u001b8ji\"\u000bGm\\8q\u0007>tg\rI\u0005\u0003Ce\ta\u0001P5oSRtDC\u0001\u001b6!\tA\u0002\u0001C\u0003\"\u0007\u0001\u0007A%\u0001\u0013o_\u0006\u00137\u000f\u001e:bGR4\u0015\u000e\\3TsN$X-\\#yG\u0016\u0004H/[8o\u001b\u0016\u001c8/Y4f+\u0005A\u0004CA\u001d?\u001b\u0005Q$BA\u001e=\u0003\u0011a\u0017M\\4\u000b\u0003u\nAA[1wC&\u0011qH\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002K9|\u0017IY:ue\u0006\u001cGOR5mKNK8\u000f^3n\u000bb\u001cW\r\u001d;j_:lUm]:bO\u0016\u0004\u0013!B<sSR,G#B\"J#\u000eD\u0007C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%\u0001B+oSRDQA\u0013\u0004A\u0002-\u000bA\u0001]1uQB\u0011AjT\u0007\u0002\u001b*\u0011a\nK\u0001\u0003MNL!\u0001U'\u0003\tA\u000bG\u000f\u001b\u0005\u0006%\u001a\u0001\raU\u0001\bC\u000e$\u0018n\u001c8t!\r!v+W\u0007\u0002+*\u0011a\u000bP\u0001\u0005kRLG.\u0003\u0002Y+\nA\u0011\n^3sCR|'\u000f\u0005\u0002[C:\u00111l\u0018\t\u00039\u0016k\u0011!\u0018\u0006\u0003=\n\na\u0001\u0010:p_Rt\u0014B\u00011F\u0003\u0019\u0001&/\u001a3fM&\u0011qH\u0019\u0006\u0003A\u0016CQ\u0001\u001a\u0004A\u0002\u0015\f\u0011b\u001c<fe^\u0014\u0018\u000e^3\u0011\u0005e2\u0017BA4;\u0005\u001d\u0011un\u001c7fC:DQ!\u001b\u0004A\u0002\u0011\n!\u0002[1e_>\u00048i\u001c8g\u0003UI7\u000fU1si&\fGn\u0016:ji\u00164\u0016n]5cY\u0016$2!\u001a7n\u0011\u0015Qu\u00011\u0001L\u0011\u0015Iw\u00011\u0001%\u000359(/\u001b;f\u0013:$XM\u001d8bYR)1\t]9{{\")!\n\u0003a\u0001\u0017\")!\u000b\u0003a\u0001eB\u00191\u000f_-\u000f\u0005Q4hB\u0001/v\u0013\u00051\u0015BA<F\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001W=\u000b\u0005],\u0005\"\u00023\t\u0001\u0004Y\bC\u0001#}\u0013\t9W\tC\u0003j\u0011\u0001\u0007A%\u0001\bhKR4\u0015\u000e\\3D_:$X\r\u001f;\u0015\r\u0005\u0005\u0011qAA\u0005!\ra\u00151A\u0005\u0004\u0003\u000bi%a\u0003$jY\u0016\u001cuN\u001c;fqRDQAS\u0005A\u0002-CQ![\u0005A\u0002\u0011\n\u0001\u0003\u001e:z%\u0016lwN^3De\u000e4\u0015\u000e\\3\u0015\u000b\r\u000by!a\u0005\t\u000f\u0005E!\u00021\u0001\u0002\u0002\u0005\u0011am\u0019\u0005\u0006\u0015*\u0001\ra\u0013")
public class HDFSLogStore
extends HadoopFileSystemLogStore
implements Logging {
    private final String noAbstractFileSystemExceptionMessage;
    private transient Logger io$delta$standalone$internal$logging$Logging$$log_;

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return this.io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        this.io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    @Override
    public Configuration initHadoopConf() {
        return super.initHadoopConf();
    }

    public String noAbstractFileSystemExceptionMessage() {
        return this.noAbstractFileSystemExceptionMessage;
    }

    public void write(Path path, java.util.Iterator<String> actions, Boolean overwrite, Configuration hadoopConf) {
        boolean isLocalFs = path.getFileSystem(hadoopConf) instanceof RawLocalFileSystem;
        if (isLocalFs) {
            HDFSLogStore hDFSLogStore = this;
            synchronized (hDFSLogStore) {
                this.writeInternal(path, (Iterator<String>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(actions).asScala()), Predef$.MODULE$.Boolean2boolean(overwrite), hadoopConf);
            }
            return;
        }
        this.writeInternal(path, (Iterator<String>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(actions).asScala()), Predef$.MODULE$.Boolean2boolean(overwrite), hadoopConf);
    }

    public Boolean isPartialWriteVisible(Path path, Configuration hadoopConf) {
        return Predef$.MODULE$.boolean2Boolean(true);
    }

    private void writeInternal(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        FileContext fileContext;
        try {
            fileContext = this.getFileContext(path, hadoopConf);
        }
        catch (Throwable throwable) {
            IOException iOException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException && (iOException = (IOException)throwable2).getMessage().contains(this.noAbstractFileSystemExceptionMessage())) {
                Throwable newException = DeltaErrors$.MODULE$.incorrectLogStoreImplementationException(iOException);
                this.logError((Function0<String>)(Function0 & Serializable)() -> newException.getMessage(), newException.getCause());
                throw newException;
            }
            throw throwable;
        }
        FileContext fc = fileContext;
        if (!overwrite && fc.util().exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        Path tempPath = this.createTempPath(path);
        boolean streamClosed = false;
        boolean renameDone = false;
        FSDataOutputStream stream = fc.create(tempPath, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.checksumParam((Options.ChecksumOpt)Options.ChecksumOpt.createDisabled())});
        try {
            actions.map((Function1 & Serializable)x$1 -> new StringBuilder(1).append((String)x$1).append("\n").toString()).map((Function1 & Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable)x$1 -> {
                stream.write(x$1);
                return BoxedUnit.UNIT;
            });
            stream.close();
            streamClosed = true;
            try {
                Options.Rename renameOpt = overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE;
                fc.rename(tempPath, path, new Options.Rename[]{renameOpt});
                renameDone = true;
                this.tryRemoveCrcFile(fc, tempPath);
            }
            catch (FileAlreadyExistsException e) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!renameDone) {
                fc.delete(tempPath, false);
            }
        }
    }

    private FileContext getFileContext(Path path, Configuration hadoopConf) {
        return FileContext.getFileContext((URI)path.toUri(), (Configuration)hadoopConf);
    }

    private void tryRemoveCrcFile(FileContext fc, Path path) {
        try {
            Path checksumFile = new Path(path.getParent(), new StringBuilder(5).append(".").append(path.getName()).append(".crc").toString());
            if (fc.util().exists(checksumFile)) {
                fc.delete(checksumFile, true);
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
            }
            throw throwable;
        }
    }

    public HDFSLogStore(Configuration initHadoopConf) {
        super(initHadoopConf);
        Logging.$init$(this);
        this.noAbstractFileSystemExceptionMessage = "No AbstractFileSystem";
    }
}

