/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.internal.DeltaConfig;
import io.delta.standalone.internal.actions.Protocol;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.util.CalendarInterval;
import io.delta.standalone.internal.util.DateTimeConstants$;
import io.delta.standalone.internal.util.IntervalUtils$;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DeltaConfigs$
implements Logging {
    public static final DeltaConfigs$ MODULE$ = new DeltaConfigs$();
    private static final String hadoopConfPrefix;
    private static final HashMap<String, DeltaConfig<?>> entries;
    private static final DeltaConfig<CalendarInterval> LOG_RETENTION;
    private static final DeltaConfig<CalendarInterval> TOMBSTONE_RETENTION;
    private static final DeltaConfig<Object> CHECKPOINT_INTERVAL;
    private static final DeltaConfig<Object> ENABLE_EXPIRED_LOG_CLEANUP;
    private static final DeltaConfig<Object> IS_APPEND_ONLY;
    private static transient Logger io$delta$standalone$internal$logging$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
        hadoopConfPrefix = "spark.databricks.delta.properties.defaults.";
        entries = new HashMap();
        LOG_RETENTION = MODULE$.buildConfig("logRetentionDuration", "interval 30 days", (Function1 & Serializable)s -> MODULE$.parseCalendarInterval((String)s), (Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.MODULE$.isValidIntervalConfigValue(i)), "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", MODULE$.buildConfig$default$6(), MODULE$.buildConfig$default$7());
        TOMBSTONE_RETENTION = MODULE$.buildConfig("deletedFileRetentionDuration", "interval 1 week", (Function1 & Serializable)s -> MODULE$.parseCalendarInterval((String)s), (Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.MODULE$.isValidIntervalConfigValue(i)), "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", MODULE$.buildConfig$default$6(), MODULE$.buildConfig$default$7());
        CHECKPOINT_INTERVAL = MODULE$.buildConfig("checkpointInterval", "10", (Function1)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2))), (Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 > 0, "needs to be a positive integer.", MODULE$.buildConfig$default$6(), MODULE$.buildConfig$default$7());
        ENABLE_EXPIRED_LOG_CLEANUP = MODULE$.buildConfig("enableExpiredLogCleanup", "true", (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$4))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$ENABLE_EXPIRED_LOG_CLEANUP$2(BoxesRunTime.unboxToBoolean((Object)x$5))), "needs to be a boolean.", MODULE$.buildConfig$default$6(), MODULE$.buildConfig$default$7());
        IS_APPEND_ONLY = MODULE$.buildConfig("appendOnly", "false", (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$6))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$IS_APPEND_ONLY$2(BoxesRunTime.unboxToBoolean((Object)x$7))), "needs to be a boolean.", (Option<Protocol>)new Some((Object)new Protocol(0, 2)), MODULE$.buildConfig$default$7());
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    public CalendarInterval parseCalendarInterval(String s) {
        if (s == null || s.trim().isEmpty()) {
            throw new IllegalArgumentException("Interval cannot be null or blank.");
        }
        String sInLowerCase = s.trim().toLowerCase(Locale.ROOT);
        String interval = sInLowerCase.startsWith("interval ") ? sInLowerCase : new StringBuilder(9).append("interval ").append(sInLowerCase).toString();
        CalendarInterval cal = IntervalUtils$.MODULE$.safeStringToInterval(interval);
        if (cal == null) {
            throw new IllegalArgumentException(new StringBuilder(18).append("Invalid interval: ").append(s).toString());
        }
        return cal;
    }

    public String hadoopConfPrefix() {
        return hadoopConfPrefix;
    }

    private HashMap<String, DeltaConfig<?>> entries() {
        return entries;
    }

    public <T> DeltaConfig<T> buildConfig(String key, String defaultValue, Function1<String, T> fromString, Function1<T, Object> validationFunction, String helpMessage, Option<Protocol> minimumProtocolVersion, boolean userConfigurable) {
        DeltaConfig<T> deltaConfig = new DeltaConfig<T>(new StringBuilder(6).append("delta.").append(key).toString(), defaultValue, fromString, validationFunction, helpMessage, minimumProtocolVersion, userConfigurable);
        this.entries().put(key.toLowerCase(Locale.ROOT), deltaConfig);
        return deltaConfig;
    }

    public <T> Option<Protocol> buildConfig$default$6() {
        return None$.MODULE$;
    }

    public <T> boolean buildConfig$default$7() {
        return true;
    }

    public Map<String, String> validateConfigurations(Map<String, String> configurations) {
        return (Map)configurations.map((Function1 & Serializable)x0$1 -> {
            String key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (key = (String)tuple2._1()).toLowerCase(Locale.ROOT).startsWith("delta.constraints.")) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Unsupported CHECK constraint configuration ").append(key).append(" set").toString());
            }
            if (tuple2 != null) {
                String key2 = (String)tuple2._1();
                String value = (String)tuple2._2();
                if (key2.toLowerCase(Locale.ROOT).startsWith("delta.")) {
                    return (Tuple2)Option$.MODULE$.apply(MODULE$.entries().get(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(key2.toLowerCase(Locale.ROOT)), "delta."))).map((Function1 & Serializable)x$1 -> x$1.apply(value)).getOrElse((Function0 & Serializable)() -> {
                        throw DeltaErrors$.MODULE$.unknownConfigurationKeyException(key2);
                    });
                }
            }
            if (tuple2 != null) {
                String key3 = (String)tuple2._1();
                if (MODULE$.entries().containsKey(key3.toLowerCase(Locale.ROOT))) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(205).append("\n             |You are trying to set a property the key of which is the same as Delta config: ").append(key3).append(".\n             |If you are trying to set a Delta config, prefix it with \"delta.\", e.g. 'delta.").append(key3).append("'.\n             |").toString())));
                }
                return tuple2;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Map<String, String> mergeGlobalConfigs(Configuration hadoopConf, Map<String, String> tableConf) {
        scala.collection.mutable.Map globalConfs = (scala.collection.mutable.Map)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.entries()).asScala()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DeltaConfig config = (DeltaConfig)tuple2._2();
                String hadoopConfKey = new StringBuilder(0).append(MODULE$.hadoopConfPrefix()).append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(config.key()), "delta.")).toString();
                Option option = Option$.MODULE$.apply((Object)hadoopConf.get(hadoopConfKey, null));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String string = (String)some.value();
                    return new Some(config.apply(string));
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        });
        return (Map)globalConfs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus(tableConf);
    }

    public long getMilliSeconds(CalendarInterval i) {
        return this.getMicroSeconds(i) / 1000L;
    }

    private long getMicroSeconds(CalendarInterval i) {
        Predef$.MODULE$.assert(i.months() == 0);
        return (long)i.days() * DateTimeConstants$.MODULE$.MICROS_PER_DAY() + i.microseconds();
    }

    public boolean isValidIntervalConfigValue(CalendarInterval i) {
        return i.months() == 0 && this.getMicroSeconds(i) >= 0L;
    }

    public DeltaConfig<CalendarInterval> LOG_RETENTION() {
        return LOG_RETENTION;
    }

    public DeltaConfig<CalendarInterval> TOMBSTONE_RETENTION() {
        return TOMBSTONE_RETENTION;
    }

    public DeltaConfig<Object> CHECKPOINT_INTERVAL() {
        return CHECKPOINT_INTERVAL;
    }

    public DeltaConfig<Object> ENABLE_EXPIRED_LOG_CLEANUP() {
        return ENABLE_EXPIRED_LOG_CLEANUP;
    }

    public DeltaConfig<Object> IS_APPEND_ONLY() {
        return IS_APPEND_ONLY;
    }

    public static final /* synthetic */ boolean $anonfun$ENABLE_EXPIRED_LOG_CLEANUP$2(boolean x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$IS_APPEND_ONLY$2(boolean x$7) {
        return true;
    }

    private DeltaConfigs$() {
    }
}

