/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.expressions;

import io.delta.standalone.internal.expressions.CastingComparator;
import io.delta.standalone.types.BinaryType;
import io.delta.standalone.types.BooleanType;
import io.delta.standalone.types.ByteType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.DateType;
import io.delta.standalone.types.DecimalType;
import io.delta.standalone.types.DoubleType;
import io.delta.standalone.types.FloatType;
import io.delta.standalone.types.IntegerType;
import io.delta.standalone.types.LongType;
import io.delta.standalone.types.ShortType;
import io.delta.standalone.types.StringType;
import io.delta.standalone.types.TimestampType;
import java.util.Comparator;

public final class Util {
    public static Comparator<Object> createComparator(DataType dataType) {
        if (dataType instanceof IntegerType) {
            return new CastingComparator();
        }
        if (dataType instanceof BooleanType) {
            return new CastingComparator();
        }
        if (dataType instanceof FloatType) {
            return new CastingComparator();
        }
        if (dataType instanceof LongType) {
            return new CastingComparator();
        }
        if (dataType instanceof ByteType) {
            return new CastingComparator();
        }
        if (dataType instanceof ShortType) {
            return new CastingComparator();
        }
        if (dataType instanceof DoubleType) {
            return new CastingComparator();
        }
        if (dataType instanceof DecimalType) {
            return new CastingComparator();
        }
        if (dataType instanceof TimestampType) {
            return new CastingComparator();
        }
        if (dataType instanceof DateType) {
            return new CastingComparator();
        }
        if (dataType instanceof StringType) {
            return new CastingComparator();
        }
        if (dataType instanceof BinaryType) {
            return (object, object2) -> {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = (byte[])object2;
                for (int i = 0; i < byArray.length && i < byArray2.length; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    return Byte.compare(byArray[i], byArray2[i]);
                }
                return Integer.compare(byArray.length, byArray2.length);
            };
        }
        throw new IllegalArgumentException("Couldn't find matching comparator for DataType: " + dataType.getTypeName());
    }
}

