/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.CountingOutputStream;
import io.delta.storage.HadoopFileSystemLogStore;
import io.delta.storage.internal.FileNameUtils;
import io.delta.storage.internal.S3LogStoreUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;

public class S3SingleDriverLogStore
extends HadoopFileSystemLogStore {
    private final boolean enableFastListFrom = this.initHadoopConf().getBoolean("delta.enableFastS3AListFrom", false);
    private static final ConcurrentHashMap<Path, Object> pathLock = new ConcurrentHashMap();
    private static final Cache<Path, FileMetadata> writtenPathCache = CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.MINUTES).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releasePathLock(Path path) {
        Object object;
        Object object2 = object = pathLock.remove(path);
        synchronized (object2) {
            object.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void acquirePathLock(Path path) throws InterruptedException {
        Object object;
        while ((object = pathLock.putIfAbsent(path, new Object())) != null) {
            Object object2 = object;
            synchronized (object2) {
                while (pathLock.get(path) == object) {
                    object.wait();
                }
            }
        }
        return;
    }

    public S3SingleDriverLogStore(Configuration configuration) {
        super(configuration);
    }

    private boolean isInitialVersion(Path path) {
        return FileNameUtils.isDeltaFile(path) && FileNameUtils.deltaVersion(path) == 0L;
    }

    private Path resolvePath(FileSystem fileSystem, Path path) {
        return this.stripUserInfo(fileSystem.makeQualified(path));
    }

    private Path stripUserInfo(Path path) {
        URI uRI = path.toUri();
        try {
            URI uRI2 = new URI(uRI.getScheme(), null, uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
            return new Path(uRI2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    private Iterator<FileStatus> mergeFileLists(List<FileStatus> list, List<FileStatus> list2) {
        HashMap hashMap = new HashMap();
        Stream.concat(list2.stream(), list.stream()).forEach(fileStatus -> hashMap.putIfAbsent(fileStatus.getPath(), fileStatus));
        return hashMap.values().stream().sorted(Comparator.comparing(fileStatus -> fileStatus.getPath().getName())).iterator();
    }

    private List<FileStatus> listFromCache(FileSystem fileSystem, Path path) {
        Path path2 = this.stripUserInfo(path);
        return writtenPathCache.asMap().entrySet().stream().filter(entry -> {
            Path path2 = (Path)entry.getKey();
            return path2.getParent().equals((Object)path2.getParent()) && path2.getName().compareTo(path2.getName()) >= 0;
        }).map(entry -> {
            Path path = (Path)entry.getKey();
            FileMetadata fileMetadata = (FileMetadata)entry.getValue();
            return new FileStatus(fileMetadata.length, false, 1, fileSystem.getDefaultBlockSize(path), fileMetadata.modificationTime, path);
        }).collect(Collectors.toList());
    }

    private Iterator<FileStatus> listFromInternal(FileSystem fileSystem, Path path, boolean bl) throws IOException {
        Path path2 = path.getParent();
        if (!fileSystem.exists(path2)) {
            throw new FileNotFoundException(String.format("No such file or directory: %s", path2));
        }
        FileStatus[] fileStatusArray = fileSystem instanceof LocalFileSystem || fileSystem instanceof RawLocalFileSystem || !this.enableFastListFrom ? fileSystem.listStatus(path2) : S3LogStoreUtil.s3ListFromArray(fileSystem, path, path2);
        List<FileStatus> list = Arrays.stream(fileStatusArray).filter(fileStatus -> fileStatus.getPath().getName().compareTo(path.getName()) >= 0).collect(Collectors.toList());
        List<FileStatus> list2 = bl ? this.listFromCache(fileSystem, path) : Collections.emptyList();
        return this.mergeFileLists(list2, list);
    }

    private boolean exists(FileSystem fileSystem, Path path) throws IOException {
        boolean bl = !this.isInitialVersion(path);
        Iterator<FileStatus> iterator = this.listFromInternal(fileSystem, path, bl);
        if (!iterator.hasNext()) {
            return false;
        }
        return iterator.next().getPath().getName().equals(path.getName());
    }

    @Override
    public void write(Path path, Iterator<String> iterator, Boolean bl, Configuration configuration) throws IOException {
        try {
            FileSystem fileSystem = path.getFileSystem(configuration);
            Path path3 = this.resolvePath(fileSystem, path);
            S3SingleDriverLogStore.acquirePathLock(path3);
            try {
                if (this.exists(fileSystem, path3) && !bl.booleanValue()) {
                    throw new java.nio.file.FileAlreadyExistsException(path3.toUri().toString());
                }
                CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)fileSystem.create(path3, bl.booleanValue()));
                while (iterator.hasNext()) {
                    countingOutputStream.write((iterator.next() + "\n").getBytes(StandardCharsets.UTF_8));
                }
                countingOutputStream.close();
                if (this.isInitialVersion(path3)) {
                    List list = writtenPathCache.asMap().keySet().stream().filter(path2 -> path2.getParent().equals((Object)path3.getParent())).collect(Collectors.toList());
                    writtenPathCache.invalidateAll(list);
                }
                writtenPathCache.put((Object)path3, (Object)new FileMetadata(countingOutputStream.getCount(), System.currentTimeMillis()));
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(fileAlreadyExistsException.getMessage());
            }
            finally {
                S3SingleDriverLogStore.releasePathLock(path3);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException(interruptedException.getMessage());
        }
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path, Configuration configuration) throws IOException {
        FileSystem fileSystem = path.getFileSystem(configuration);
        Path path2 = this.resolvePath(fileSystem, path);
        return this.listFromInternal(fileSystem, path2, true);
    }

    @Override
    public Boolean isPartialWriteVisible(Path path, Configuration configuration) {
        return false;
    }

    private class FileMetadata {
        private long length;
        private long modificationTime;

        public FileMetadata(long l, long l2) {
            this.length = l;
            this.modificationTime = l2;
        }
    }
}

