/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.jsonb;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class Types {
    private Types() {
    }

    public static ParameterizedType listOf(Type genericType) {
        return new ParameterizedTypeImpl((Type)((Object)List.class), genericType);
    }

    public static ParameterizedType setOf(Type genericType) {
        return new ParameterizedTypeImpl((Type)((Object)Set.class), genericType);
    }

    public static ParameterizedType mapOf(Type keyType, Type valueType) {
        return new ParameterizedTypeImpl((Type)((Object)Map.class), keyType, valueType);
    }

    public static ParameterizedType optionalOf(Type genericType) {
        return new ParameterizedTypeImpl((Type)((Object)Optional.class), genericType);
    }

    public static ParameterizedType of(Class<?> rawType, Type ... typeParameters) {
        return new ParameterizedTypeImpl(rawType, typeParameters);
    }

    public static ParameterizedType ofOwnerType(Type ownerType, Class<?> rawType, Type ... typeParameters) {
        return new ParameterizedTypeImpl((Type)rawType, typeParameters, ownerType);
    }

    static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type rawType;
        private final Type[] typeArgs;
        private final Type ownerType;

        ParameterizedTypeImpl(Type rawType, Type[] typeArgs, Type ownerType) {
            this.rawType = rawType;
            this.ownerType = ownerType;
            this.typeArgs = typeArgs;
        }

        ParameterizedTypeImpl(Type rawType, Type ... typeArgs) {
            this(rawType, typeArgs, (Type)null);
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArgs;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterizedTypeImpl that = (ParameterizedTypeImpl)o;
            if (this.rawType != null ? !this.rawType.equals(that.rawType) : that.rawType != null) {
                return false;
            }
            if (!Arrays.equals(this.typeArgs, that.typeArgs)) {
                return false;
            }
            return this.ownerType != null ? this.ownerType.equals(that.ownerType) : that.ownerType == null;
        }

        public int hashCode() {
            int result = this.rawType != null ? this.rawType.hashCode() : 0;
            result = 31 * result + (this.typeArgs != null ? this.typeArgs.hashCode() : 0);
            result = 31 * result + (this.ownerType != null ? this.ownerType.hashCode() : 0);
            return result;
        }
    }
}

