/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.jsonb.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;

public class JacksonJsonb
implements Jsonb {
    private final ObjectMapper mapper;

    public JacksonJsonb(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public <T> T fromJson(String s, Class<T> aClass) throws JsonbException {
        try {
            return (T)this.mapper.readValue(s, aClass);
        }
        catch (IOException e) {
            throw new JsonbException("Could not parse content", (Throwable)e);
        }
    }

    public <T> T fromJson(String s, Type type) throws JsonbException {
        try {
            return (T)this.mapper.readValue(s, TypeFactory.defaultInstance().constructType(type));
        }
        catch (IOException e) {
            throw new JsonbException("Could not parse content", (Throwable)e);
        }
    }

    public <T> T fromJson(Reader reader, Class<T> aClass) throws JsonbException {
        try {
            return (T)this.mapper.readValue(reader, aClass);
        }
        catch (IOException e) {
            throw new JsonbException("Could not parse content", (Throwable)e);
        }
    }

    public <T> T fromJson(Reader reader, Type type) throws JsonbException {
        try {
            return (T)this.mapper.readValue(reader, TypeFactory.defaultInstance().constructType(type));
        }
        catch (IOException e) {
            throw new JsonbException("Could not parse content", (Throwable)e);
        }
    }

    public <T> T fromJson(InputStream inputStream, Class<T> aClass) throws JsonbException {
        try {
            return (T)this.mapper.readValue(inputStream, aClass);
        }
        catch (IOException e) {
            throw new JsonbException("Could not parse content", (Throwable)e);
        }
    }

    public <T> T fromJson(InputStream inputStream, Type type) throws JsonbException {
        try {
            return (T)this.mapper.readValue(inputStream, TypeFactory.defaultInstance().constructType(type));
        }
        catch (IOException e) {
            throw new JsonbException("Could not parse content", (Throwable)e);
        }
    }

    public String toJson(Object o) throws JsonbException {
        try {
            return this.mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new JsonbException("Could not serialize object of type" + o.getClass(), (Throwable)e);
        }
    }

    public String toJson(Object o, Type type) throws JsonbException {
        return this.toJson(o);
    }

    public void toJson(Object o, Writer writer) throws JsonbException {
        try {
            this.mapper.writeValue(writer, o);
        }
        catch (JsonProcessingException e) {
            throw new JsonbException("Could not serialize object of type" + o.getClass(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JsonbException("Could not write serialized object of type" + o.getClass(), (Throwable)e);
        }
    }

    public void toJson(Object o, Type type, Writer writer) throws JsonbException {
        this.toJson(o, writer);
    }

    public void toJson(Object o, OutputStream outputStream) throws JsonbException {
        try {
            this.mapper.writeValue(outputStream, o);
        }
        catch (JsonProcessingException e) {
            throw new JsonbException("Could not serialize object of type" + o.getClass(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JsonbException("Could not write serialized object of type" + o.getClass(), (Throwable)e);
        }
    }

    public void toJson(Object o, Type type, OutputStream outputStream) throws JsonbException {
        this.toJson(o, outputStream);
    }

    public void close() throws Exception {
    }
}

