/*
 * Decompiled with CFR 0.152.
 */
package io.devcon5.jsonb.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.devcon5.jsonb.jackson.JacksonJsonb;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.spi.JsonProvider;

public class JacksonJsonbBuilder
implements JsonbBuilder {
    public static final String INCLUDE_NULL_VALUES = "jsonb.jackson.nullValues";
    public static final String INCLUDE_EMPTY_VALUES = "jsonb.jackson.emptyValues";
    private boolean includeNulls = false;
    private boolean includeEmpty = false;

    public JsonbBuilder withConfig(JsonbConfig jsonbConfig) {
        if (jsonbConfig == null) {
            throw new IllegalArgumentException("Configuration must not be null");
        }
        this.includeNulls = jsonbConfig.getProperty("jsonb.null-values").orElse(this.includeNulls);
        this.includeNulls = jsonbConfig.getProperty(INCLUDE_NULL_VALUES).orElse(this.includeNulls);
        this.includeEmpty = jsonbConfig.getProperty(INCLUDE_EMPTY_VALUES).orElse(this.includeEmpty);
        return this;
    }

    public JsonbBuilder withProvider(JsonProvider jsonProvider) {
        return this;
    }

    public Jsonb build() {
        ObjectMapper mapper = new ObjectMapper();
        if (!this.includeNulls) {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            if (!this.includeEmpty) {
                mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            }
        }
        return new JacksonJsonb(mapper);
    }
}

