/*
 * Decompiled with CFR 0.152.
 */
package io.diagrid.dapr;

import io.diagrid.dapr.DaprPlacementContainer;
import io.diagrid.dapr.YamlRepresenter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class DaprContainer
extends GenericContainer<DaprContainer> {
    private static final int DAPRD_HTTP_PORT = 3500;
    private static final int DAPRD_GRPC_PORT = 50001;
    private final Set<Component> components = new HashSet<Component>();
    private final Set<Subscription> subscriptions = new HashSet<Subscription>();
    private String appName;
    private Integer appPort = 8080;
    private DaprLogLevel daprLogLevel = DaprLogLevel.info;
    private String appChannelAddress = "localhost";
    private String placementService = "placement";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"daprio/daprd");
    private Yaml yaml;
    private DaprPlacementContainer placementContainer;
    private String placementDockerImageName = "daprio/placement";
    private boolean shouldReusePlacement = false;

    public DaprContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withAccessToHost(true);
        this.withExposedPorts(new Integer[]{3500, 50001});
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        YamlRepresenter representer = new YamlRepresenter(options);
        representer.addClassTag(MetadataEntry.class, Tag.MAP);
        this.yaml = new Yaml((Representer)representer);
    }

    public DaprContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public Set<Component> getComponents() {
        return this.components;
    }

    public Set<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public DaprContainer withComponent(Component component) {
        this.components.add(component);
        return this;
    }

    public DaprContainer withAppPort(Integer port) {
        this.appPort = port;
        return this;
    }

    public DaprContainer withPlacementService(String placementService) {
        this.placementService = placementService;
        return this;
    }

    public DaprContainer withAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public DaprContainer withDaprLogLevel(DaprLogLevel daprLogLevel) {
        this.daprLogLevel = daprLogLevel;
        return this;
    }

    public DaprContainer withSubscription(String name, String pubSubName, String pubSubTopic, String route) {
        this.subscriptions.add(new Subscription(name, pubSubName, pubSubTopic, route));
        return this;
    }

    public DaprContainer withComponent(String name, String type, List<MetadataEntry> metadataEntries) {
        this.components.add(new Component(name, type, metadataEntries));
        return this;
    }

    public DaprContainer withComponent(Path path) {
        try {
            Map component = (Map)this.yaml.loadAs(Files.newInputStream(path, new OpenOption[0]), Map.class);
            String type = (String)component.get("type");
            Map metadata = (Map)component.get("metadata");
            String name = (String)metadata.get("name");
            Map spec = (Map)component.get("spec");
            List specMetadata = (List)((Object)spec.getOrDefault("metadata", Collections.emptyMap()));
            ArrayList<MetadataEntry> metadataEntries = new ArrayList<MetadataEntry>();
            for (Map specMetadataItem : specMetadata) {
                for (Map.Entry metadataItem : specMetadataItem.entrySet()) {
                    metadataEntries.add(new MetadataEntry((String)metadataItem.getKey(), metadataItem.getValue()));
                }
            }
            return this.withComponent(name, type, metadataEntries);
        }
        catch (IOException e) {
            this.logger().warn("Error while reading component from {}", (Object)path.toAbsolutePath());
            return this;
        }
    }

    public int getHTTPPort() {
        return this.getMappedPort(3500);
    }

    public String getHttpEndpoint() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(3500);
    }

    public int getGRPCPort() {
        return this.getMappedPort(50001);
    }

    public DaprContainer withAppChannelAddress(String appChannelAddress) {
        this.appChannelAddress = appChannelAddress;
        return this;
    }

    public Map<String, Object> componentToMap(Component component) {
        HashMap<String, Object> componentProps = new HashMap<String, Object>();
        componentProps.put("apiVersion", "dapr.io/v1alpha1");
        componentProps.put("kind", "Component");
        LinkedHashMap<String, String> componentMetadata = new LinkedHashMap<String, String>();
        componentMetadata.put("name", component.name);
        componentProps.put("metadata", componentMetadata);
        HashMap<String, Object> componentSpec = new HashMap<String, Object>();
        componentSpec.put("type", component.type);
        componentSpec.put("version", "v1");
        if (!component.metadata.isEmpty()) {
            componentSpec.put("metadata", component.metadata);
        }
        componentProps.put("spec", componentSpec);
        return componentProps;
    }

    public Map<String, Object> subscriptionToMap(Subscription subscription) {
        HashMap<String, Object> subscriptionProps = new HashMap<String, Object>();
        subscriptionProps.put("apiVersion", "dapr.io/v1alpha1");
        subscriptionProps.put("kind", "Subscription");
        LinkedHashMap<String, String> subscriptionMetadata = new LinkedHashMap<String, String>();
        subscriptionMetadata.put("name", subscription.name);
        subscriptionProps.put("metadata", subscriptionMetadata);
        HashMap<String, String> subscriptionSpec = new HashMap<String, String>();
        subscriptionSpec.put("pubsubname", subscription.pubsubName);
        subscriptionSpec.put("topic", subscription.topic);
        subscriptionSpec.put("route", subscription.route);
        subscriptionProps.put("spec", subscriptionSpec);
        return subscriptionProps;
    }

    protected void configure() {
        super.configure();
        if (this.getNetwork() == null) {
            this.withNetwork(Network.newNetwork());
        }
        if (this.placementContainer == null) {
            this.placementContainer = (DaprPlacementContainer)((DaprPlacementContainer)((DaprPlacementContainer)new DaprPlacementContainer(this.placementDockerImageName).withNetwork(this.getNetwork())).withNetworkAliases(new String[]{this.placementService})).withReuse(this.shouldReusePlacement);
            this.placementContainer.start();
        }
        this.withCommand(new String[]{"./daprd", "-app-id", this.appName, "--dapr-listen-addresses=0.0.0.0", "--app-protocol", "http", "-placement-host-address", this.placementService + ":50006", "--app-channel-address", this.appChannelAddress, "--app-port", Integer.toString(this.appPort), "--log-level", this.daprLogLevel.toString(), "-components-path", "/components"});
        if (this.components.isEmpty()) {
            this.components.add(new Component("kvstore", "state.in-memory", Collections.emptyMap()));
            this.components.add(new Component("pubsub", "pubsub.in-memory", Collections.emptyMap()));
        }
        if (this.subscriptions.isEmpty() && !this.components.isEmpty()) {
            this.subscriptions.add(new Subscription("local", "pubsub", "topic", "/events"));
        }
        for (Component component : this.components) {
            String componentYaml = this.componentToYAML(component);
            this.withCopyToContainer(Transferable.of((String)componentYaml), "/components/" + component.name + ".yaml");
        }
        for (Subscription subscription : this.subscriptions) {
            String subscriptionYaml = this.subscriptionToYAML(subscription);
            this.withCopyToContainer(Transferable.of((String)subscriptionYaml), "/components/" + subscription.name + ".yaml");
        }
    }

    public String subscriptionToYAML(Subscription subscription) {
        Map<String, Object> subscriptionMap = this.subscriptionToMap(subscription);
        return this.yaml.dumpAsMap(subscriptionMap);
    }

    public String componentToYAML(Component component) {
        Map<String, Object> componentMap = this.componentToMap(component);
        return this.yaml.dumpAsMap(componentMap);
    }

    public String getAppName() {
        return this.appName;
    }

    public Integer getAppPort() {
        return this.appPort;
    }

    public String getAppChannelAddress() {
        return this.appChannelAddress;
    }

    public String getPlacementService() {
        return this.placementService;
    }

    public static DockerImageName getDefaultImageName() {
        return DEFAULT_IMAGE_NAME;
    }

    public DaprContainer withPlacementImage(String placementDockerImageName) {
        this.placementDockerImageName = placementDockerImageName;
        return this;
    }

    public DaprContainer withReusablePlacement(boolean reuse) {
        this.shouldReusePlacement = this.shouldReusePlacement;
        return this;
    }

    public DaprContainer withPlacementContainer(DaprPlacementContainer placementContainer) {
        this.placementContainer = placementContainer;
        return this;
    }

    public static enum DaprLogLevel {
        error,
        warn,
        info,
        debug;

    }

    public static class MetadataEntry {
        String name;
        Object value;

        public MetadataEntry(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Subscription {
        String name;
        String pubsubName;
        String topic;
        String route;

        public Subscription(String name, String pubsubName, String topic, String route) {
            this.name = name;
            this.pubsubName = pubsubName;
            this.topic = topic;
            this.route = route;
        }
    }

    public static class Component {
        String name;
        String type;
        List<MetadataEntry> metadata;

        public Component(String name, String type, Map<String, Object> metadata) {
            this.name = name;
            this.type = type;
            this.metadata = new ArrayList<MetadataEntry>();
            if (!metadata.isEmpty()) {
                for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                    this.metadata.add(new MetadataEntry(entry.getKey(), entry.getValue()));
                }
            }
        }

        public Component(String name, String type, List<MetadataEntry> metadataEntries) {
            this.name = name;
            this.type = type;
            this.metadata = Objects.requireNonNull(metadataEntries);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public List<MetadataEntry> getMetadata() {
            return this.metadata;
        }
    }
}

