/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormValueSet;
import io.dialob.api.form.FormValueSetEntry;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormMetadata;
import io.dialob.api.form.ImmutableFormValueSet;
import io.dialob.api.form.ImmutableFormValueSetEntry;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormTest {
    ObjectMapper objectMapper = new ObjectMapper();

    @Test
    public void metadataIsRequired() {
        ConstraintViolationException exception = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> ImmutableForm.builder().build());
        Assertions.assertEquals((int)1, (int)exception.getConstraintViolations().size());
        ConstraintViolation constraintViolation = (ConstraintViolation)exception.getConstraintViolations().iterator().next();
        Assertions.assertEquals((Object)"must not be null", (Object)constraintViolation.getMessage());
        Assertions.assertEquals((Object)"metadata", (Object)constraintViolation.getPropertyPath().toString());
    }

    @Test
    public void metadataLabelIsRequired() {
        ConstraintViolationException exception = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> ImmutableForm.builder().metadata((Form.Metadata)ImmutableFormMetadata.builder().build()).build());
        Assertions.assertEquals((int)1, (int)exception.getConstraintViolations().size());
        ConstraintViolation constraintViolation = (ConstraintViolation)exception.getConstraintViolations().iterator().next();
        Assertions.assertEquals((Object)"must not be null", (Object)constraintViolation.getMessage());
        Assertions.assertEquals((Object)"metadata.label", (Object)constraintViolation.getPropertyPath().toString());
    }

    @Test
    public void testFormItemAdditionalProperties() throws Exception {
        ImmutableForm form = ImmutableForm.builder().metadata((Form.Metadata)ImmutableFormMetadata.builder().label("laabeli").putAdditionalProperties("extra", (Object)"value").build()).addValueSets((FormValueSet)ImmutableFormValueSet.builder().id("vs1").addEntries((FormValueSetEntry)ImmutableFormValueSetEntry.builder().id("id1").putLabel("fi", "ota1").putAdditionalProperties("selite", (Object)"extravalue").build()).putAdditionalProperties("extraItem", (Object)"valuee").build()).build();
        String expected = "{\"metadata\":{\"label\":\"laabeli\",\"extra\":\"value\"},\"valueSets\":[{\"id\":\"vs1\",\"entries\":[{\"id\":\"id1\",\"label\":{\"fi\":\"ota1\"},\"selite\":\"extravalue\"}],\"extraItem\":\"valuee\"}]}";
        Assertions.assertEquals((Object)expected, (Object)this.objectMapper.writeValueAsString((Object)form));
        Form form2 = (Form)this.objectMapper.readValue(expected, Form.class);
        Assertions.assertNotSame((Object)form, (Object)form2);
        Assertions.assertEquals((Object)form, (Object)form2);
    }
}

