/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ImmutableActionItem;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuestionTest {
    @Test
    public void shouldDeserializePropsToMap() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ActionItem question = (ActionItem)objectMapper.readValue("{\"id\":\"shouldDeserializePropsToMap\",\"type\":\"list\",\"props\":{\"extraProp\":\"extraValue\"}}", ActionItem.class);
        Assertions.assertEquals((Object)"extraValue", question.getProps().get("extraProp"));
        question = (ActionItem)objectMapper.readValue("{\"id\":\"shouldDeserializePropsToMap\",\"type\":\"list\",\"props\":{\"extraProp\":1}}", ActionItem.class);
        Assertions.assertEquals((Object)1, question.getProps().get("extraProp"));
        question = (ActionItem)objectMapper.readValue("{\"id\":\"shouldDeserializePropsToMap\",\"type\":\"list\",\"props\":{\"extraProp\":1.0}}", ActionItem.class);
        Assertions.assertEquals((Object)1.0, question.getProps().get("extraProp"));
        question = (ActionItem)objectMapper.readValue("{\"id\":\"shouldDeserializePropsToMap\",\"type\":\"list\",\"props\":{\"extraProp\":false}}", ActionItem.class);
        Assertions.assertEquals((Object)false, question.getProps().get("extraProp"));
        question = (ActionItem)objectMapper.readValue("{\"id\":\"shouldDeserializePropsToMap\",\"type\":\"list\",\"props\":{\"extraProp\":true}}", ActionItem.class);
        Assertions.assertEquals((Object)true, question.getProps().get("extraProp"));
        question = (ActionItem)objectMapper.readValue("{\"id\":\"shouldDeserializePropsToMap\",\"type\":\"list\",\"props\":{\"extraProp\":[]}}", ActionItem.class);
        Assertions.assertEquals(Collections.emptyList(), question.getProps().get("extraProp"));
        question = (ActionItem)objectMapper.readValue("{\"id\":\"shouldDeserializePropsToMap\",\"type\":\"list\"}", ActionItem.class);
        Assertions.assertEquals(null, (Object)question.getProps());
    }

    @Test
    public void shouldSerializeMapToProps() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ImmutableActionItem question = ImmutableActionItem.builder().id("shouldSerializeMapToProps").type("list").putProps("extraProp", (Object)"extraValue").build();
        Assertions.assertEquals((Object)"{\"id\":\"shouldSerializeMapToProps\",\"type\":\"list\",\"props\":{\"extraProp\":\"extraValue\"}}", (Object)objectMapper.writeValueAsString((Object)question));
        question = ImmutableActionItem.builder().id("q1").type("list").build();
        Assertions.assertEquals((Object)"{\"id\":\"q1\",\"type\":\"list\"}", (Object)objectMapper.writeValueAsString((Object)question));
    }
}

