/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.controller;

import io.dialob.boot.controller.BaseController;
import io.dialob.boot.controller.LandingController;
import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.settings.LandingApplicationSettings;
import io.dialob.security.tenant.CurrentTenant;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${landing.context-path:/landing}"})
public class LandingController
extends BaseController {
    private final LandingApplicationSettings settings;
    private final CurrentTenant currentTenant;

    public LandingController(CurrentTenant currentTenant, LandingApplicationSettings settings) {
        this.currentTenant = currentTenant;
        this.settings = settings;
    }

    @GetMapping(produces={"text/html"})
    public String fill(@RequestHeader(value="X-Forwarded-For", required=false) String forwardedFor, @RequestHeader(value="Host", required=false) String host, @RequestHeader(value="X-Real-IP", required=false) String realIp, @RequestHeader(value="X-Forwarded-Proto", required=false) String forwardedProto, CsrfToken cfrsToken, Model model, HttpServletRequest request) {
        LandingOptions landingOptions = new LandingOptions();
        landingOptions.setBackendApiUrl(this.settings.getApiUrl());
        landingOptions.setComposerUrl(this.settings.getComposerAppUrl());
        landingOptions.setFillingUrl(this.settings.getFillingAppUrl());
        landingOptions.setTenantId(this.currentTenant.getId());
        landingOptions.setAdminUrl(this.settings.getAdminAppUrl());
        landingOptions.setCsrf(cfrsToken);
        String tenantId = request.getParameter("tenantId");
        if (!StringUtils.isBlank((CharSequence)tenantId)) {
            landingOptions.setTenantId(tenantId);
        }
        model.addAttribute("landingConnectionOptions", (Object)landingOptions);
        PageAttributes pageAttributes = (PageAttributes)this.settings.getTenants().get("default");
        model.addAllAttributes(pageAttributes.getAttributes());
        this.index(model, request);
        return pageAttributes.getTemplate();
    }
}

