/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.settings;

import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.settings.AdminApplicationSettings;
import io.dialob.boot.settings.ComposerApplicationSettings;
import io.dialob.boot.settings.QuestionnaireApplicationSettings;
import io.dialob.boot.settings.ReviewApplicationSettings;
import io.dialob.boot.settings.SettingsPageAttributes;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import io.dialob.security.tenant.CurrentTenant;
import io.dialob.security.tenant.NoTenantInScopeException;
import java.util.Map;
import java.util.Optional;
import org.springframework.lang.NonNull;

public class SettingsPageSettingsProvider
implements PageSettingsProvider {
    private final QuestionnaireDatabase questionnaireDatabase;
    private final QuestionnaireApplicationSettings settings;
    private final SettingsPageAttributes defaultPageSettings;
    private final ReviewApplicationSettings reviewSettings;
    private final AdminApplicationSettings adminApplicationSettings;
    private final ComposerApplicationSettings composerApplicationSettings;
    private final SettingsPageAttributes defaultReviewPageSettings;
    private final SettingsPageAttributes defaultAdminPageSettings;
    private final SettingsPageAttributes defaultComposerPageSettings;
    private final CurrentTenant currentTenant;

    public SettingsPageSettingsProvider(CurrentTenant currentTenant, QuestionnaireDatabase questionnaireDatabase, QuestionnaireApplicationSettings settings, ReviewApplicationSettings reviewSettings, ComposerApplicationSettings composerApplicationSettings, Optional<AdminApplicationSettings> adminApplicationSettings) {
        this.currentTenant = currentTenant;
        this.questionnaireDatabase = questionnaireDatabase;
        this.settings = settings;
        this.defaultPageSettings = (SettingsPageAttributes)settings.getTenants().get("default");
        this.reviewSettings = reviewSettings;
        this.adminApplicationSettings = adminApplicationSettings.orElse(null);
        this.composerApplicationSettings = composerApplicationSettings;
        this.defaultReviewPageSettings = (SettingsPageAttributes)reviewSettings.getTenants().get("default");
        this.defaultComposerPageSettings = (SettingsPageAttributes)composerApplicationSettings.getTenants().get("default");
        this.defaultAdminPageSettings = this.adminApplicationSettings != null ? (SettingsPageAttributes)this.adminApplicationSettings.getTenants().get("default") : null;
    }

    @NonNull
    public PageAttributes findPageSettingsByQuestionnaireId(String page, String questionnaireId) {
        return this.findTenantFor(questionnaireId).map(tenantId -> this.findPageSettingsByTenantId(page, tenantId)).orElseGet(() -> this.findDefaultSettings(page));
    }

    @NonNull
    public PageAttributes findPageSettingsByTenantId(String page, String tenantId) {
        SettingsPageAttributes settingsPageAttributes = (SettingsPageAttributes)this.findSettings(page).get(tenantId);
        if (settingsPageAttributes == null) {
            settingsPageAttributes = this.findDefaultSettings(page);
        }
        return settingsPageAttributes;
    }

    @NonNull
    public PageAttributes findPageSettings(String page) {
        String tenantId;
        try {
            tenantId = this.currentTenant.getId();
        }
        catch (NoTenantInScopeException e) {
            tenantId = "default";
        }
        return this.findPageSettingsByTenantId(page, tenantId);
    }

    Map<String, SettingsPageAttributes> findSettings(String page) {
        switch (page) {
            case "fill": {
                return this.settings.getTenants();
            }
            case "review": {
                return this.reviewSettings.getTenants();
            }
            case "admin": {
                return this.adminApplicationSettings.getTenants();
            }
            case "composer": {
                return this.composerApplicationSettings.getTenants();
            }
        }
        throw new IllegalStateException("unknown page " + page);
    }

    SettingsPageAttributes findDefaultSettings(String page) {
        switch (page) {
            case "fill": {
                return this.defaultPageSettings;
            }
            case "review": {
                return this.defaultReviewPageSettings;
            }
            case "admin": {
                return this.defaultAdminPageSettings;
            }
            case "composer": {
                return this.defaultComposerPageSettings;
            }
        }
        throw new IllegalStateException("unknown page " + page);
    }

    private Optional<String> findTenantFor(String questionnaireId) {
        try {
            QuestionnaireDatabase.MetadataRow metadataRow = this.questionnaireDatabase.findMetadata(null, questionnaireId);
            return Optional.of(metadataRow.getValue().getTenantId());
        }
        catch (DocumentNotFoundException e) {
            return Optional.empty();
        }
    }
}

