/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.digdag.client.DigdagVersion;
import io.digdag.client.api.Id;
import io.digdag.client.api.JacksonTimeModule;
import io.digdag.client.api.LocalTimeOrInstant;
import io.digdag.client.api.RestDirectDownloadHandle;
import io.digdag.client.api.RestLogFileHandle;
import io.digdag.client.api.RestLogFileHandleCollection;
import io.digdag.client.api.RestProject;
import io.digdag.client.api.RestProjectCollection;
import io.digdag.client.api.RestRevisionCollection;
import io.digdag.client.api.RestSchedule;
import io.digdag.client.api.RestScheduleBackfillRequest;
import io.digdag.client.api.RestScheduleCollection;
import io.digdag.client.api.RestScheduleEnableRequest;
import io.digdag.client.api.RestScheduleSkipRequest;
import io.digdag.client.api.RestScheduleSummary;
import io.digdag.client.api.RestSecret;
import io.digdag.client.api.RestSecretList;
import io.digdag.client.api.RestSession;
import io.digdag.client.api.RestSessionAttempt;
import io.digdag.client.api.RestSessionAttemptCollection;
import io.digdag.client.api.RestSessionAttemptRequest;
import io.digdag.client.api.RestSessionCollection;
import io.digdag.client.api.RestSetSecretRequest;
import io.digdag.client.api.RestTaskCollection;
import io.digdag.client.api.RestVersionCheckResult;
import io.digdag.client.api.RestWorkflowDefinition;
import io.digdag.client.api.RestWorkflowDefinitionCollection;
import io.digdag.client.api.RestWorkflowSessionTime;
import io.digdag.client.api.SecretValidation;
import io.digdag.client.api.SessionTimeTruncate;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.plugins.interceptors.encoding.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.interceptors.encoding.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.encoding.GZIPEncodingInterceptor;

public class DigdagClient
implements AutoCloseable {
    private static final int TOO_MANY_REQUESTS_429 = 429;
    private static final int REQUEST_TIMEOUT_408 = 408;
    private static final int MAX_REDIRECT = 10;
    private final String endpoint;
    private final Supplier<MultivaluedMap<String, Object>> headers;
    private final Client client;
    private final ConfigFactory cf;
    private final boolean disableDirectDownload;

    public static ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new GuavaModule());
        mapper.registerModule((Module)new JacksonTimeModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        InjectableValues.Std injects = new InjectableValues.Std();
        injects.addValue(ObjectMapper.class, (Object)mapper);
        mapper.setInjectableValues((InjectableValues)injects);
        return mapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    private DigdagClient(Builder builder) {
        if (builder.host == null) {
            throw new IllegalArgumentException("host is not set");
        }
        this.endpoint = builder.ssl ? (builder.port < 0 ? "https://" + builder.host : "https://" + builder.host + ":" + builder.port) : (builder.port < 0 ? "http://" + builder.host : "http://" + builder.host + ":" + builder.port);
        Map baseHeaders = builder.baseHeaders;
        Function headerBuilder = builder.headerBuilder;
        if (headerBuilder != null) {
            this.headers = () -> new MultivaluedHashMap((Map)headerBuilder.apply(new HashMap(baseHeaders)));
        } else {
            MultivaluedHashMap staticHeaders = new MultivaluedHashMap(baseHeaders);
            this.headers = () -> DigdagClient.lambda$new$1((MultivaluedMap)staticHeaders);
        }
        ObjectMapper mapper = DigdagClient.objectMapper();
        ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder().register(AcceptEncodingGZIPFilter.class).register(GZIPDecodingInterceptor.class).register(GZIPEncodingInterceptor.class).register((Object)new UserAgentFilter("DigdagClient/" + DigdagVersion.buildVersion())).register((Object)new JacksonJsonProvider(mapper));
        if (builder.proxyHost != null) {
            if (builder.proxyPort == null) {
                clientBuilder.defaultProxy(builder.proxyHost);
            } else if (builder.proxyScheme == null) {
                clientBuilder.defaultProxy(builder.proxyHost, builder.proxyPort.intValue());
            } else {
                clientBuilder.defaultProxy(builder.proxyHost, builder.proxyPort.intValue(), builder.proxyScheme);
            }
        }
        if (builder.disableCertValidation) {
            clientBuilder.disableTrustManager();
        }
        this.client = clientBuilder.build();
        this.cf = new ConfigFactory(mapper);
        this.disableDirectDownload = builder.disableDirectDownload;
    }

    @Override
    public void close() {
        this.client.close();
    }

    public Config newConfig() {
        return this.cf.create();
    }

    public RestProject getProject(String name) {
        List<RestProject> projs = this.doGet(RestProjectCollection.class, this.target("/api/projects").queryParam("name", new Object[]{name})).getProjects();
        if (projs.isEmpty()) {
            throw new NotFoundException(String.format(Locale.ENGLISH, "project not found: %s", name));
        }
        return projs.get(0);
    }

    public RestProjectCollection getProjects() {
        return this.doGet(RestProjectCollection.class, this.target("/api/projects"));
    }

    public RestProject getProject(Id projId) {
        return this.doGet(RestProject.class, this.target("/api/projects/{id}").resolveTemplate("id", (Object)projId));
    }

    public void deleteProject(Id projId) {
        this.doDelete(this.target("/api/projects/{id}").resolveTemplate("id", (Object)projId));
    }

    public RestRevisionCollection getRevisions(Id projId, Optional<Id> lastId) {
        return this.doGet(RestRevisionCollection.class, this.target("/api/projects/{id}/revisions").resolveTemplate("id", (Object)projId).queryParam("last_id", new Object[]{lastId.orNull()}));
    }

    public RestWorkflowDefinitionCollection getWorkflowDefinitions() {
        return this.doGet(RestWorkflowDefinitionCollection.class, this.target("/api/workflows"));
    }

    public RestWorkflowDefinitionCollection getWorkflowDefinitions(Optional<Id> lastId) {
        return this.doGet(RestWorkflowDefinitionCollection.class, this.target("/api/workflows").queryParam("last_id", new Object[]{lastId.orNull()}));
    }

    public RestWorkflowDefinitionCollection getWorkflowDefinitions(Id projId) {
        return this.doGet(RestWorkflowDefinitionCollection.class, this.target("/api/projects/{id}/workflows").resolveTemplate("id", (Object)projId));
    }

    public RestWorkflowDefinitionCollection getWorkflowDefinitions(Id projId, String revision) {
        return this.doGet(RestWorkflowDefinitionCollection.class, this.target("/api/projects/{id}/workflows").resolveTemplate("id", (Object)projId).queryParam("revision", new Object[]{revision}));
    }

    public RestWorkflowDefinition getWorkflowDefinition(Id projId, String name) {
        List<RestWorkflowDefinition> defs = this.doGet(RestWorkflowDefinitionCollection.class, this.target("/api/projects/{id}/workflows").resolveTemplate("id", (Object)projId).queryParam("name", new Object[]{name})).getWorkflows();
        if (defs.isEmpty()) {
            throw new NotFoundException(String.format(Locale.ENGLISH, "workflow not found in the latest revision of project id = %s: %s", projId, name));
        }
        return defs.get(0);
    }

    public RestWorkflowDefinition getWorkflowDefinition(Id projId, String name, String revision) {
        List<RestWorkflowDefinition> defs = this.doGet(RestWorkflowDefinitionCollection.class, this.target("/api/projects/{id}/workflows").resolveTemplate("id", (Object)projId).queryParam("name", new Object[]{name}).queryParam("revision", new Object[]{revision})).getWorkflows();
        if (defs.isEmpty()) {
            throw new NotFoundException(String.format(Locale.ENGLISH, "workflow not found in revision = %s of project id = %s: %s", revision, projId, name));
        }
        return defs.get(0);
    }

    public RestWorkflowDefinition getWorkflowDefinition(Id workflowId) {
        return this.doGet(RestWorkflowDefinition.class, this.target("/api/workflows/{id}").resolveTemplate("id", (Object)workflowId));
    }

    public RestWorkflowSessionTime getWorkflowTruncatedSessionTime(Id workflowId, LocalTimeOrInstant time) {
        return this.doGet(RestWorkflowSessionTime.class, this.target("/api/workflows/{id}/truncated_session_time").resolveTemplate("id", (Object)workflowId).queryParam("session_time", new Object[]{time.toString()}));
    }

    public RestWorkflowSessionTime getWorkflowTruncatedSessionTime(Id workflowId, LocalTimeOrInstant time, SessionTimeTruncate mode) {
        return this.doGet(RestWorkflowSessionTime.class, this.target("/api/workflows/{id}/truncated_session_time").resolveTemplate("id", (Object)workflowId).queryParam("session_time", new Object[]{time.toString()}).queryParam("mode", new Object[]{mode == null ? null : mode.toString()}));
    }

    public RestProject putProjectRevision(String projName, String revision, File body) throws IOException {
        return this.putProjectRevision(projName, revision, body, (Optional<Instant>)Optional.absent());
    }

    public RestProject putProjectRevision(String projName, String revision, File body, Optional<Instant> scheduleFrom) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projName) ? 1 : 0) != 0, (Object)"projName");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)revision) ? 1 : 0) != 0, (Object)"revision");
        if (scheduleFrom.isPresent()) {
            return this.doPut(RestProject.class, "application/gzip", body, this.target("/api/projects").queryParam("project", new Object[]{projName}).queryParam("revision", new Object[]{revision}).queryParam("schedule_from", new Object[]{((Instant)scheduleFrom.get()).toString()}));
        }
        return this.doPut(RestProject.class, "application/gzip", body, this.target("/api/projects").queryParam("project", new Object[]{projName}).queryParam("revision", new Object[]{revision}));
    }

    private <T> T withFollowingRedirect(WebTarget initialWebTarget, RequestWithFollowingRedirect<T> request) {
        WebApplicationException firstRedirectException = null;
        WebTarget webTarget = initialWebTarget;
        Optional lastResponse = Optional.absent();
        for (int i = 0; i < 10; ++i) {
            try {
                return request.invoke(webTarget, (Optional<Response>)lastResponse);
            }
            catch (WebApplicationException e) {
                Response response;
                int status;
                if (firstRedirectException == null) {
                    firstRedirectException = e;
                }
                if ((status = (response = (Response)Preconditions.checkNotNull((Object)e.getResponse())).getStatus()) % 100 != 3 || response.getLocation() == null) {
                    throw e;
                }
                lastResponse = Optional.of((Object)response);
                webTarget = this.client.target(UriBuilder.fromUri((URI)response.getLocation()));
                continue;
            }
        }
        throw firstRedirectException;
    }

    public InputStream getProjectArchive(Id projId, String revision) {
        WebTarget webTarget = this.target("/api/projects/{id}/archive").resolveTemplate("id", (Object)projId).queryParam("revision", new Object[]{revision});
        webTarget = this.addDisableDirectDownloadParam(webTarget);
        return this.withFollowingRedirect(webTarget, (wt, lastResponse) -> {
            Invocation.Builder request = wt.request();
            if (!lastResponse.isPresent()) {
                request.headers(this.headers.get());
            }
            return (InputStream)this.invokeWithRetry(request.buildGet()).readEntity(InputStream.class);
        });
    }

    public RestScheduleCollection getSchedules() {
        return this.doGet(RestScheduleCollection.class, this.target("/api/schedules"));
    }

    public RestScheduleCollection getSchedules(Optional<Id> lastId) {
        return this.doGet(RestScheduleCollection.class, this.target("/api/schedules").queryParam("last_id", new Object[]{lastId.orNull()}));
    }

    public RestScheduleCollection getSchedules(Id projectId, Optional<Id> lastId) {
        return this.doGet(RestScheduleCollection.class, this.target("/api/projects/{id}/schedules").resolveTemplate("id", (Object)projectId).queryParam("last_id", new Object[]{lastId.orNull()}));
    }

    public RestSchedule getSchedule(Id projectId, String workflowName) {
        List<RestSchedule> scheds = this.doGet(RestScheduleCollection.class, this.target("/api/projects/{id}/schedules").resolveTemplate("id", (Object)projectId).queryParam("workflow", new Object[]{workflowName})).getSchedules();
        if (scheds.isEmpty()) {
            throw new NotFoundException(String.format(Locale.ENGLISH, "schedule not found in the latest revision of project id = %s: %s", projectId, workflowName));
        }
        return scheds.get(0);
    }

    public RestSchedule getSchedule(Id id) {
        return this.doGet(RestSchedule.class, this.target("/api/schedules/{id}").resolveTemplate("id", (Object)id));
    }

    public RestSessionCollection getSessions() {
        return this.getSessions((Optional<Id>)Optional.absent());
    }

    public RestSessionCollection getSessions(Optional<Id> lastId) {
        return this.doGet(RestSessionCollection.class, this.target("/api/sessions").queryParam("last_id", new Object[]{lastId.orNull()}));
    }

    public RestSessionCollection getSessions(Id projectId) {
        return this.getSessions(projectId, (Optional<Id>)Optional.absent(), (Optional<Integer>)Optional.absent());
    }

    public RestSessionCollection getSessions(Id projectId, Optional<Id> lastId, Optional<Integer> pageSize) {
        return this.doGet(RestSessionCollection.class, this.target("/api/projects/{projectId}/sessions").resolveTemplate("projectId", (Object)projectId).queryParam("last_id", new Object[]{lastId.orNull()}).queryParam("page_size", new Object[]{pageSize.orNull()}));
    }

    public RestSessionCollection getSessions(Id projectId, String workflowName) {
        return this.getSessions(projectId, workflowName, (Optional<Id>)Optional.absent(), (Optional<Integer>)Optional.absent());
    }

    public RestSessionCollection getSessions(Id projectId, String workflowName, Optional<Id> lastId, Optional<Integer> pageSize) {
        return this.doGet(RestSessionCollection.class, this.target("/api/projects/{projectId}/sessions").resolveTemplate("projectId", (Object)projectId).queryParam("workflow", new Object[]{workflowName}).queryParam("last_id", new Object[]{lastId.orNull()}).queryParam("page_size", new Object[]{pageSize.orNull()}));
    }

    public RestSession getSession(Id sessionId) {
        return this.doGet(RestSession.class, this.target("/api/sessions/{id}").resolveTemplate("id", (Object)sessionId));
    }

    public RestSessionAttemptCollection getSessionAttempts(Id sessionId, Optional<Id> lastId, Optional<Integer> pageSize) {
        return this.doGet(RestSessionAttemptCollection.class, this.target("/api/sessions/{sessionId}/attempts").resolveTemplate("sessionId", (Object)sessionId).queryParam("last_id", new Object[]{lastId.orNull()}).queryParam("page_size", new Object[]{pageSize.orNull()}));
    }

    public RestSessionAttemptCollection getSessionAttempts(Optional<Id> lastId, Optional<Integer> pageSize) {
        return this.doGet(RestSessionAttemptCollection.class, this.target("/api/attempts").queryParam("last_id", new Object[]{lastId.orNull()}).queryParam("page_size", new Object[]{pageSize.orNull()}));
    }

    public RestSessionAttemptCollection getSessionAttempts(String projName, Optional<Id> lastId) {
        return this.doGet(RestSessionAttemptCollection.class, this.target("/api/attempts").queryParam("project", new Object[]{projName}).queryParam("last_id", new Object[]{lastId.orNull()}));
    }

    public RestSessionAttemptCollection getSessionAttempts(String projName, String workflowName, Optional<Id> lastId) {
        return this.doGet(RestSessionAttemptCollection.class, this.target("/api/attempts").queryParam("project", new Object[]{projName}).queryParam("workflow", new Object[]{workflowName}).queryParam("last_id", new Object[]{lastId.orNull()}));
    }

    public RestSessionAttempt getSessionAttempt(Id attemptId) {
        return this.doGet(RestSessionAttempt.class, this.target("/api/attempts/{id}").resolveTemplate("id", (Object)attemptId));
    }

    public RestSessionAttemptCollection getSessionAttemptRetries(Id attemptId) {
        return this.doGet(RestSessionAttemptCollection.class, this.target("/api/attempts/{id}/retries").resolveTemplate("id", (Object)attemptId));
    }

    public RestTaskCollection getTasks(Id attemptId) {
        return this.doGet(RestTaskCollection.class, this.target("/api/attempts/{id}/tasks").resolveTemplate("id", (Object)attemptId));
    }

    public RestLogFileHandleCollection getLogFileHandlesOfAttempt(Id attemptId) {
        WebTarget webTarget = this.target("/api/logs/{id}/files").resolveTemplate("id", (Object)attemptId);
        webTarget = this.addDisableDirectDownloadParam(webTarget);
        return this.doGet(RestLogFileHandleCollection.class, webTarget);
    }

    public RestLogFileHandleCollection getLogFileHandlesOfTask(Id attemptId, String taskName) {
        try {
            WebTarget webTarget = this.target("/api/logs/{id}/files").resolveTemplate("id", (Object)attemptId).queryParam("task", new Object[]{URLEncoder.encode(taskName, "UTF-8")});
            webTarget = this.addDisableDirectDownloadParam(webTarget);
            return this.doGet(RestLogFileHandleCollection.class, webTarget);
        }
        catch (UnsupportedEncodingException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public InputStream getLogFile(Id attemptId, RestLogFileHandle handle) {
        if (handle.getDirect().isPresent()) {
            Invocation request = this.client.target(UriBuilder.fromUri((String)((RestDirectDownloadHandle)handle.getDirect().get()).getUrl())).request().buildGet();
            return (InputStream)this.invokeWithRetry(request).readEntity(InputStream.class);
        }
        return this.getLogFile(attemptId, handle.getFileName());
    }

    public InputStream getLogFile(Id attemptId, String fileName) {
        Invocation request = this.target("/api/logs/{id}/files/{fileName}").resolveTemplate("id", (Object)attemptId).resolveTemplate("fileName", (Object)fileName).request().headers(this.headers.get()).buildGet();
        return (InputStream)this.invokeWithRetry(request).readEntity(InputStream.class);
    }

    private WebTarget addDisableDirectDownloadParam(WebTarget target) {
        if (this.disableDirectDownload) {
            target = target.queryParam("direct_download", new Object[]{false});
        }
        return target;
    }

    private Response invokeWithRetry(Invocation request) {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException(Predicates.not(DigdagClient::isDeterministicError)).withWaitStrategy(WaitStrategies.exponentialWait()).withStopStrategy(StopStrategies.stopAfterAttempt((int)10)).build();
        try {
            return (Response)retryer.call(() -> {
                Response res = request.invoke();
                if (res.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                    res.close();
                    return (Response)ClientInvocation.handleErrorStatus((Response)res);
                }
                return res;
            });
        }
        catch (RetryException | ExecutionException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw Throwables.propagate((Throwable)cause);
        }
    }

    private static boolean isDeterministicError(Throwable ex) {
        return ex instanceof WebApplicationException && DigdagClient.isDeterministicError(((WebApplicationException)ex).getResponse());
    }

    private static boolean isDeterministicError(Response res) {
        return DigdagClient.isDeterministicError(res.getStatus());
    }

    private static boolean isDeterministicError(int status) {
        if (status >= 300 && status < 500) {
            switch (status) {
                case 408: 
                case 429: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public RestSessionAttempt startSessionAttempt(RestSessionAttemptRequest request) {
        return this.doPut(RestSessionAttempt.class, "application/json", request, this.target("/api/attempts"));
    }

    public void killSessionAttempt(Id attemptId) {
        this.doPost(RestSessionAttempt.class, new HashMap(), this.target("/api/attempts/{id}/kill").resolveTemplate("id", (Object)attemptId));
    }

    public RestScheduleSummary skipSchedulesToTime(Id scheduleId, Instant untilTime, Optional<Instant> runTime, boolean dryRun) {
        return this.doPost(RestScheduleSummary.class, (Object)RestScheduleSkipRequest.builder().nextTime(LocalTimeOrInstant.of(untilTime)).nextRunTime(runTime).dryRun(dryRun).build(), this.target("/api/schedules/{id}/skip").resolveTemplate("id", (Object)scheduleId));
    }

    public RestScheduleSummary skipSchedulesToTime(Id scheduleId, LocalDateTime untilTime, Optional<Instant> runTime, boolean dryRun) {
        return this.doPost(RestScheduleSummary.class, (Object)RestScheduleSkipRequest.builder().nextTime(LocalTimeOrInstant.of(untilTime)).nextRunTime(runTime).dryRun(dryRun).build(), this.target("/api/schedules/{id}/skip").resolveTemplate("id", (Object)scheduleId));
    }

    public RestScheduleSummary skipSchedulesByCount(Id scheduleId, Instant fromTime, int count, Optional<Instant> runTime, boolean dryRun) {
        return this.doPost(RestScheduleSummary.class, (Object)RestScheduleSkipRequest.builder().fromTime(fromTime).count(count).nextRunTime(runTime).dryRun(dryRun).build(), this.target("/api/schedules/{id}/skip").resolveTemplate("id", (Object)scheduleId));
    }

    public RestSessionAttemptCollection backfillSchedule(Id scheduleId, Instant fromTime, String attemptName, Optional<Integer> count, boolean dryRun) {
        return this.doPost(RestSessionAttemptCollection.class, (Object)RestScheduleBackfillRequest.builder().fromTime(fromTime).dryRun(dryRun).attemptName(attemptName).count(count).build(), this.target("/api/schedules/{id}/backfill").resolveTemplate("id", (Object)scheduleId));
    }

    public RestScheduleSummary disableSchedule(Id scheduleId) {
        return this.doPost(RestScheduleSummary.class, (Object)ImmutableMap.of(), this.target("/api/schedules/{id}/disable").resolveTemplate("id", (Object)scheduleId));
    }

    public RestScheduleSummary enableSchedule(Id scheduleId) {
        return this.doPost(RestScheduleSummary.class, (Object)ImmutableMap.of(), this.target("/api/schedules/{id}/enable").resolveTemplate("id", (Object)scheduleId));
    }

    public RestScheduleSummary enableSchedule(Id scheduleId, boolean skipSchedule, Optional<String> nextTime) {
        return this.doPost(RestScheduleSummary.class, (Object)RestScheduleEnableRequest.builder().skipSchedule(skipSchedule).nextTime(nextTime).build(), this.target("/api/schedules/{id}/enable").resolveTemplate("id", (Object)scheduleId));
    }

    public Map<String, Object> getVersion() {
        return this.doGet(Version.class, this.target("/api/version")).get();
    }

    public RestVersionCheckResult checkClientVersion(String clientVersion) {
        return this.doGet(RestVersionCheckResult.class, this.target("/api/version/check").queryParam("client", new Object[]{clientVersion}));
    }

    public void setProjectSecret(Id projectId, String key, String value) {
        if (!SecretValidation.isValidSecret(key, value)) {
            throw new IllegalArgumentException();
        }
        Response response = this.target("/api/projects/{id}/secrets/{key}").resolveTemplate("id", (Object)projectId).resolveTemplate("key", (Object)key).request().headers(this.headers.get()).put(Entity.entity((Object)RestSetSecretRequest.of(value), (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new WebApplicationException("Failed to set project secret: " + response.getStatusInfo());
        }
        response.readEntity(RestSecret.class);
    }

    public void deleteProjectSecret(Id projectId, String key) {
        if (!SecretValidation.isValidSecretKey(key)) {
            throw new IllegalArgumentException();
        }
        Response response = this.target("/api/projects/{id}/secrets/{key}").resolveTemplate("id", (Object)projectId).resolveTemplate("key", (Object)key).request().headers(this.headers.get()).delete();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new WebApplicationException("Failed to delete project secret: " + response.getStatusInfo());
        }
        response.readEntity(RestSecret.class);
    }

    public RestSecretList listProjectSecrets(Id projectId) {
        return (RestSecretList)this.target("/api/projects/{id}/secrets").resolveTemplate("id", (Object)projectId).request(new String[]{"application/json"}).headers(this.headers.get()).get(RestSecretList.class);
    }

    public Config adminGetAttemptUserInfo(Id attemptId) {
        return this.doGet(Config.class, this.target("/api/admin/attempts/{id}/userinfo").resolveTemplate("id", (Object)attemptId));
    }

    private WebTarget target(String path) {
        return this.client.target(UriBuilder.fromUri((String)(this.endpoint + path)));
    }

    private <T> T doGet(GenericType<T> type, WebTarget target) {
        return (T)this.invokeWithRetry(target.request(new String[]{"application/json"}).headers(this.headers.get()).buildGet()).readEntity(type);
    }

    private <T> T doGet(Class<T> type, WebTarget target) {
        return (T)this.invokeWithRetry(target.request(new String[]{"application/json"}).headers(this.headers.get()).buildGet()).readEntity(type);
    }

    private <T> T doPut(Class<T> type, String contentType, Object body, WebTarget target) {
        return (T)target.request(new String[]{"application/json"}).headers(this.headers.get()).put(Entity.entity((Object)body, (String)contentType), type);
    }

    private <T> T doPost(GenericType<T> type, Object body, WebTarget target) {
        return (T)target.request(new String[]{"application/json"}).headers(this.headers.get()).post(Entity.entity((Object)body, (String)"application/json"), type);
    }

    private <T> T doPost(Class<T> type, Object body, WebTarget target) {
        return (T)target.request(new String[]{"application/json"}).headers(this.headers.get()).post(Entity.entity((Object)body, (String)"application/json"), type);
    }

    private void doDelete(WebTarget target) {
        this.doDelete(Object.class, target);
    }

    private <T> T doDelete(Class<T> type, WebTarget target) {
        return (T)target.request(new String[]{"application/json"}).headers(this.headers.get()).delete(type);
    }

    private static /* synthetic */ MultivaluedMap lambda$new$1(MultivaluedMap staticHeaders) {
        return staticHeaders;
    }

    private static class UserAgentFilter
    implements ClientRequestFilter {
        private final String userAgent;

        UserAgentFilter(String userAgent) {
            this.userAgent = userAgent;
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            requestContext.getHeaders().putSingle((Object)"User-Agent", (Object)this.userAgent);
        }
    }

    static class Version {
        private final Map<String, Object> map;

        @JsonCreator
        Version(Map<String, Object> map) {
            this.map = map;
        }

        @JsonValue
        public Map<String, Object> get() {
            return this.map;
        }
    }

    @FunctionalInterface
    static interface RequestWithFollowingRedirect<T> {
        public T invoke(WebTarget var1, Optional<Response> var2);
    }

    public static class Builder {
        private String host = null;
        private int port = -1;
        private boolean ssl = false;
        private String proxyHost = null;
        private Integer proxyPort = null;
        private String proxyScheme = null;
        private final Map<String, String> baseHeaders = new HashMap<String, String>();
        private Function<Map<String, String>, Map<String, String>> headerBuilder = null;
        private boolean disableCertValidation;
        private boolean disableDirectDownload = false;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder proxyScheme(String proxyScheme) {
            this.proxyScheme = proxyScheme;
            return this;
        }

        public Builder header(String key, String value) {
            this.baseHeaders.put(key, value);
            return this;
        }

        public Builder headers(Map<String, String> map) {
            this.baseHeaders.putAll(map);
            return this;
        }

        public Builder headerBuilder(Function<Map<String, String>, Map<String, String>> headerBuilder) {
            this.headerBuilder = headerBuilder;
            return this;
        }

        public Builder disableCertValidation(boolean value) {
            this.disableCertValidation = value;
            return this;
        }

        public Builder disableDirectDownload(boolean value) {
            this.disableDirectDownload = value;
            return this;
        }

        public DigdagClient build() {
            return new DigdagClient(this);
        }
    }
}

