/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern DIGDAG_VERSION_PATTERN = Pattern.compile("((?:0|[1-9][0-9]*)(?:\\.(?:0|[1-9][0-9]*))*)(?:\\-([a-zA-Z0-9_\\-\\.]+))?");
    private final List<Integer> versionNumbers;
    private final Optional<String> qualifier;

    private Version(List<Integer> versionNumbers, Optional<String> qualifier) {
        this.versionNumbers = versionNumbers;
        this.qualifier = qualifier;
    }

    public static Version parse(String versionString) {
        Matcher m = DIGDAG_VERSION_PATTERN.matcher(versionString);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid version string: " + versionString);
        }
        ImmutableList.Builder numbers = ImmutableList.builder();
        for (String number : m.group(1).split("\\.")) {
            try {
                numbers.add((Object)Integer.parseInt(number));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Too big version number: " + versionString, ex);
            }
        }
        Optional qualifier = Optional.fromNullable((Object)m.group(2));
        return new Version((List<Integer>)numbers.build(), (Optional<String>)qualifier);
    }

    public int getMajorVersion() {
        return this.versionNumbers.get(0);
    }

    @Override
    public int compareTo(Version another) {
        int longer = Math.max(this.versionNumbers.size(), another.versionNumbers.size());
        for (int i = 0; i < longer; ++i) {
            int right;
            int left = this.versionNumbers.size() > i ? this.versionNumbers.get(i) : 0;
            int n = right = another.versionNumbers.size() > i ? another.versionNumbers.get(i) : 0;
            if (left < right) {
                return -1;
            }
            if (left <= right) continue;
            return 1;
        }
        if (this.qualifier.isPresent() && !another.qualifier.isPresent()) {
            return -1;
        }
        if (!this.qualifier.isPresent() && another.qualifier.isPresent()) {
            return 1;
        }
        if (this.qualifier.isPresent() && another.qualifier.isPresent()) {
            int c = ((String)this.qualifier.get()).compareTo((String)another.qualifier.get());
            if (c < 0) {
                return -1;
            }
            if (c > 0) {
                return 1;
            }
        }
        return 0;
    }

    public boolean isNewer(Version another) {
        return this.compareTo(another) > 0;
    }

    public boolean isOlder(Version another) {
        return this.compareTo(another) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version another = (Version)o;
        return this.versionNumbers.equals(another.versionNumbers) && this.qualifier.equals(another.qualifier);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int number : this.versionNumbers) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(Integer.toString(number));
        }
        if (this.qualifier.isPresent()) {
            sb.append("-").append((String)this.qualifier.get());
        }
        return sb.toString();
    }
}

