/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.digdag.client.api.ImmutableId;

public interface Id {
    public String get();

    public static Id of(String id) {
        return new ImmutableId(id);
    }

    @JsonCreator
    @Deprecated
    public static Id fromJson(JsonNode node) throws JsonMappingException {
        if (node.isTextual() || node.isNumber()) {
            return Id.of(node.asText());
        }
        throw new JsonMappingException("Invalid ID. Expected string but got " + node);
    }

    default public int asInt() throws NumberFormatException {
        return Integer.parseInt(this.get());
    }

    default public long asLong() throws NumberFormatException {
        return Long.parseLong(this.get());
    }
}

