/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.Id;
import io.digdag.client.api.NameOptionalId;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableNameOptionalId
implements NameOptionalId {
    private final String name;
    private final Optional<Id> id;

    private ImmutableNameOptionalId(String name, Optional<Id> id) {
        this.name = name;
        this.id = id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<Id> getId() {
        return this.id;
    }

    public final ImmutableNameOptionalId withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableNameOptionalId(newValue, this.id);
    }

    public final ImmutableNameOptionalId withId(Id value) {
        Optional newValue = Optional.of((Object)value);
        if (this.id.isPresent() && this.id.get() == value) {
            return this;
        }
        return new ImmutableNameOptionalId(this.name, (Optional<Id>)newValue);
    }

    public final ImmutableNameOptionalId withId(Optional<Id> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"id");
        if (!this.id.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.id.isPresent() && value.isPresent() && this.id.get() == value.get()) {
            return this;
        }
        return new ImmutableNameOptionalId(this.name, (Optional<Id>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNameOptionalId && this.equalTo((ImmutableNameOptionalId)another);
    }

    private boolean equalTo(ImmutableNameOptionalId another) {
        return this.name.equals(another.name) && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.id.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NameOptionalId").omitNullValues().add("name", (Object)this.name).add("id", this.id.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNameOptionalId fromJson(Json json) {
        Builder builder = ImmutableNameOptionalId.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        return builder.build();
    }

    public static ImmutableNameOptionalId copyOf(NameOptionalId instance) {
        if (instance instanceof ImmutableNameOptionalId) {
            return (ImmutableNameOptionalId)instance;
        }
        return ImmutableNameOptionalId.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private Optional<Id> id = Optional.absent();

        private Builder() {
        }

        public final Builder from(NameOptionalId instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.name(instance.getName());
            Optional<Id> idOptional = instance.getId();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(Id id) {
            this.id = Optional.of((Object)id);
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(Optional<Id> id) {
            this.id = (Optional)Preconditions.checkNotNull(id, (Object)"id");
            return this;
        }

        public ImmutableNameOptionalId build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNameOptionalId(this.name, this.id);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build NameOptionalId, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements NameOptionalId {
        @Nullable
        String name;
        Optional<Id> id = Optional.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="id")
        public void setId(Optional<Id> id) {
            this.id = id;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Id> getId() {
            throw new UnsupportedOperationException();
        }
    }
}

