/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.RestDirectDownloadHandle;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestDirectDownloadHandle
implements RestDirectDownloadHandle {
    private final String url;

    private ImmutableRestDirectDownloadHandle(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public final ImmutableRestDirectDownloadHandle withUrl(String value) {
        if (this.url.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"url");
        return new ImmutableRestDirectDownloadHandle(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestDirectDownloadHandle && this.equalTo((ImmutableRestDirectDownloadHandle)another);
    }

    private boolean equalTo(ImmutableRestDirectDownloadHandle another) {
        return this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.url.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestDirectDownloadHandle").omitNullValues().add("url", (Object)this.url).toString();
    }

    public static ImmutableRestDirectDownloadHandle copyOf(RestDirectDownloadHandle instance) {
        if (instance instanceof ImmutableRestDirectDownloadHandle) {
            return (ImmutableRestDirectDownloadHandle)instance;
        }
        return ImmutableRestDirectDownloadHandle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private long initBits = 1L;
        @Nullable
        private String url;

        private Builder() {
        }

        public final Builder from(RestDirectDownloadHandle instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.url(instance.getUrl());
            return this;
        }

        public final Builder url(String url) {
            this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRestDirectDownloadHandle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestDirectDownloadHandle(this.url);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build RestDirectDownloadHandle, some of required attributes are not set " + attributes;
        }
    }
}

