/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import io.digdag.client.api.RestDirectDownloadHandle;
import io.digdag.client.api.RestLogFileHandle;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestLogFileHandle
implements RestLogFileHandle {
    private final String fileName;
    private final long fileSize;
    private final String taskName;
    private final Instant fileTime;
    private final String agentId;
    private final Optional<RestDirectDownloadHandle> direct;

    private ImmutableRestLogFileHandle(String fileName, long fileSize, String taskName, Instant fileTime, String agentId, Optional<RestDirectDownloadHandle> direct) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.taskName = taskName;
        this.fileTime = fileTime;
        this.agentId = agentId;
        this.direct = direct;
    }

    @Override
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    @Override
    @JsonProperty(value="fileSize")
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    @JsonProperty(value="taskName")
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    @JsonProperty(value="fileTime")
    public Instant getFileTime() {
        return this.fileTime;
    }

    @Override
    @JsonProperty(value="agentId")
    public String getAgentId() {
        return this.agentId;
    }

    @Override
    @JsonProperty(value="direct")
    public Optional<RestDirectDownloadHandle> getDirect() {
        return this.direct;
    }

    public final ImmutableRestLogFileHandle withFileName(String value) {
        if (this.fileName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"fileName");
        return new ImmutableRestLogFileHandle(newValue, this.fileSize, this.taskName, this.fileTime, this.agentId, this.direct);
    }

    public final ImmutableRestLogFileHandle withFileSize(long value) {
        if (this.fileSize == value) {
            return this;
        }
        return new ImmutableRestLogFileHandle(this.fileName, value, this.taskName, this.fileTime, this.agentId, this.direct);
    }

    public final ImmutableRestLogFileHandle withTaskName(String value) {
        if (this.taskName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"taskName");
        return new ImmutableRestLogFileHandle(this.fileName, this.fileSize, newValue, this.fileTime, this.agentId, this.direct);
    }

    public final ImmutableRestLogFileHandle withFileTime(Instant value) {
        if (this.fileTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"fileTime");
        return new ImmutableRestLogFileHandle(this.fileName, this.fileSize, this.taskName, newValue, this.agentId, this.direct);
    }

    public final ImmutableRestLogFileHandle withAgentId(String value) {
        if (this.agentId.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"agentId");
        return new ImmutableRestLogFileHandle(this.fileName, this.fileSize, this.taskName, this.fileTime, newValue, this.direct);
    }

    public final ImmutableRestLogFileHandle withDirect(RestDirectDownloadHandle value) {
        Optional newValue = Optional.of((Object)value);
        if (this.direct.isPresent() && this.direct.get() == value) {
            return this;
        }
        return new ImmutableRestLogFileHandle(this.fileName, this.fileSize, this.taskName, this.fileTime, this.agentId, (Optional<RestDirectDownloadHandle>)newValue);
    }

    public final ImmutableRestLogFileHandle withDirect(Optional<RestDirectDownloadHandle> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"direct");
        if (!this.direct.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.direct.isPresent() && value.isPresent() && this.direct.get() == value.get()) {
            return this;
        }
        return new ImmutableRestLogFileHandle(this.fileName, this.fileSize, this.taskName, this.fileTime, this.agentId, (Optional<RestDirectDownloadHandle>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestLogFileHandle && this.equalTo((ImmutableRestLogFileHandle)another);
    }

    private boolean equalTo(ImmutableRestLogFileHandle another) {
        return this.fileName.equals(another.fileName) && this.fileSize == another.fileSize && this.taskName.equals(another.taskName) && this.fileTime.equals(another.fileTime) && this.agentId.equals(another.agentId) && this.direct.equals(another.direct);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.fileName.hashCode();
        h = h * 17 + Longs.hashCode((long)this.fileSize);
        h = h * 17 + this.taskName.hashCode();
        h = h * 17 + this.fileTime.hashCode();
        h = h * 17 + this.agentId.hashCode();
        h = h * 17 + this.direct.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestLogFileHandle").omitNullValues().add("fileName", (Object)this.fileName).add("fileSize", this.fileSize).add("taskName", (Object)this.taskName).add("fileTime", (Object)this.fileTime).add("agentId", (Object)this.agentId).add("direct", this.direct.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestLogFileHandle fromJson(Json json) {
        Builder builder = ImmutableRestLogFileHandle.builder();
        if (json.fileName != null) {
            builder.fileName(json.fileName);
        }
        if (json.fileSizeIsSet) {
            builder.fileSize(json.fileSize);
        }
        if (json.taskName != null) {
            builder.taskName(json.taskName);
        }
        if (json.fileTime != null) {
            builder.fileTime(json.fileTime);
        }
        if (json.agentId != null) {
            builder.agentId(json.agentId);
        }
        if (json.direct != null) {
            builder.direct(json.direct);
        }
        return builder.build();
    }

    public static ImmutableRestLogFileHandle copyOf(RestLogFileHandle instance) {
        if (instance instanceof ImmutableRestLogFileHandle) {
            return (ImmutableRestLogFileHandle)instance;
        }
        return ImmutableRestLogFileHandle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FILE_NAME = 1L;
        private static final long INIT_BIT_FILE_SIZE = 2L;
        private static final long INIT_BIT_TASK_NAME = 4L;
        private static final long INIT_BIT_FILE_TIME = 8L;
        private static final long INIT_BIT_AGENT_ID = 16L;
        private long initBits = 31L;
        @Nullable
        private String fileName;
        private long fileSize;
        @Nullable
        private String taskName;
        @Nullable
        private Instant fileTime;
        @Nullable
        private String agentId;
        private Optional<RestDirectDownloadHandle> direct = Optional.absent();

        private Builder() {
        }

        public final Builder from(RestLogFileHandle instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.fileName(instance.getFileName());
            this.fileSize(instance.getFileSize());
            this.taskName(instance.getTaskName());
            this.fileTime(instance.getFileTime());
            this.agentId(instance.getAgentId());
            Optional<RestDirectDownloadHandle> directOptional = instance.getDirect();
            if (directOptional.isPresent()) {
                this.direct(directOptional);
            }
            return this;
        }

        @JsonProperty(value="fileName")
        public final Builder fileName(String fileName) {
            this.fileName = (String)Preconditions.checkNotNull((Object)fileName, (Object)"fileName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="fileSize")
        public final Builder fileSize(long fileSize) {
            this.fileSize = fileSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="taskName")
        public final Builder taskName(String taskName) {
            this.taskName = (String)Preconditions.checkNotNull((Object)taskName, (Object)"taskName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="fileTime")
        public final Builder fileTime(Instant fileTime) {
            this.fileTime = (Instant)Preconditions.checkNotNull((Object)fileTime, (Object)"fileTime");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="agentId")
        public final Builder agentId(String agentId) {
            this.agentId = (String)Preconditions.checkNotNull((Object)agentId, (Object)"agentId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder direct(RestDirectDownloadHandle direct) {
            this.direct = Optional.of((Object)direct);
            return this;
        }

        @JsonProperty(value="direct")
        public final Builder direct(Optional<RestDirectDownloadHandle> direct) {
            this.direct = (Optional)Preconditions.checkNotNull(direct, (Object)"direct");
            return this;
        }

        public ImmutableRestLogFileHandle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestLogFileHandle(this.fileName, this.fileSize, this.taskName, this.fileTime, this.agentId, this.direct);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fileName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fileSize");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("taskName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("fileTime");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("agentId");
            }
            return "Cannot build RestLogFileHandle, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestLogFileHandle {
        @Nullable
        String fileName;
        long fileSize;
        boolean fileSizeIsSet;
        @Nullable
        String taskName;
        @Nullable
        Instant fileTime;
        @Nullable
        String agentId;
        Optional<RestDirectDownloadHandle> direct = Optional.absent();

        Json() {
        }

        @JsonProperty(value="fileName")
        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @JsonProperty(value="fileSize")
        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
            this.fileSizeIsSet = true;
        }

        @JsonProperty(value="taskName")
        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        @JsonProperty(value="fileTime")
        public void setFileTime(Instant fileTime) {
            this.fileTime = fileTime;
        }

        @JsonProperty(value="agentId")
        public void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @JsonProperty(value="direct")
        public void setDirect(Optional<RestDirectDownloadHandle> direct) {
            this.direct = direct;
        }

        @Override
        public String getFileName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getFileSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTaskName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getFileTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAgentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<RestDirectDownloadHandle> getDirect() {
            throw new UnsupportedOperationException();
        }
    }
}

