/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.digdag.client.api.RestLogFileHandle;
import io.digdag.client.api.RestLogFileHandleCollection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestLogFileHandleCollection
implements RestLogFileHandleCollection {
    private final ImmutableList<RestLogFileHandle> files;

    private ImmutableRestLogFileHandleCollection(ImmutableList<RestLogFileHandle> files) {
        this.files = files;
    }

    @JsonProperty(value="files")
    public ImmutableList<RestLogFileHandle> getFiles() {
        return this.files;
    }

    public final ImmutableRestLogFileHandleCollection withFiles(RestLogFileHandle ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestLogFileHandleCollection((ImmutableList<RestLogFileHandle>)newValue);
    }

    public final ImmutableRestLogFileHandleCollection withFiles(Iterable<? extends RestLogFileHandle> elements) {
        if (this.files == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestLogFileHandleCollection((ImmutableList<RestLogFileHandle>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestLogFileHandleCollection && this.equalTo((ImmutableRestLogFileHandleCollection)another);
    }

    private boolean equalTo(ImmutableRestLogFileHandleCollection another) {
        return this.files.equals(another.files);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.files.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestLogFileHandleCollection").omitNullValues().add("files", this.files).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestLogFileHandleCollection fromJson(Json json) {
        Builder builder = ImmutableRestLogFileHandleCollection.builder();
        if (json.files != null) {
            builder.addAllFiles(json.files);
        }
        return builder.build();
    }

    public static ImmutableRestLogFileHandleCollection copyOf(RestLogFileHandleCollection instance) {
        if (instance instanceof ImmutableRestLogFileHandleCollection) {
            return (ImmutableRestLogFileHandleCollection)instance;
        }
        return ImmutableRestLogFileHandleCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<RestLogFileHandle> files = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(RestLogFileHandleCollection instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllFiles(instance.getFiles());
            return this;
        }

        public final Builder addFiles(RestLogFileHandle element) {
            this.files.add((Object)element);
            return this;
        }

        public final Builder addFiles(RestLogFileHandle ... elements) {
            this.files.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="files")
        public final Builder files(Iterable<? extends RestLogFileHandle> elements) {
            this.files = ImmutableList.builder();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends RestLogFileHandle> elements) {
            this.files.addAll(elements);
            return this;
        }

        public ImmutableRestLogFileHandleCollection build() {
            return new ImmutableRestLogFileHandleCollection(this.files.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestLogFileHandleCollection {
        List<RestLogFileHandle> files = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="files")
        public void setFiles(List<RestLogFileHandle> files) {
            this.files = files;
        }

        @Override
        public List<RestLogFileHandle> getFiles() {
            throw new UnsupportedOperationException();
        }
    }
}

