/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.RestLogFilePutResult;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestLogFilePutResult
implements RestLogFilePutResult {
    private final String fileName;

    private ImmutableRestLogFilePutResult(String fileName) {
        this.fileName = fileName;
    }

    @Override
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public final ImmutableRestLogFilePutResult withFileName(String value) {
        if (this.fileName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"fileName");
        return new ImmutableRestLogFilePutResult(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestLogFilePutResult && this.equalTo((ImmutableRestLogFilePutResult)another);
    }

    private boolean equalTo(ImmutableRestLogFilePutResult another) {
        return this.fileName.equals(another.fileName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.fileName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestLogFilePutResult").omitNullValues().add("fileName", (Object)this.fileName).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestLogFilePutResult fromJson(Json json) {
        Builder builder = ImmutableRestLogFilePutResult.builder();
        if (json.fileName != null) {
            builder.fileName(json.fileName);
        }
        return builder.build();
    }

    public static ImmutableRestLogFilePutResult copyOf(RestLogFilePutResult instance) {
        if (instance instanceof ImmutableRestLogFilePutResult) {
            return (ImmutableRestLogFilePutResult)instance;
        }
        return ImmutableRestLogFilePutResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FILE_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String fileName;

        private Builder() {
        }

        public final Builder from(RestLogFilePutResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.fileName(instance.getFileName());
            return this;
        }

        @JsonProperty(value="fileName")
        public final Builder fileName(String fileName) {
            this.fileName = (String)Preconditions.checkNotNull((Object)fileName, (Object)"fileName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRestLogFilePutResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestLogFilePutResult(this.fileName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fileName");
            }
            return "Cannot build RestLogFilePutResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestLogFilePutResult {
        @Nullable
        String fileName;

        Json() {
        }

        @JsonProperty(value="fileName")
        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public String getFileName() {
            throw new UnsupportedOperationException();
        }
    }
}

