/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.Id;
import io.digdag.client.api.RestProject;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestProject
implements RestProject {
    private final Id id;
    private final String name;
    private final String revision;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Optional<Instant> deletedAt;
    private final String archiveType;
    private final Optional<byte[]> archiveMd5;

    private ImmutableRestProject(Id id, String name, String revision, Instant createdAt, Instant updatedAt, Optional<Instant> deletedAt, String archiveType, Optional<byte[]> archiveMd5) {
        this.id = id;
        this.name = name;
        this.revision = revision;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.deletedAt = deletedAt;
        this.archiveType = archiveType;
        this.archiveMd5 = archiveMd5;
    }

    @Override
    @JsonProperty(value="id")
    public Id getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="revision")
    public String getRevision() {
        return this.revision;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="deletedAt")
    public Optional<Instant> getDeletedAt() {
        return this.deletedAt;
    }

    @Override
    @JsonProperty(value="archiveType")
    public String getArchiveType() {
        return this.archiveType;
    }

    @Override
    @JsonProperty(value="archiveMd5")
    public Optional<byte[]> getArchiveMd5() {
        return this.archiveMd5;
    }

    public final ImmutableRestProject withId(Id value) {
        if (this.id == value) {
            return this;
        }
        Id newValue = (Id)Preconditions.checkNotNull((Object)value, (Object)"id");
        return new ImmutableRestProject(newValue, this.name, this.revision, this.createdAt, this.updatedAt, this.deletedAt, this.archiveType, this.archiveMd5);
    }

    public final ImmutableRestProject withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableRestProject(this.id, newValue, this.revision, this.createdAt, this.updatedAt, this.deletedAt, this.archiveType, this.archiveMd5);
    }

    public final ImmutableRestProject withRevision(String value) {
        if (this.revision.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"revision");
        return new ImmutableRestProject(this.id, this.name, newValue, this.createdAt, this.updatedAt, this.deletedAt, this.archiveType, this.archiveMd5);
    }

    public final ImmutableRestProject withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableRestProject(this.id, this.name, this.revision, newValue, this.updatedAt, this.deletedAt, this.archiveType, this.archiveMd5);
    }

    public final ImmutableRestProject withUpdatedAt(Instant value) {
        if (this.updatedAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"updatedAt");
        return new ImmutableRestProject(this.id, this.name, this.revision, this.createdAt, newValue, this.deletedAt, this.archiveType, this.archiveMd5);
    }

    public final ImmutableRestProject withDeletedAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.deletedAt.isPresent() && this.deletedAt.get() == value) {
            return this;
        }
        return new ImmutableRestProject(this.id, this.name, this.revision, this.createdAt, this.updatedAt, (Optional<Instant>)newValue, this.archiveType, this.archiveMd5);
    }

    public final ImmutableRestProject withDeletedAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"deletedAt");
        if (!this.deletedAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.deletedAt.isPresent() && value.isPresent() && this.deletedAt.get() == value.get()) {
            return this;
        }
        return new ImmutableRestProject(this.id, this.name, this.revision, this.createdAt, this.updatedAt, (Optional<Instant>)value, this.archiveType, this.archiveMd5);
    }

    public final ImmutableRestProject withArchiveType(String value) {
        if (this.archiveType.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"archiveType");
        return new ImmutableRestProject(this.id, this.name, this.revision, this.createdAt, this.updatedAt, this.deletedAt, newValue, this.archiveMd5);
    }

    public final ImmutableRestProject withArchiveMd5(byte[] value) {
        Optional newValue = Optional.of((Object)value);
        if (this.archiveMd5.isPresent() && this.archiveMd5.get() == value) {
            return this;
        }
        return new ImmutableRestProject(this.id, this.name, this.revision, this.createdAt, this.updatedAt, this.deletedAt, this.archiveType, (Optional<byte[]>)newValue);
    }

    public final ImmutableRestProject withArchiveMd5(Optional<byte[]> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"archiveMd5");
        if (!this.archiveMd5.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.archiveMd5.isPresent() && value.isPresent() && this.archiveMd5.get() == value.get()) {
            return this;
        }
        return new ImmutableRestProject(this.id, this.name, this.revision, this.createdAt, this.updatedAt, this.deletedAt, this.archiveType, (Optional<byte[]>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestProject && this.equalTo((ImmutableRestProject)another);
    }

    private boolean equalTo(ImmutableRestProject another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.revision.equals(another.revision) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.deletedAt.equals(another.deletedAt) && this.archiveType.equals(another.archiveType) && this.archiveMd5.equals(another.archiveMd5);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.revision.hashCode();
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.updatedAt.hashCode();
        h = h * 17 + this.deletedAt.hashCode();
        h = h * 17 + this.archiveType.hashCode();
        h = h * 17 + this.archiveMd5.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestProject").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("revision", (Object)this.revision).add("createdAt", (Object)this.createdAt).add("updatedAt", (Object)this.updatedAt).add("deletedAt", this.deletedAt.orNull()).add("archiveType", (Object)this.archiveType).add("archiveMd5", this.archiveMd5.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestProject fromJson(Json json) {
        Builder builder = ImmutableRestProject.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.revision != null) {
            builder.revision(json.revision);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.deletedAt != null) {
            builder.deletedAt(json.deletedAt);
        }
        if (json.archiveType != null) {
            builder.archiveType(json.archiveType);
        }
        if (json.archiveMd5 != null) {
            builder.archiveMd5(json.archiveMd5);
        }
        return builder.build();
    }

    public static ImmutableRestProject copyOf(RestProject instance) {
        if (instance instanceof ImmutableRestProject) {
            return (ImmutableRestProject)instance;
        }
        return ImmutableRestProject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_REVISION = 4L;
        private static final long INIT_BIT_CREATED_AT = 8L;
        private static final long INIT_BIT_UPDATED_AT = 16L;
        private static final long INIT_BIT_ARCHIVE_TYPE = 32L;
        private long initBits = 63L;
        @Nullable
        private Id id;
        @Nullable
        private String name;
        @Nullable
        private String revision;
        @Nullable
        private Instant createdAt;
        @Nullable
        private Instant updatedAt;
        private Optional<Instant> deletedAt = Optional.absent();
        @Nullable
        private String archiveType;
        private Optional<byte[]> archiveMd5 = Optional.absent();

        private Builder() {
        }

        public final Builder from(RestProject instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.revision(instance.getRevision());
            this.createdAt(instance.getCreatedAt());
            this.updatedAt(instance.getUpdatedAt());
            Optional<Instant> deletedAtOptional = instance.getDeletedAt();
            if (deletedAtOptional.isPresent()) {
                this.deletedAt(deletedAtOptional);
            }
            this.archiveType(instance.getArchiveType());
            Optional<byte[]> archiveMd5Optional = instance.getArchiveMd5();
            if (archiveMd5Optional.isPresent()) {
                this.archiveMd5(archiveMd5Optional);
            }
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(Id id) {
            this.id = (Id)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="revision")
        public final Builder revision(String revision) {
            this.revision = (String)Preconditions.checkNotNull((Object)revision, (Object)"revision");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="createdAt")
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="updatedAt")
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = (Instant)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = Optional.of((Object)deletedAt);
            return this;
        }

        @JsonProperty(value="deletedAt")
        public final Builder deletedAt(Optional<Instant> deletedAt) {
            this.deletedAt = (Optional)Preconditions.checkNotNull(deletedAt, (Object)"deletedAt");
            return this;
        }

        @JsonProperty(value="archiveType")
        public final Builder archiveType(String archiveType) {
            this.archiveType = (String)Preconditions.checkNotNull((Object)archiveType, (Object)"archiveType");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder archiveMd5(byte[] archiveMd5) {
            this.archiveMd5 = Optional.of((Object)archiveMd5);
            return this;
        }

        @JsonProperty(value="archiveMd5")
        public final Builder archiveMd5(Optional<byte[]> archiveMd5) {
            this.archiveMd5 = (Optional)Preconditions.checkNotNull(archiveMd5, (Object)"archiveMd5");
            return this;
        }

        public ImmutableRestProject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestProject(this.id, this.name, this.revision, this.createdAt, this.updatedAt, this.deletedAt, this.archiveType, this.archiveMd5);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("revision");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("archiveType");
            }
            return "Cannot build RestProject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestProject {
        @Nullable
        Id id;
        @Nullable
        String name;
        @Nullable
        String revision;
        @Nullable
        Instant createdAt;
        @Nullable
        Instant updatedAt;
        Optional<Instant> deletedAt = Optional.absent();
        @Nullable
        String archiveType;
        Optional<byte[]> archiveMd5 = Optional.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="revision")
        public void setRevision(String revision) {
            this.revision = revision;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updatedAt")
        public void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="deletedAt")
        public void setDeletedAt(Optional<Instant> deletedAt) {
            this.deletedAt = deletedAt;
        }

        @JsonProperty(value="archiveType")
        public void setArchiveType(String archiveType) {
            this.archiveType = archiveType;
        }

        @JsonProperty(value="archiveMd5")
        public void setArchiveMd5(Optional<byte[]> archiveMd5) {
            this.archiveMd5 = archiveMd5;
        }

        @Override
        public Id getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRevision() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getDeletedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getArchiveType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<byte[]> getArchiveMd5() {
            throw new UnsupportedOperationException();
        }
    }
}

