/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.digdag.client.api.RestProject;
import io.digdag.client.api.RestProjectCollection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestProjectCollection
implements RestProjectCollection {
    private final ImmutableList<RestProject> projects;

    private ImmutableRestProjectCollection(ImmutableList<RestProject> projects) {
        this.projects = projects;
    }

    @JsonProperty(value="projects")
    public ImmutableList<RestProject> getProjects() {
        return this.projects;
    }

    public final ImmutableRestProjectCollection withProjects(RestProject ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestProjectCollection((ImmutableList<RestProject>)newValue);
    }

    public final ImmutableRestProjectCollection withProjects(Iterable<? extends RestProject> elements) {
        if (this.projects == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestProjectCollection((ImmutableList<RestProject>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestProjectCollection && this.equalTo((ImmutableRestProjectCollection)another);
    }

    private boolean equalTo(ImmutableRestProjectCollection another) {
        return this.projects.equals(another.projects);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.projects.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestProjectCollection").omitNullValues().add("projects", this.projects).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestProjectCollection fromJson(Json json) {
        Builder builder = ImmutableRestProjectCollection.builder();
        if (json.projects != null) {
            builder.addAllProjects(json.projects);
        }
        return builder.build();
    }

    public static ImmutableRestProjectCollection copyOf(RestProjectCollection instance) {
        if (instance instanceof ImmutableRestProjectCollection) {
            return (ImmutableRestProjectCollection)instance;
        }
        return ImmutableRestProjectCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<RestProject> projects = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(RestProjectCollection instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllProjects(instance.getProjects());
            return this;
        }

        public final Builder addProjects(RestProject element) {
            this.projects.add((Object)element);
            return this;
        }

        public final Builder addProjects(RestProject ... elements) {
            this.projects.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="projects")
        public final Builder projects(Iterable<? extends RestProject> elements) {
            this.projects = ImmutableList.builder();
            return this.addAllProjects(elements);
        }

        public final Builder addAllProjects(Iterable<? extends RestProject> elements) {
            this.projects.addAll(elements);
            return this;
        }

        public ImmutableRestProjectCollection build() {
            return new ImmutableRestProjectCollection(this.projects.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestProjectCollection {
        List<RestProject> projects = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="projects")
        public void setProjects(List<RestProject> projects) {
            this.projects = projects;
        }

        @Override
        public List<RestProject> getProjects() {
            throw new UnsupportedOperationException();
        }
    }
}

