/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.RestRevision;
import io.digdag.client.config.Config;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestRevision
implements RestRevision {
    private final String revision;
    private final Instant createdAt;
    private final String archiveType;
    private final Optional<byte[]> archiveMd5;
    private final Optional<Config> userInfo;

    private ImmutableRestRevision(String revision, Instant createdAt, String archiveType, Optional<byte[]> archiveMd5, Optional<Config> userInfo) {
        this.revision = revision;
        this.createdAt = createdAt;
        this.archiveType = archiveType;
        this.archiveMd5 = archiveMd5;
        this.userInfo = userInfo;
    }

    @Override
    @JsonProperty(value="revision")
    public String getRevision() {
        return this.revision;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="archiveType")
    public String getArchiveType() {
        return this.archiveType;
    }

    @Override
    @JsonProperty(value="archiveMd5")
    public Optional<byte[]> getArchiveMd5() {
        return this.archiveMd5;
    }

    @Override
    @JsonProperty(value="userInfo")
    public Optional<Config> getUserInfo() {
        return this.userInfo;
    }

    public final ImmutableRestRevision withRevision(String value) {
        if (this.revision.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"revision");
        return new ImmutableRestRevision(newValue, this.createdAt, this.archiveType, this.archiveMd5, this.userInfo);
    }

    public final ImmutableRestRevision withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableRestRevision(this.revision, newValue, this.archiveType, this.archiveMd5, this.userInfo);
    }

    public final ImmutableRestRevision withArchiveType(String value) {
        if (this.archiveType.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"archiveType");
        return new ImmutableRestRevision(this.revision, this.createdAt, newValue, this.archiveMd5, this.userInfo);
    }

    public final ImmutableRestRevision withArchiveMd5(byte[] value) {
        Optional newValue = Optional.of((Object)value);
        if (this.archiveMd5.isPresent() && this.archiveMd5.get() == value) {
            return this;
        }
        return new ImmutableRestRevision(this.revision, this.createdAt, this.archiveType, (Optional<byte[]>)newValue, this.userInfo);
    }

    public final ImmutableRestRevision withArchiveMd5(Optional<byte[]> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"archiveMd5");
        if (!this.archiveMd5.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.archiveMd5.isPresent() && value.isPresent() && this.archiveMd5.get() == value.get()) {
            return this;
        }
        return new ImmutableRestRevision(this.revision, this.createdAt, this.archiveType, (Optional<byte[]>)value, this.userInfo);
    }

    public final ImmutableRestRevision withUserInfo(Config value) {
        Optional newValue = Optional.of((Object)value);
        if (this.userInfo.isPresent() && this.userInfo.get() == value) {
            return this;
        }
        return new ImmutableRestRevision(this.revision, this.createdAt, this.archiveType, this.archiveMd5, (Optional<Config>)newValue);
    }

    public final ImmutableRestRevision withUserInfo(Optional<Config> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"userInfo");
        if (!this.userInfo.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.userInfo.isPresent() && value.isPresent() && this.userInfo.get() == value.get()) {
            return this;
        }
        return new ImmutableRestRevision(this.revision, this.createdAt, this.archiveType, this.archiveMd5, (Optional<Config>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestRevision && this.equalTo((ImmutableRestRevision)another);
    }

    private boolean equalTo(ImmutableRestRevision another) {
        return this.revision.equals(another.revision) && this.createdAt.equals(another.createdAt) && this.archiveType.equals(another.archiveType) && this.archiveMd5.equals(another.archiveMd5) && this.userInfo.equals(another.userInfo);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.revision.hashCode();
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.archiveType.hashCode();
        h = h * 17 + this.archiveMd5.hashCode();
        h = h * 17 + this.userInfo.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestRevision").omitNullValues().add("revision", (Object)this.revision).add("createdAt", (Object)this.createdAt).add("archiveType", (Object)this.archiveType).add("archiveMd5", this.archiveMd5.orNull()).add("userInfo", this.userInfo.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestRevision fromJson(Json json) {
        Builder builder = ImmutableRestRevision.builder();
        if (json.revision != null) {
            builder.revision(json.revision);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.archiveType != null) {
            builder.archiveType(json.archiveType);
        }
        if (json.archiveMd5 != null) {
            builder.archiveMd5(json.archiveMd5);
        }
        if (json.userInfo != null) {
            builder.userInfo(json.userInfo);
        }
        return builder.build();
    }

    public static ImmutableRestRevision copyOf(RestRevision instance) {
        if (instance instanceof ImmutableRestRevision) {
            return (ImmutableRestRevision)instance;
        }
        return ImmutableRestRevision.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REVISION = 1L;
        private static final long INIT_BIT_CREATED_AT = 2L;
        private static final long INIT_BIT_ARCHIVE_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private String revision;
        @Nullable
        private Instant createdAt;
        @Nullable
        private String archiveType;
        private Optional<byte[]> archiveMd5 = Optional.absent();
        private Optional<Config> userInfo = Optional.absent();

        private Builder() {
        }

        public final Builder from(RestRevision instance) {
            Optional<Config> userInfoOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.revision(instance.getRevision());
            this.createdAt(instance.getCreatedAt());
            this.archiveType(instance.getArchiveType());
            Optional<byte[]> archiveMd5Optional = instance.getArchiveMd5();
            if (archiveMd5Optional.isPresent()) {
                this.archiveMd5(archiveMd5Optional);
            }
            if ((userInfoOptional = instance.getUserInfo()).isPresent()) {
                this.userInfo(userInfoOptional);
            }
            return this;
        }

        @JsonProperty(value="revision")
        public final Builder revision(String revision) {
            this.revision = (String)Preconditions.checkNotNull((Object)revision, (Object)"revision");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="createdAt")
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="archiveType")
        public final Builder archiveType(String archiveType) {
            this.archiveType = (String)Preconditions.checkNotNull((Object)archiveType, (Object)"archiveType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder archiveMd5(byte[] archiveMd5) {
            this.archiveMd5 = Optional.of((Object)archiveMd5);
            return this;
        }

        @JsonProperty(value="archiveMd5")
        public final Builder archiveMd5(Optional<byte[]> archiveMd5) {
            this.archiveMd5 = (Optional)Preconditions.checkNotNull(archiveMd5, (Object)"archiveMd5");
            return this;
        }

        public final Builder userInfo(Config userInfo) {
            this.userInfo = Optional.of((Object)userInfo);
            return this;
        }

        @JsonProperty(value="userInfo")
        public final Builder userInfo(Optional<Config> userInfo) {
            this.userInfo = (Optional)Preconditions.checkNotNull(userInfo, (Object)"userInfo");
            return this;
        }

        public ImmutableRestRevision build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestRevision(this.revision, this.createdAt, this.archiveType, this.archiveMd5, this.userInfo);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("revision");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("archiveType");
            }
            return "Cannot build RestRevision, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestRevision {
        @Nullable
        String revision;
        @Nullable
        Instant createdAt;
        @Nullable
        String archiveType;
        Optional<byte[]> archiveMd5 = Optional.absent();
        Optional<Config> userInfo = Optional.absent();

        Json() {
        }

        @JsonProperty(value="revision")
        public void setRevision(String revision) {
            this.revision = revision;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="archiveType")
        public void setArchiveType(String archiveType) {
            this.archiveType = archiveType;
        }

        @JsonProperty(value="archiveMd5")
        public void setArchiveMd5(Optional<byte[]> archiveMd5) {
            this.archiveMd5 = archiveMd5;
        }

        @JsonProperty(value="userInfo")
        public void setUserInfo(Optional<Config> userInfo) {
            this.userInfo = userInfo;
        }

        @Override
        public String getRevision() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getArchiveType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<byte[]> getArchiveMd5() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Config> getUserInfo() {
            throw new UnsupportedOperationException();
        }
    }
}

