/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.digdag.client.api.RestRevision;
import io.digdag.client.api.RestRevisionCollection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestRevisionCollection
implements RestRevisionCollection {
    private final ImmutableList<RestRevision> revisions;

    private ImmutableRestRevisionCollection(ImmutableList<RestRevision> revisions) {
        this.revisions = revisions;
    }

    @JsonProperty(value="revisions")
    public ImmutableList<RestRevision> getRevisions() {
        return this.revisions;
    }

    public final ImmutableRestRevisionCollection withRevisions(RestRevision ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestRevisionCollection((ImmutableList<RestRevision>)newValue);
    }

    public final ImmutableRestRevisionCollection withRevisions(Iterable<? extends RestRevision> elements) {
        if (this.revisions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestRevisionCollection((ImmutableList<RestRevision>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestRevisionCollection && this.equalTo((ImmutableRestRevisionCollection)another);
    }

    private boolean equalTo(ImmutableRestRevisionCollection another) {
        return this.revisions.equals(another.revisions);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.revisions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestRevisionCollection").omitNullValues().add("revisions", this.revisions).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestRevisionCollection fromJson(Json json) {
        Builder builder = ImmutableRestRevisionCollection.builder();
        if (json.revisions != null) {
            builder.addAllRevisions(json.revisions);
        }
        return builder.build();
    }

    public static ImmutableRestRevisionCollection copyOf(RestRevisionCollection instance) {
        if (instance instanceof ImmutableRestRevisionCollection) {
            return (ImmutableRestRevisionCollection)instance;
        }
        return ImmutableRestRevisionCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<RestRevision> revisions = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(RestRevisionCollection instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllRevisions(instance.getRevisions());
            return this;
        }

        public final Builder addRevisions(RestRevision element) {
            this.revisions.add((Object)element);
            return this;
        }

        public final Builder addRevisions(RestRevision ... elements) {
            this.revisions.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="revisions")
        public final Builder revisions(Iterable<? extends RestRevision> elements) {
            this.revisions = ImmutableList.builder();
            return this.addAllRevisions(elements);
        }

        public final Builder addAllRevisions(Iterable<? extends RestRevision> elements) {
            this.revisions.addAll(elements);
            return this;
        }

        public ImmutableRestRevisionCollection build() {
            return new ImmutableRestRevisionCollection(this.revisions.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestRevisionCollection {
        List<RestRevision> revisions = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="revisions")
        public void setRevisions(List<RestRevision> revisions) {
            this.revisions = revisions;
        }

        @Override
        public List<RestRevision> getRevisions() {
            throw new UnsupportedOperationException();
        }
    }
}

