/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.Id;
import io.digdag.client.api.IdAndName;
import io.digdag.client.api.RestSchedule;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestSchedule
implements RestSchedule {
    private final Id id;
    private final IdAndName project;
    private final IdAndName workflow;
    private final Instant nextRunTime;
    private final OffsetDateTime nextScheduleTime;
    private final Optional<Instant> disabledAt;

    private ImmutableRestSchedule(Id id, IdAndName project, IdAndName workflow, Instant nextRunTime, OffsetDateTime nextScheduleTime, Optional<Instant> disabledAt) {
        this.id = id;
        this.project = project;
        this.workflow = workflow;
        this.nextRunTime = nextRunTime;
        this.nextScheduleTime = nextScheduleTime;
        this.disabledAt = disabledAt;
    }

    @Override
    @JsonProperty(value="id")
    public Id getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="project")
    public IdAndName getProject() {
        return this.project;
    }

    @Override
    @JsonProperty(value="workflow")
    public IdAndName getWorkflow() {
        return this.workflow;
    }

    @Override
    @JsonProperty(value="nextRunTime")
    public Instant getNextRunTime() {
        return this.nextRunTime;
    }

    @Override
    @JsonProperty(value="nextScheduleTime")
    public OffsetDateTime getNextScheduleTime() {
        return this.nextScheduleTime;
    }

    @Override
    @JsonProperty(value="disabledAt")
    public Optional<Instant> getDisabledAt() {
        return this.disabledAt;
    }

    public final ImmutableRestSchedule withId(Id value) {
        if (this.id == value) {
            return this;
        }
        Id newValue = (Id)Preconditions.checkNotNull((Object)value, (Object)"id");
        return new ImmutableRestSchedule(newValue, this.project, this.workflow, this.nextRunTime, this.nextScheduleTime, this.disabledAt);
    }

    public final ImmutableRestSchedule withProject(IdAndName value) {
        if (this.project == value) {
            return this;
        }
        IdAndName newValue = (IdAndName)Preconditions.checkNotNull((Object)value, (Object)"project");
        return new ImmutableRestSchedule(this.id, newValue, this.workflow, this.nextRunTime, this.nextScheduleTime, this.disabledAt);
    }

    public final ImmutableRestSchedule withWorkflow(IdAndName value) {
        if (this.workflow == value) {
            return this;
        }
        IdAndName newValue = (IdAndName)Preconditions.checkNotNull((Object)value, (Object)"workflow");
        return new ImmutableRestSchedule(this.id, this.project, newValue, this.nextRunTime, this.nextScheduleTime, this.disabledAt);
    }

    public final ImmutableRestSchedule withNextRunTime(Instant value) {
        if (this.nextRunTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"nextRunTime");
        return new ImmutableRestSchedule(this.id, this.project, this.workflow, newValue, this.nextScheduleTime, this.disabledAt);
    }

    public final ImmutableRestSchedule withNextScheduleTime(OffsetDateTime value) {
        if (this.nextScheduleTime == value) {
            return this;
        }
        OffsetDateTime newValue = (OffsetDateTime)Preconditions.checkNotNull((Object)value, (Object)"nextScheduleTime");
        return new ImmutableRestSchedule(this.id, this.project, this.workflow, this.nextRunTime, newValue, this.disabledAt);
    }

    public final ImmutableRestSchedule withDisabledAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.disabledAt.isPresent() && this.disabledAt.get() == value) {
            return this;
        }
        return new ImmutableRestSchedule(this.id, this.project, this.workflow, this.nextRunTime, this.nextScheduleTime, (Optional<Instant>)newValue);
    }

    public final ImmutableRestSchedule withDisabledAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"disabledAt");
        if (!this.disabledAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.disabledAt.isPresent() && value.isPresent() && this.disabledAt.get() == value.get()) {
            return this;
        }
        return new ImmutableRestSchedule(this.id, this.project, this.workflow, this.nextRunTime, this.nextScheduleTime, (Optional<Instant>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestSchedule && this.equalTo((ImmutableRestSchedule)another);
    }

    private boolean equalTo(ImmutableRestSchedule another) {
        return this.id.equals(another.id) && this.project.equals(another.project) && this.workflow.equals(another.workflow) && this.nextRunTime.equals(another.nextRunTime) && this.nextScheduleTime.equals(another.nextScheduleTime) && this.disabledAt.equals(another.disabledAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.project.hashCode();
        h = h * 17 + this.workflow.hashCode();
        h = h * 17 + this.nextRunTime.hashCode();
        h = h * 17 + this.nextScheduleTime.hashCode();
        h = h * 17 + this.disabledAt.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestSchedule").omitNullValues().add("id", (Object)this.id).add("project", (Object)this.project).add("workflow", (Object)this.workflow).add("nextRunTime", (Object)this.nextRunTime).add("nextScheduleTime", (Object)this.nextScheduleTime).add("disabledAt", this.disabledAt.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestSchedule fromJson(Json json) {
        Builder builder = ImmutableRestSchedule.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.project != null) {
            builder.project(json.project);
        }
        if (json.workflow != null) {
            builder.workflow(json.workflow);
        }
        if (json.nextRunTime != null) {
            builder.nextRunTime(json.nextRunTime);
        }
        if (json.nextScheduleTime != null) {
            builder.nextScheduleTime(json.nextScheduleTime);
        }
        if (json.disabledAt != null) {
            builder.disabledAt(json.disabledAt);
        }
        return builder.build();
    }

    public static ImmutableRestSchedule copyOf(RestSchedule instance) {
        if (instance instanceof ImmutableRestSchedule) {
            return (ImmutableRestSchedule)instance;
        }
        return ImmutableRestSchedule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PROJECT = 2L;
        private static final long INIT_BIT_WORKFLOW = 4L;
        private static final long INIT_BIT_NEXT_RUN_TIME = 8L;
        private static final long INIT_BIT_NEXT_SCHEDULE_TIME = 16L;
        private long initBits = 31L;
        @Nullable
        private Id id;
        @Nullable
        private IdAndName project;
        @Nullable
        private IdAndName workflow;
        @Nullable
        private Instant nextRunTime;
        @Nullable
        private OffsetDateTime nextScheduleTime;
        private Optional<Instant> disabledAt = Optional.absent();

        private Builder() {
        }

        public final Builder from(RestSchedule instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.project(instance.getProject());
            this.workflow(instance.getWorkflow());
            this.nextRunTime(instance.getNextRunTime());
            this.nextScheduleTime(instance.getNextScheduleTime());
            Optional<Instant> disabledAtOptional = instance.getDisabledAt();
            if (disabledAtOptional.isPresent()) {
                this.disabledAt(disabledAtOptional);
            }
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(Id id) {
            this.id = (Id)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="project")
        public final Builder project(IdAndName project) {
            this.project = (IdAndName)Preconditions.checkNotNull((Object)project, (Object)"project");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="workflow")
        public final Builder workflow(IdAndName workflow) {
            this.workflow = (IdAndName)Preconditions.checkNotNull((Object)workflow, (Object)"workflow");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="nextRunTime")
        public final Builder nextRunTime(Instant nextRunTime) {
            this.nextRunTime = (Instant)Preconditions.checkNotNull((Object)nextRunTime, (Object)"nextRunTime");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="nextScheduleTime")
        public final Builder nextScheduleTime(OffsetDateTime nextScheduleTime) {
            this.nextScheduleTime = (OffsetDateTime)Preconditions.checkNotNull((Object)nextScheduleTime, (Object)"nextScheduleTime");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder disabledAt(Instant disabledAt) {
            this.disabledAt = Optional.of((Object)disabledAt);
            return this;
        }

        @JsonProperty(value="disabledAt")
        public final Builder disabledAt(Optional<Instant> disabledAt) {
            this.disabledAt = (Optional)Preconditions.checkNotNull(disabledAt, (Object)"disabledAt");
            return this;
        }

        public ImmutableRestSchedule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestSchedule(this.id, this.project, this.workflow, this.nextRunTime, this.nextScheduleTime, this.disabledAt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("project");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("workflow");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("nextRunTime");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("nextScheduleTime");
            }
            return "Cannot build RestSchedule, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestSchedule {
        @Nullable
        Id id;
        @Nullable
        IdAndName project;
        @Nullable
        IdAndName workflow;
        @Nullable
        Instant nextRunTime;
        @Nullable
        OffsetDateTime nextScheduleTime;
        Optional<Instant> disabledAt = Optional.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="project")
        public void setProject(IdAndName project) {
            this.project = project;
        }

        @JsonProperty(value="workflow")
        public void setWorkflow(IdAndName workflow) {
            this.workflow = workflow;
        }

        @JsonProperty(value="nextRunTime")
        public void setNextRunTime(Instant nextRunTime) {
            this.nextRunTime = nextRunTime;
        }

        @JsonProperty(value="nextScheduleTime")
        public void setNextScheduleTime(OffsetDateTime nextScheduleTime) {
            this.nextScheduleTime = nextScheduleTime;
        }

        @JsonProperty(value="disabledAt")
        public void setDisabledAt(Optional<Instant> disabledAt) {
            this.disabledAt = disabledAt;
        }

        @Override
        public Id getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IdAndName getProject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IdAndName getWorkflow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getNextRunTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime getNextScheduleTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getDisabledAt() {
            throw new UnsupportedOperationException();
        }
    }
}

