/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.digdag.client.api.Id;
import io.digdag.client.api.IdAndName;
import io.digdag.client.api.RestScheduleAttemptCollection;
import io.digdag.client.api.RestSessionAttempt;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestScheduleAttemptCollection
implements RestScheduleAttemptCollection {
    private final Id id;
    private final IdAndName project;
    private final IdAndName workflow;
    private final ImmutableList<RestSessionAttempt> attempts;

    private ImmutableRestScheduleAttemptCollection(Id id, IdAndName project, IdAndName workflow, ImmutableList<RestSessionAttempt> attempts) {
        this.id = id;
        this.project = project;
        this.workflow = workflow;
        this.attempts = attempts;
    }

    @Override
    @JsonProperty(value="id")
    public Id getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="project")
    public IdAndName getProject() {
        return this.project;
    }

    @Override
    @JsonProperty(value="workflow")
    public IdAndName getWorkflow() {
        return this.workflow;
    }

    @JsonProperty(value="attempts")
    public ImmutableList<RestSessionAttempt> getAttempts() {
        return this.attempts;
    }

    public final ImmutableRestScheduleAttemptCollection withId(Id value) {
        if (this.id == value) {
            return this;
        }
        Id newValue = (Id)Preconditions.checkNotNull((Object)value, (Object)"id");
        return new ImmutableRestScheduleAttemptCollection(newValue, this.project, this.workflow, this.attempts);
    }

    public final ImmutableRestScheduleAttemptCollection withProject(IdAndName value) {
        if (this.project == value) {
            return this;
        }
        IdAndName newValue = (IdAndName)Preconditions.checkNotNull((Object)value, (Object)"project");
        return new ImmutableRestScheduleAttemptCollection(this.id, newValue, this.workflow, this.attempts);
    }

    public final ImmutableRestScheduleAttemptCollection withWorkflow(IdAndName value) {
        if (this.workflow == value) {
            return this;
        }
        IdAndName newValue = (IdAndName)Preconditions.checkNotNull((Object)value, (Object)"workflow");
        return new ImmutableRestScheduleAttemptCollection(this.id, this.project, newValue, this.attempts);
    }

    public final ImmutableRestScheduleAttemptCollection withAttempts(RestSessionAttempt ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestScheduleAttemptCollection(this.id, this.project, this.workflow, (ImmutableList<RestSessionAttempt>)newValue);
    }

    public final ImmutableRestScheduleAttemptCollection withAttempts(Iterable<? extends RestSessionAttempt> elements) {
        if (this.attempts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestScheduleAttemptCollection(this.id, this.project, this.workflow, (ImmutableList<RestSessionAttempt>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestScheduleAttemptCollection && this.equalTo((ImmutableRestScheduleAttemptCollection)another);
    }

    private boolean equalTo(ImmutableRestScheduleAttemptCollection another) {
        return this.id.equals(another.id) && this.project.equals(another.project) && this.workflow.equals(another.workflow) && this.attempts.equals(another.attempts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.project.hashCode();
        h = h * 17 + this.workflow.hashCode();
        h = h * 17 + this.attempts.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestScheduleAttemptCollection").omitNullValues().add("id", (Object)this.id).add("project", (Object)this.project).add("workflow", (Object)this.workflow).add("attempts", this.attempts).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestScheduleAttemptCollection fromJson(Json json) {
        Builder builder = ImmutableRestScheduleAttemptCollection.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.project != null) {
            builder.project(json.project);
        }
        if (json.workflow != null) {
            builder.workflow(json.workflow);
        }
        if (json.attempts != null) {
            builder.addAllAttempts(json.attempts);
        }
        return builder.build();
    }

    public static ImmutableRestScheduleAttemptCollection copyOf(RestScheduleAttemptCollection instance) {
        if (instance instanceof ImmutableRestScheduleAttemptCollection) {
            return (ImmutableRestScheduleAttemptCollection)instance;
        }
        return ImmutableRestScheduleAttemptCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PROJECT = 2L;
        private static final long INIT_BIT_WORKFLOW = 4L;
        private long initBits = 7L;
        @Nullable
        private Id id;
        @Nullable
        private IdAndName project;
        @Nullable
        private IdAndName workflow;
        private ImmutableList.Builder<RestSessionAttempt> attempts = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(RestScheduleAttemptCollection instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.project(instance.getProject());
            this.workflow(instance.getWorkflow());
            this.addAllAttempts(instance.getAttempts());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(Id id) {
            this.id = (Id)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="project")
        public final Builder project(IdAndName project) {
            this.project = (IdAndName)Preconditions.checkNotNull((Object)project, (Object)"project");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="workflow")
        public final Builder workflow(IdAndName workflow) {
            this.workflow = (IdAndName)Preconditions.checkNotNull((Object)workflow, (Object)"workflow");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addAttempts(RestSessionAttempt element) {
            this.attempts.add((Object)element);
            return this;
        }

        public final Builder addAttempts(RestSessionAttempt ... elements) {
            this.attempts.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="attempts")
        public final Builder attempts(Iterable<? extends RestSessionAttempt> elements) {
            this.attempts = ImmutableList.builder();
            return this.addAllAttempts(elements);
        }

        public final Builder addAllAttempts(Iterable<? extends RestSessionAttempt> elements) {
            this.attempts.addAll(elements);
            return this;
        }

        public ImmutableRestScheduleAttemptCollection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestScheduleAttemptCollection(this.id, this.project, this.workflow, this.attempts.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("project");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("workflow");
            }
            return "Cannot build RestScheduleAttemptCollection, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestScheduleAttemptCollection {
        @Nullable
        Id id;
        @Nullable
        IdAndName project;
        @Nullable
        IdAndName workflow;
        List<RestSessionAttempt> attempts = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="project")
        public void setProject(IdAndName project) {
            this.project = project;
        }

        @JsonProperty(value="workflow")
        public void setWorkflow(IdAndName workflow) {
            this.workflow = workflow;
        }

        @JsonProperty(value="attempts")
        public void setAttempts(List<RestSessionAttempt> attempts) {
            this.attempts = attempts;
        }

        @Override
        public Id getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IdAndName getProject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IdAndName getWorkflow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<RestSessionAttempt> getAttempts() {
            throw new UnsupportedOperationException();
        }
    }
}

