/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import io.digdag.client.api.RestScheduleBackfillRequest;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestScheduleBackfillRequest
implements RestScheduleBackfillRequest {
    private final Instant fromTime;
    private final boolean dryRun;
    private final String attemptName;
    private final Optional<Integer> count;

    private ImmutableRestScheduleBackfillRequest(Instant fromTime, boolean dryRun, String attemptName, Optional<Integer> count) {
        this.fromTime = fromTime;
        this.dryRun = dryRun;
        this.attemptName = attemptName;
        this.count = count;
    }

    @Override
    @JsonProperty(value="fromTime")
    public Instant getFromTime() {
        return this.fromTime;
    }

    @Override
    @JsonProperty(value="dryRun")
    public boolean getDryRun() {
        return this.dryRun;
    }

    @Override
    @JsonProperty(value="attemptName")
    public String getAttemptName() {
        return this.attemptName;
    }

    @Override
    @JsonProperty(value="count")
    public Optional<Integer> getCount() {
        return this.count;
    }

    public final ImmutableRestScheduleBackfillRequest withFromTime(Instant value) {
        if (this.fromTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"fromTime");
        return new ImmutableRestScheduleBackfillRequest(newValue, this.dryRun, this.attemptName, this.count);
    }

    public final ImmutableRestScheduleBackfillRequest withDryRun(boolean value) {
        if (this.dryRun == value) {
            return this;
        }
        return new ImmutableRestScheduleBackfillRequest(this.fromTime, value, this.attemptName, this.count);
    }

    public final ImmutableRestScheduleBackfillRequest withAttemptName(String value) {
        if (this.attemptName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"attemptName");
        return new ImmutableRestScheduleBackfillRequest(this.fromTime, this.dryRun, newValue, this.count);
    }

    public final ImmutableRestScheduleBackfillRequest withCount(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.count.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRestScheduleBackfillRequest(this.fromTime, this.dryRun, this.attemptName, (Optional<Integer>)newValue);
    }

    public final ImmutableRestScheduleBackfillRequest withCount(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"count");
        if (this.count.equals((Object)value)) {
            return this;
        }
        return new ImmutableRestScheduleBackfillRequest(this.fromTime, this.dryRun, this.attemptName, (Optional<Integer>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestScheduleBackfillRequest && this.equalTo((ImmutableRestScheduleBackfillRequest)another);
    }

    private boolean equalTo(ImmutableRestScheduleBackfillRequest another) {
        return this.fromTime.equals(another.fromTime) && this.dryRun == another.dryRun && this.attemptName.equals(another.attemptName) && this.count.equals(another.count);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.fromTime.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.dryRun);
        h = h * 17 + this.attemptName.hashCode();
        h = h * 17 + this.count.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestScheduleBackfillRequest").omitNullValues().add("fromTime", (Object)this.fromTime).add("dryRun", this.dryRun).add("attemptName", (Object)this.attemptName).add("count", this.count.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestScheduleBackfillRequest fromJson(Json json) {
        Builder builder = ImmutableRestScheduleBackfillRequest.builder();
        if (json.fromTime != null) {
            builder.fromTime(json.fromTime);
        }
        if (json.dryRunIsSet) {
            builder.dryRun(json.dryRun);
        }
        if (json.attemptName != null) {
            builder.attemptName(json.attemptName);
        }
        if (json.count != null) {
            builder.count(json.count);
        }
        return builder.build();
    }

    public static ImmutableRestScheduleBackfillRequest copyOf(RestScheduleBackfillRequest instance) {
        if (instance instanceof ImmutableRestScheduleBackfillRequest) {
            return (ImmutableRestScheduleBackfillRequest)instance;
        }
        return ImmutableRestScheduleBackfillRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FROM_TIME = 1L;
        private static final long INIT_BIT_DRY_RUN = 2L;
        private static final long INIT_BIT_ATTEMPT_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private Instant fromTime;
        private boolean dryRun;
        @Nullable
        private String attemptName;
        private Optional<Integer> count = Optional.absent();

        private Builder() {
        }

        public final Builder from(RestScheduleBackfillRequest instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.fromTime(instance.getFromTime());
            this.dryRun(instance.getDryRun());
            this.attemptName(instance.getAttemptName());
            Optional<Integer> countOptional = instance.getCount();
            if (countOptional.isPresent()) {
                this.count(countOptional);
            }
            return this;
        }

        @JsonProperty(value="fromTime")
        public final Builder fromTime(Instant fromTime) {
            this.fromTime = (Instant)Preconditions.checkNotNull((Object)fromTime, (Object)"fromTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="dryRun")
        public final Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="attemptName")
        public final Builder attemptName(String attemptName) {
            this.attemptName = (String)Preconditions.checkNotNull((Object)attemptName, (Object)"attemptName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder count(int count) {
            this.count = Optional.of((Object)count);
            return this;
        }

        @JsonProperty(value="count")
        public final Builder count(Optional<Integer> count) {
            this.count = (Optional)Preconditions.checkNotNull(count, (Object)"count");
            return this;
        }

        public ImmutableRestScheduleBackfillRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestScheduleBackfillRequest(this.fromTime, this.dryRun, this.attemptName, this.count);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fromTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dryRun");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("attemptName");
            }
            return "Cannot build RestScheduleBackfillRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestScheduleBackfillRequest {
        @Nullable
        Instant fromTime;
        boolean dryRun;
        boolean dryRunIsSet;
        @Nullable
        String attemptName;
        Optional<Integer> count = Optional.absent();

        Json() {
        }

        @JsonProperty(value="fromTime")
        public void setFromTime(Instant fromTime) {
            this.fromTime = fromTime;
        }

        @JsonProperty(value="dryRun")
        public void setDryRun(boolean dryRun) {
            this.dryRun = dryRun;
            this.dryRunIsSet = true;
        }

        @JsonProperty(value="attemptName")
        public void setAttemptName(String attemptName) {
            this.attemptName = attemptName;
        }

        @JsonProperty(value="count")
        public void setCount(Optional<Integer> count) {
            this.count = count;
        }

        @Override
        public Instant getFromTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDryRun() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAttemptName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getCount() {
            throw new UnsupportedOperationException();
        }
    }
}

