/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.digdag.client.api.RestSchedule;
import io.digdag.client.api.RestScheduleCollection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestScheduleCollection
implements RestScheduleCollection {
    private final ImmutableList<RestSchedule> schedules;

    private ImmutableRestScheduleCollection(ImmutableList<RestSchedule> schedules) {
        this.schedules = schedules;
    }

    @JsonProperty(value="schedules")
    public ImmutableList<RestSchedule> getSchedules() {
        return this.schedules;
    }

    public final ImmutableRestScheduleCollection withSchedules(RestSchedule ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestScheduleCollection((ImmutableList<RestSchedule>)newValue);
    }

    public final ImmutableRestScheduleCollection withSchedules(Iterable<? extends RestSchedule> elements) {
        if (this.schedules == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestScheduleCollection((ImmutableList<RestSchedule>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestScheduleCollection && this.equalTo((ImmutableRestScheduleCollection)another);
    }

    private boolean equalTo(ImmutableRestScheduleCollection another) {
        return this.schedules.equals(another.schedules);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.schedules.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestScheduleCollection").omitNullValues().add("schedules", this.schedules).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestScheduleCollection fromJson(Json json) {
        Builder builder = ImmutableRestScheduleCollection.builder();
        if (json.schedules != null) {
            builder.addAllSchedules(json.schedules);
        }
        return builder.build();
    }

    public static ImmutableRestScheduleCollection copyOf(RestScheduleCollection instance) {
        if (instance instanceof ImmutableRestScheduleCollection) {
            return (ImmutableRestScheduleCollection)instance;
        }
        return ImmutableRestScheduleCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<RestSchedule> schedules = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(RestScheduleCollection instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllSchedules(instance.getSchedules());
            return this;
        }

        public final Builder addSchedules(RestSchedule element) {
            this.schedules.add((Object)element);
            return this;
        }

        public final Builder addSchedules(RestSchedule ... elements) {
            this.schedules.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="schedules")
        public final Builder schedules(Iterable<? extends RestSchedule> elements) {
            this.schedules = ImmutableList.builder();
            return this.addAllSchedules(elements);
        }

        public final Builder addAllSchedules(Iterable<? extends RestSchedule> elements) {
            this.schedules.addAll(elements);
            return this;
        }

        public ImmutableRestScheduleCollection build() {
            return new ImmutableRestScheduleCollection(this.schedules.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestScheduleCollection {
        List<RestSchedule> schedules = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="schedules")
        public void setSchedules(List<RestSchedule> schedules) {
            this.schedules = schedules;
        }

        @Override
        public List<RestSchedule> getSchedules() {
            throw new UnsupportedOperationException();
        }
    }
}

