/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.digdag.client.api.RestScheduleEnableRequest;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestScheduleEnableRequest
implements RestScheduleEnableRequest {
    private final Optional<Boolean> skipSchedule;
    private final Optional<String> nextTime;

    private ImmutableRestScheduleEnableRequest(Optional<Boolean> skipSchedule, Optional<String> nextTime) {
        this.skipSchedule = skipSchedule;
        this.nextTime = nextTime;
    }

    @Override
    @JsonProperty(value="skipSchedule")
    public Optional<Boolean> getSkipSchedule() {
        return this.skipSchedule;
    }

    @Override
    @JsonProperty(value="nextTime")
    public Optional<String> getNextTime() {
        return this.nextTime;
    }

    public final ImmutableRestScheduleEnableRequest withSkipSchedule(boolean value) {
        Optional newValue = Optional.of((Object)value);
        if (this.skipSchedule.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRestScheduleEnableRequest((Optional<Boolean>)newValue, this.nextTime);
    }

    public final ImmutableRestScheduleEnableRequest withSkipSchedule(Optional<Boolean> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"skipSchedule");
        if (this.skipSchedule.equals((Object)value)) {
            return this;
        }
        return new ImmutableRestScheduleEnableRequest((Optional<Boolean>)value, this.nextTime);
    }

    public final ImmutableRestScheduleEnableRequest withNextTime(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.nextTime.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRestScheduleEnableRequest(this.skipSchedule, (Optional<String>)newValue);
    }

    public final ImmutableRestScheduleEnableRequest withNextTime(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"nextTime");
        if (this.nextTime.equals((Object)value)) {
            return this;
        }
        return new ImmutableRestScheduleEnableRequest(this.skipSchedule, (Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestScheduleEnableRequest && this.equalTo((ImmutableRestScheduleEnableRequest)another);
    }

    private boolean equalTo(ImmutableRestScheduleEnableRequest another) {
        return this.skipSchedule.equals(another.skipSchedule) && this.nextTime.equals(another.nextTime);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.skipSchedule.hashCode();
        h = h * 17 + this.nextTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestScheduleEnableRequest").omitNullValues().add("skipSchedule", this.skipSchedule.orNull()).add("nextTime", this.nextTime.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestScheduleEnableRequest fromJson(Json json) {
        Builder builder = ImmutableRestScheduleEnableRequest.builder();
        if (json.skipSchedule != null) {
            builder.skipSchedule(json.skipSchedule);
        }
        if (json.nextTime != null) {
            builder.nextTime(json.nextTime);
        }
        return builder.build();
    }

    public static ImmutableRestScheduleEnableRequest copyOf(RestScheduleEnableRequest instance) {
        if (instance instanceof ImmutableRestScheduleEnableRequest) {
            return (ImmutableRestScheduleEnableRequest)instance;
        }
        return ImmutableRestScheduleEnableRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<Boolean> skipSchedule = Optional.absent();
        private Optional<String> nextTime = Optional.absent();

        private Builder() {
        }

        public final Builder from(RestScheduleEnableRequest instance) {
            Optional<String> nextTimeOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Boolean> skipScheduleOptional = instance.getSkipSchedule();
            if (skipScheduleOptional.isPresent()) {
                this.skipSchedule(skipScheduleOptional);
            }
            if ((nextTimeOptional = instance.getNextTime()).isPresent()) {
                this.nextTime(nextTimeOptional);
            }
            return this;
        }

        public final Builder skipSchedule(boolean skipSchedule) {
            this.skipSchedule = Optional.of((Object)skipSchedule);
            return this;
        }

        @JsonProperty(value="skipSchedule")
        public final Builder skipSchedule(Optional<Boolean> skipSchedule) {
            this.skipSchedule = (Optional)Preconditions.checkNotNull(skipSchedule, (Object)"skipSchedule");
            return this;
        }

        public final Builder nextTime(String nextTime) {
            this.nextTime = Optional.of((Object)nextTime);
            return this;
        }

        @JsonProperty(value="nextTime")
        public final Builder nextTime(Optional<String> nextTime) {
            this.nextTime = (Optional)Preconditions.checkNotNull(nextTime, (Object)"nextTime");
            return this;
        }

        public ImmutableRestScheduleEnableRequest build() {
            return new ImmutableRestScheduleEnableRequest(this.skipSchedule, this.nextTime);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestScheduleEnableRequest {
        Optional<Boolean> skipSchedule = Optional.absent();
        Optional<String> nextTime = Optional.absent();

        Json() {
        }

        @JsonProperty(value="skipSchedule")
        public void setSkipSchedule(Optional<Boolean> skipSchedule) {
            this.skipSchedule = skipSchedule;
        }

        @JsonProperty(value="nextTime")
        public void setNextTime(Optional<String> nextTime) {
            this.nextTime = nextTime;
        }

        @Override
        public Optional<Boolean> getSkipSchedule() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNextTime() {
            throw new UnsupportedOperationException();
        }
    }
}

