/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import io.digdag.client.api.LocalTimeOrInstant;
import io.digdag.client.api.RestScheduleSkipRequest;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestScheduleSkipRequest
implements RestScheduleSkipRequest {
    private final Optional<Integer> count;
    private final Optional<Instant> fromTime;
    private final Optional<LocalTimeOrInstant> nextTime;
    private final Optional<Instant> nextRunTime;
    private final boolean dryRun;

    private ImmutableRestScheduleSkipRequest(Optional<Integer> count, Optional<Instant> fromTime, Optional<LocalTimeOrInstant> nextTime, Optional<Instant> nextRunTime, boolean dryRun) {
        this.count = count;
        this.fromTime = fromTime;
        this.nextTime = nextTime;
        this.nextRunTime = nextRunTime;
        this.dryRun = dryRun;
    }

    @Override
    @JsonProperty(value="count")
    public Optional<Integer> getCount() {
        return this.count;
    }

    @Override
    @JsonProperty(value="fromTime")
    public Optional<Instant> getFromTime() {
        return this.fromTime;
    }

    @Override
    @JsonProperty(value="nextTime")
    public Optional<LocalTimeOrInstant> getNextTime() {
        return this.nextTime;
    }

    @Override
    @JsonProperty(value="nextRunTime")
    public Optional<Instant> getNextRunTime() {
        return this.nextRunTime;
    }

    @Override
    @JsonProperty(value="dryRun")
    public boolean getDryRun() {
        return this.dryRun;
    }

    public final ImmutableRestScheduleSkipRequest withCount(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.count.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRestScheduleSkipRequest((Optional<Integer>)newValue, this.fromTime, this.nextTime, this.nextRunTime, this.dryRun);
    }

    public final ImmutableRestScheduleSkipRequest withCount(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"count");
        if (this.count.equals((Object)value)) {
            return this;
        }
        return new ImmutableRestScheduleSkipRequest((Optional<Integer>)value, this.fromTime, this.nextTime, this.nextRunTime, this.dryRun);
    }

    public final ImmutableRestScheduleSkipRequest withFromTime(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.fromTime.isPresent() && this.fromTime.get() == value) {
            return this;
        }
        return new ImmutableRestScheduleSkipRequest(this.count, (Optional<Instant>)newValue, this.nextTime, this.nextRunTime, this.dryRun);
    }

    public final ImmutableRestScheduleSkipRequest withFromTime(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"fromTime");
        if (!this.fromTime.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.fromTime.isPresent() && value.isPresent() && this.fromTime.get() == value.get()) {
            return this;
        }
        return new ImmutableRestScheduleSkipRequest(this.count, (Optional<Instant>)value, this.nextTime, this.nextRunTime, this.dryRun);
    }

    public final ImmutableRestScheduleSkipRequest withNextTime(LocalTimeOrInstant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.nextTime.isPresent() && this.nextTime.get() == value) {
            return this;
        }
        return new ImmutableRestScheduleSkipRequest(this.count, this.fromTime, (Optional<LocalTimeOrInstant>)newValue, this.nextRunTime, this.dryRun);
    }

    public final ImmutableRestScheduleSkipRequest withNextTime(Optional<LocalTimeOrInstant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"nextTime");
        if (!this.nextTime.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.nextTime.isPresent() && value.isPresent() && this.nextTime.get() == value.get()) {
            return this;
        }
        return new ImmutableRestScheduleSkipRequest(this.count, this.fromTime, (Optional<LocalTimeOrInstant>)value, this.nextRunTime, this.dryRun);
    }

    public final ImmutableRestScheduleSkipRequest withNextRunTime(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.nextRunTime.isPresent() && this.nextRunTime.get() == value) {
            return this;
        }
        return new ImmutableRestScheduleSkipRequest(this.count, this.fromTime, this.nextTime, (Optional<Instant>)newValue, this.dryRun);
    }

    public final ImmutableRestScheduleSkipRequest withNextRunTime(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"nextRunTime");
        if (!this.nextRunTime.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.nextRunTime.isPresent() && value.isPresent() && this.nextRunTime.get() == value.get()) {
            return this;
        }
        return new ImmutableRestScheduleSkipRequest(this.count, this.fromTime, this.nextTime, (Optional<Instant>)value, this.dryRun);
    }

    public final ImmutableRestScheduleSkipRequest withDryRun(boolean value) {
        if (this.dryRun == value) {
            return this;
        }
        return new ImmutableRestScheduleSkipRequest(this.count, this.fromTime, this.nextTime, this.nextRunTime, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestScheduleSkipRequest && this.equalTo((ImmutableRestScheduleSkipRequest)another);
    }

    private boolean equalTo(ImmutableRestScheduleSkipRequest another) {
        return this.count.equals(another.count) && this.fromTime.equals(another.fromTime) && this.nextTime.equals(another.nextTime) && this.nextRunTime.equals(another.nextRunTime) && this.dryRun == another.dryRun;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.count.hashCode();
        h = h * 17 + this.fromTime.hashCode();
        h = h * 17 + this.nextTime.hashCode();
        h = h * 17 + this.nextRunTime.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.dryRun);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestScheduleSkipRequest").omitNullValues().add("count", this.count.orNull()).add("fromTime", this.fromTime.orNull()).add("nextTime", this.nextTime.orNull()).add("nextRunTime", this.nextRunTime.orNull()).add("dryRun", this.dryRun).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestScheduleSkipRequest fromJson(Json json) {
        Builder builder = ImmutableRestScheduleSkipRequest.builder();
        if (json.count != null) {
            builder.count(json.count);
        }
        if (json.fromTime != null) {
            builder.fromTime(json.fromTime);
        }
        if (json.nextTime != null) {
            builder.nextTime(json.nextTime);
        }
        if (json.nextRunTime != null) {
            builder.nextRunTime(json.nextRunTime);
        }
        if (json.dryRunIsSet) {
            builder.dryRun(json.dryRun);
        }
        return builder.build();
    }

    public static ImmutableRestScheduleSkipRequest copyOf(RestScheduleSkipRequest instance) {
        if (instance instanceof ImmutableRestScheduleSkipRequest) {
            return (ImmutableRestScheduleSkipRequest)instance;
        }
        return ImmutableRestScheduleSkipRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DRY_RUN = 1L;
        private long initBits = 1L;
        private Optional<Integer> count = Optional.absent();
        private Optional<Instant> fromTime = Optional.absent();
        private Optional<LocalTimeOrInstant> nextTime = Optional.absent();
        private Optional<Instant> nextRunTime = Optional.absent();
        private boolean dryRun;

        private Builder() {
        }

        public final Builder from(RestScheduleSkipRequest instance) {
            Optional<Instant> nextRunTimeOptional;
            Optional<LocalTimeOrInstant> nextTimeOptional;
            Optional<Instant> fromTimeOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Integer> countOptional = instance.getCount();
            if (countOptional.isPresent()) {
                this.count(countOptional);
            }
            if ((fromTimeOptional = instance.getFromTime()).isPresent()) {
                this.fromTime(fromTimeOptional);
            }
            if ((nextTimeOptional = instance.getNextTime()).isPresent()) {
                this.nextTime(nextTimeOptional);
            }
            if ((nextRunTimeOptional = instance.getNextRunTime()).isPresent()) {
                this.nextRunTime(nextRunTimeOptional);
            }
            this.dryRun(instance.getDryRun());
            return this;
        }

        public final Builder count(int count) {
            this.count = Optional.of((Object)count);
            return this;
        }

        @JsonProperty(value="count")
        public final Builder count(Optional<Integer> count) {
            this.count = (Optional)Preconditions.checkNotNull(count, (Object)"count");
            return this;
        }

        public final Builder fromTime(Instant fromTime) {
            this.fromTime = Optional.of((Object)fromTime);
            return this;
        }

        @JsonProperty(value="fromTime")
        public final Builder fromTime(Optional<Instant> fromTime) {
            this.fromTime = (Optional)Preconditions.checkNotNull(fromTime, (Object)"fromTime");
            return this;
        }

        public final Builder nextTime(LocalTimeOrInstant nextTime) {
            this.nextTime = Optional.of((Object)nextTime);
            return this;
        }

        @JsonProperty(value="nextTime")
        public final Builder nextTime(Optional<LocalTimeOrInstant> nextTime) {
            this.nextTime = (Optional)Preconditions.checkNotNull(nextTime, (Object)"nextTime");
            return this;
        }

        public final Builder nextRunTime(Instant nextRunTime) {
            this.nextRunTime = Optional.of((Object)nextRunTime);
            return this;
        }

        @JsonProperty(value="nextRunTime")
        public final Builder nextRunTime(Optional<Instant> nextRunTime) {
            this.nextRunTime = (Optional)Preconditions.checkNotNull(nextRunTime, (Object)"nextRunTime");
            return this;
        }

        @JsonProperty(value="dryRun")
        public final Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRestScheduleSkipRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestScheduleSkipRequest(this.count, this.fromTime, this.nextTime, this.nextRunTime, this.dryRun);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dryRun");
            }
            return "Cannot build RestScheduleSkipRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestScheduleSkipRequest {
        Optional<Integer> count = Optional.absent();
        Optional<Instant> fromTime = Optional.absent();
        Optional<LocalTimeOrInstant> nextTime = Optional.absent();
        Optional<Instant> nextRunTime = Optional.absent();
        boolean dryRun;
        boolean dryRunIsSet;

        Json() {
        }

        @JsonProperty(value="count")
        public void setCount(Optional<Integer> count) {
            this.count = count;
        }

        @JsonProperty(value="fromTime")
        public void setFromTime(Optional<Instant> fromTime) {
            this.fromTime = fromTime;
        }

        @JsonProperty(value="nextTime")
        public void setNextTime(Optional<LocalTimeOrInstant> nextTime) {
            this.nextTime = nextTime;
        }

        @JsonProperty(value="nextRunTime")
        public void setNextRunTime(Optional<Instant> nextRunTime) {
            this.nextRunTime = nextRunTime;
        }

        @JsonProperty(value="dryRun")
        public void setDryRun(boolean dryRun) {
            this.dryRun = dryRun;
            this.dryRunIsSet = true;
        }

        @Override
        public Optional<Integer> getCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getFromTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LocalTimeOrInstant> getNextTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getNextRunTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDryRun() {
            throw new UnsupportedOperationException();
        }
    }
}

