/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.IdAndName;
import io.digdag.client.api.RestSecret;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestSecret
implements RestSecret {
    private final String key;
    private final IdAndName project;

    private ImmutableRestSecret(String key, IdAndName project) {
        this.key = key;
        this.project = project;
    }

    @Override
    @JsonProperty(value="key")
    public String key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="project")
    public IdAndName project() {
        return this.project;
    }

    public final ImmutableRestSecret withKey(String value) {
        if (this.key.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"key");
        return new ImmutableRestSecret(newValue, this.project);
    }

    public final ImmutableRestSecret withProject(IdAndName value) {
        if (this.project == value) {
            return this;
        }
        IdAndName newValue = (IdAndName)Preconditions.checkNotNull((Object)value, (Object)"project");
        return new ImmutableRestSecret(this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestSecret && this.equalTo((ImmutableRestSecret)another);
    }

    private boolean equalTo(ImmutableRestSecret another) {
        return this.key.equals(another.key) && this.project.equals(another.project);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.key.hashCode();
        h = h * 17 + this.project.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestSecret").omitNullValues().add("key", (Object)this.key).add("project", (Object)this.project).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestSecret fromJson(Json json) {
        Builder builder = ImmutableRestSecret.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.project != null) {
            builder.project(json.project);
        }
        return builder.build();
    }

    public static ImmutableRestSecret copyOf(RestSecret instance) {
        if (instance instanceof ImmutableRestSecret) {
            return (ImmutableRestSecret)instance;
        }
        return ImmutableRestSecret.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder
    implements RestSecret.Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_PROJECT = 2L;
        private long initBits = 3L;
        @Nullable
        private String key;
        @Nullable
        private IdAndName project;

        private Builder() {
        }

        public final Builder from(RestSecret instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.key(instance.key());
            this.project(instance.project());
            return this;
        }

        @Override
        @JsonProperty(value="key")
        public final Builder key(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="project")
        public final Builder project(IdAndName project) {
            this.project = (IdAndName)Preconditions.checkNotNull((Object)project, (Object)"project");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableRestSecret build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestSecret(this.key, this.project);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("project");
            }
            return "Cannot build RestSecret, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestSecret {
        @Nullable
        String key;
        @Nullable
        IdAndName project;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="project")
        public void setProject(IdAndName project) {
            this.project = project;
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IdAndName project() {
            throw new UnsupportedOperationException();
        }
    }
}

