/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.digdag.client.api.RestSecretList;
import io.digdag.client.api.RestSecretMetadata;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableRestSecretList
implements RestSecretList {
    private final ImmutableList<RestSecretMetadata> secrets;

    private ImmutableRestSecretList(ImmutableList<RestSecretMetadata> secrets) {
        this.secrets = secrets;
    }

    @JsonProperty(value="secrets")
    public ImmutableList<RestSecretMetadata> secrets() {
        return this.secrets;
    }

    public final ImmutableRestSecretList withSecrets(RestSecretMetadata ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestSecretList((ImmutableList<RestSecretMetadata>)newValue);
    }

    public final ImmutableRestSecretList withSecrets(Iterable<? extends RestSecretMetadata> elements) {
        if (this.secrets == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestSecretList((ImmutableList<RestSecretMetadata>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestSecretList && this.equalTo((ImmutableRestSecretList)another);
    }

    private boolean equalTo(ImmutableRestSecretList another) {
        return this.secrets.equals(another.secrets);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.secrets.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestSecretList").omitNullValues().add("secrets", this.secrets).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestSecretList fromJson(Json json) {
        Builder builder = ImmutableRestSecretList.builder();
        if (json.secrets != null) {
            builder.addAllSecrets(json.secrets);
        }
        return builder.build();
    }

    public static ImmutableRestSecretList copyOf(RestSecretList instance) {
        if (instance instanceof ImmutableRestSecretList) {
            return (ImmutableRestSecretList)instance;
        }
        return ImmutableRestSecretList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder
    implements RestSecretList.Builder {
        private ImmutableList.Builder<RestSecretMetadata> secrets = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(RestSecretList instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllSecrets(instance.secrets());
            return this;
        }

        public final Builder addSecrets(RestSecretMetadata element) {
            this.secrets.add((Object)element);
            return this;
        }

        public final Builder addSecrets(RestSecretMetadata ... elements) {
            this.secrets.add((Object[])elements);
            return this;
        }

        @Override
        @JsonProperty(value="secrets")
        public final Builder secrets(Iterable<? extends RestSecretMetadata> elements) {
            this.secrets = ImmutableList.builder();
            return this.addAllSecrets(elements);
        }

        public final Builder addAllSecrets(Iterable<? extends RestSecretMetadata> elements) {
            this.secrets.addAll(elements);
            return this;
        }

        @Override
        public ImmutableRestSecretList build() {
            return new ImmutableRestSecretList(this.secrets.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestSecretList {
        List<RestSecretMetadata> secrets = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="secrets")
        public void setSecrets(List<RestSecretMetadata> secrets) {
            this.secrets = secrets;
        }

        @Override
        public List<RestSecretMetadata> secrets() {
            throw new UnsupportedOperationException();
        }
    }
}

