/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.RestSecretMetadata;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableRestSecretMetadata
implements RestSecretMetadata {
    private final String key;

    private ImmutableRestSecretMetadata(String key) {
        this.key = key;
    }

    @Override
    @JsonProperty(value="key")
    public String key() {
        return this.key;
    }

    public final ImmutableRestSecretMetadata withKey(String value) {
        if (this.key.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"key");
        return new ImmutableRestSecretMetadata(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestSecretMetadata && this.equalTo((ImmutableRestSecretMetadata)another);
    }

    private boolean equalTo(ImmutableRestSecretMetadata another) {
        return this.key.equals(another.key);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.key.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestSecretMetadata").omitNullValues().add("key", (Object)this.key).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestSecretMetadata fromJson(Json json) {
        Builder builder = ImmutableRestSecretMetadata.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        return builder.build();
    }

    public static ImmutableRestSecretMetadata copyOf(RestSecretMetadata instance) {
        if (instance instanceof ImmutableRestSecretMetadata) {
            return (ImmutableRestSecretMetadata)instance;
        }
        return ImmutableRestSecretMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder
    implements RestSecretMetadata.Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private String key;

        private Builder() {
        }

        public final Builder from(RestSecretMetadata instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.key(instance.key());
            return this;
        }

        @Override
        @JsonProperty(value="key")
        public final Builder key(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public ImmutableRestSecretMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestSecretMetadata(this.key);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build RestSecretMetadata, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestSecretMetadata {
        @Nullable
        String key;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }
    }
}

