/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import io.digdag.client.api.Id;
import io.digdag.client.api.IdAndName;
import io.digdag.client.api.NameOptionalId;
import io.digdag.client.api.RestSessionAttempt;
import io.digdag.client.config.Config;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestSessionAttempt
implements RestSessionAttempt {
    private final Id id;
    private final int index;
    private final IdAndName project;
    private final NameOptionalId workflow;
    private final Id sessionId;
    private final UUID sessionUuid;
    private final OffsetDateTime sessionTime;
    private final Optional<String> retryAttemptName;
    private final boolean done;
    private final boolean success;
    private final boolean cancelRequested;
    private final Config params;
    private final Instant createdAt;
    private final Optional<Instant> finishedAt;

    private ImmutableRestSessionAttempt(Builder builder) {
        this.id = builder.id;
        this.project = builder.project;
        this.workflow = builder.workflow;
        this.sessionId = builder.sessionId;
        this.sessionUuid = builder.sessionUuid;
        this.sessionTime = builder.sessionTime;
        this.retryAttemptName = builder.retryAttemptName;
        this.done = builder.done;
        this.success = builder.success;
        this.cancelRequested = builder.cancelRequested;
        this.params = builder.params;
        this.createdAt = builder.createdAt;
        this.finishedAt = builder.finishedAt;
        this.index = builder.indexIsSet() ? builder.index : RestSessionAttempt.super.getIndex();
    }

    private ImmutableRestSessionAttempt(Id id, int index, IdAndName project, NameOptionalId workflow, Id sessionId, UUID sessionUuid, OffsetDateTime sessionTime, Optional<String> retryAttemptName, boolean done, boolean success, boolean cancelRequested, Config params, Instant createdAt, Optional<Instant> finishedAt) {
        this.id = id;
        this.index = index;
        this.project = project;
        this.workflow = workflow;
        this.sessionId = sessionId;
        this.sessionUuid = sessionUuid;
        this.sessionTime = sessionTime;
        this.retryAttemptName = retryAttemptName;
        this.done = done;
        this.success = success;
        this.cancelRequested = cancelRequested;
        this.params = params;
        this.createdAt = createdAt;
        this.finishedAt = finishedAt;
    }

    @Override
    @JsonProperty(value="id")
    public Id getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="index")
    public int getIndex() {
        return this.index;
    }

    @Override
    @JsonProperty(value="project")
    public IdAndName getProject() {
        return this.project;
    }

    @Override
    @JsonProperty(value="workflow")
    public NameOptionalId getWorkflow() {
        return this.workflow;
    }

    @Override
    @JsonProperty(value="sessionId")
    public Id getSessionId() {
        return this.sessionId;
    }

    @Override
    @JsonProperty(value="sessionUuid")
    public UUID getSessionUuid() {
        return this.sessionUuid;
    }

    @Override
    @JsonProperty(value="sessionTime")
    public OffsetDateTime getSessionTime() {
        return this.sessionTime;
    }

    @Override
    @JsonProperty(value="retryAttemptName")
    public Optional<String> getRetryAttemptName() {
        return this.retryAttemptName;
    }

    @Override
    @JsonProperty(value="done")
    public boolean getDone() {
        return this.done;
    }

    @Override
    @JsonProperty(value="success")
    public boolean getSuccess() {
        return this.success;
    }

    @Override
    @JsonProperty(value="cancelRequested")
    public boolean getCancelRequested() {
        return this.cancelRequested;
    }

    @Override
    @JsonProperty(value="params")
    public Config getParams() {
        return this.params;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="finishedAt")
    public Optional<Instant> getFinishedAt() {
        return this.finishedAt;
    }

    public final ImmutableRestSessionAttempt withId(Id value) {
        if (this.id == value) {
            return this;
        }
        Id newValue = (Id)Preconditions.checkNotNull((Object)value, (Object)"id");
        return new ImmutableRestSessionAttempt(newValue, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, this.success, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableRestSessionAttempt(this.id, value, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, this.success, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withProject(IdAndName value) {
        if (this.project == value) {
            return this;
        }
        IdAndName newValue = (IdAndName)Preconditions.checkNotNull((Object)value, (Object)"project");
        return new ImmutableRestSessionAttempt(this.id, this.index, newValue, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, this.success, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withWorkflow(NameOptionalId value) {
        if (this.workflow == value) {
            return this;
        }
        NameOptionalId newValue = (NameOptionalId)Preconditions.checkNotNull((Object)value, (Object)"workflow");
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, newValue, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, this.success, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withSessionId(Id value) {
        if (this.sessionId == value) {
            return this;
        }
        Id newValue = (Id)Preconditions.checkNotNull((Object)value, (Object)"sessionId");
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, newValue, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, this.success, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withSessionUuid(UUID value) {
        if (this.sessionUuid == value) {
            return this;
        }
        UUID newValue = (UUID)Preconditions.checkNotNull((Object)value, (Object)"sessionUuid");
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, newValue, this.sessionTime, this.retryAttemptName, this.done, this.success, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withSessionTime(OffsetDateTime value) {
        if (this.sessionTime == value) {
            return this;
        }
        OffsetDateTime newValue = (OffsetDateTime)Preconditions.checkNotNull((Object)value, (Object)"sessionTime");
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, newValue, this.retryAttemptName, this.done, this.success, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withRetryAttemptName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.retryAttemptName.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, (Optional<String>)newValue, this.done, this.success, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withRetryAttemptName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"retryAttemptName");
        if (this.retryAttemptName.equals((Object)value)) {
            return this;
        }
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, (Optional<String>)value, this.done, this.success, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withDone(boolean value) {
        if (this.done == value) {
            return this;
        }
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, value, this.success, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withSuccess(boolean value) {
        if (this.success == value) {
            return this;
        }
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, value, this.cancelRequested, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withCancelRequested(boolean value) {
        if (this.cancelRequested == value) {
            return this;
        }
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, this.success, value, this.params, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withParams(Config value) {
        if (this.params == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"params");
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, this.success, this.cancelRequested, newValue, this.createdAt, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, this.success, this.cancelRequested, this.params, newValue, this.finishedAt);
    }

    public final ImmutableRestSessionAttempt withFinishedAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.finishedAt.isPresent() && this.finishedAt.get() == value) {
            return this;
        }
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, this.success, this.cancelRequested, this.params, this.createdAt, (Optional<Instant>)newValue);
    }

    public final ImmutableRestSessionAttempt withFinishedAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"finishedAt");
        if (!this.finishedAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.finishedAt.isPresent() && value.isPresent() && this.finishedAt.get() == value.get()) {
            return this;
        }
        return new ImmutableRestSessionAttempt(this.id, this.index, this.project, this.workflow, this.sessionId, this.sessionUuid, this.sessionTime, this.retryAttemptName, this.done, this.success, this.cancelRequested, this.params, this.createdAt, (Optional<Instant>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestSessionAttempt && this.equalTo((ImmutableRestSessionAttempt)another);
    }

    private boolean equalTo(ImmutableRestSessionAttempt another) {
        return this.id.equals(another.id) && this.index == another.index && this.project.equals(another.project) && this.workflow.equals(another.workflow) && this.sessionId.equals(another.sessionId) && this.sessionUuid.equals(another.sessionUuid) && this.sessionTime.equals(another.sessionTime) && this.retryAttemptName.equals(another.retryAttemptName) && this.done == another.done && this.success == another.success && this.cancelRequested == another.cancelRequested && this.params.equals(another.params) && this.createdAt.equals(another.createdAt) && this.finishedAt.equals(another.finishedAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.index;
        h = h * 17 + this.project.hashCode();
        h = h * 17 + this.workflow.hashCode();
        h = h * 17 + this.sessionId.hashCode();
        h = h * 17 + this.sessionUuid.hashCode();
        h = h * 17 + this.sessionTime.hashCode();
        h = h * 17 + this.retryAttemptName.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.done);
        h = h * 17 + Booleans.hashCode((boolean)this.success);
        h = h * 17 + Booleans.hashCode((boolean)this.cancelRequested);
        h = h * 17 + this.params.hashCode();
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.finishedAt.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestSessionAttempt").omitNullValues().add("id", (Object)this.id).add("index", this.index).add("project", (Object)this.project).add("workflow", (Object)this.workflow).add("sessionId", (Object)this.sessionId).add("sessionUuid", (Object)this.sessionUuid).add("sessionTime", (Object)this.sessionTime).add("retryAttemptName", this.retryAttemptName.orNull()).add("done", this.done).add("success", this.success).add("cancelRequested", this.cancelRequested).add("params", (Object)this.params).add("createdAt", (Object)this.createdAt).add("finishedAt", this.finishedAt.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestSessionAttempt fromJson(Json json) {
        Builder builder = ImmutableRestSessionAttempt.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.indexIsSet) {
            builder.index(json.index);
        }
        if (json.project != null) {
            builder.project(json.project);
        }
        if (json.workflow != null) {
            builder.workflow(json.workflow);
        }
        if (json.sessionId != null) {
            builder.sessionId(json.sessionId);
        }
        if (json.sessionUuid != null) {
            builder.sessionUuid(json.sessionUuid);
        }
        if (json.sessionTime != null) {
            builder.sessionTime(json.sessionTime);
        }
        if (json.retryAttemptName != null) {
            builder.retryAttemptName(json.retryAttemptName);
        }
        if (json.doneIsSet) {
            builder.done(json.done);
        }
        if (json.successIsSet) {
            builder.success(json.success);
        }
        if (json.cancelRequestedIsSet) {
            builder.cancelRequested(json.cancelRequested);
        }
        if (json.params != null) {
            builder.params(json.params);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.finishedAt != null) {
            builder.finishedAt(json.finishedAt);
        }
        return builder.build();
    }

    public static ImmutableRestSessionAttempt copyOf(RestSessionAttempt instance) {
        if (instance instanceof ImmutableRestSessionAttempt) {
            return (ImmutableRestSessionAttempt)instance;
        }
        return ImmutableRestSessionAttempt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PROJECT = 2L;
        private static final long INIT_BIT_WORKFLOW = 4L;
        private static final long INIT_BIT_SESSION_ID = 8L;
        private static final long INIT_BIT_SESSION_UUID = 16L;
        private static final long INIT_BIT_SESSION_TIME = 32L;
        private static final long INIT_BIT_DONE = 64L;
        private static final long INIT_BIT_SUCCESS = 128L;
        private static final long INIT_BIT_CANCEL_REQUESTED = 256L;
        private static final long INIT_BIT_PARAMS = 512L;
        private static final long INIT_BIT_CREATED_AT = 1024L;
        private static final long OPT_BIT_INDEX = 1L;
        private long initBits = 2047L;
        private long optBits;
        @Nullable
        private Id id;
        private int index;
        @Nullable
        private IdAndName project;
        @Nullable
        private NameOptionalId workflow;
        @Nullable
        private Id sessionId;
        @Nullable
        private UUID sessionUuid;
        @Nullable
        private OffsetDateTime sessionTime;
        private Optional<String> retryAttemptName = Optional.absent();
        private boolean done;
        private boolean success;
        private boolean cancelRequested;
        @Nullable
        private Config params;
        @Nullable
        private Instant createdAt;
        private Optional<Instant> finishedAt = Optional.absent();

        private Builder() {
        }

        public final Builder from(RestSessionAttempt instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.index(instance.getIndex());
            this.project(instance.getProject());
            this.workflow(instance.getWorkflow());
            this.sessionId(instance.getSessionId());
            this.sessionUuid(instance.getSessionUuid());
            this.sessionTime(instance.getSessionTime());
            Optional<String> retryAttemptNameOptional = instance.getRetryAttemptName();
            if (retryAttemptNameOptional.isPresent()) {
                this.retryAttemptName(retryAttemptNameOptional);
            }
            this.done(instance.getDone());
            this.success(instance.getSuccess());
            this.cancelRequested(instance.getCancelRequested());
            this.params(instance.getParams());
            this.createdAt(instance.getCreatedAt());
            Optional<Instant> finishedAtOptional = instance.getFinishedAt();
            if (finishedAtOptional.isPresent()) {
                this.finishedAt(finishedAtOptional);
            }
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(Id id) {
            this.id = (Id)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="index")
        public final Builder index(int index) {
            this.index = index;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="project")
        public final Builder project(IdAndName project) {
            this.project = (IdAndName)Preconditions.checkNotNull((Object)project, (Object)"project");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="workflow")
        public final Builder workflow(NameOptionalId workflow) {
            this.workflow = (NameOptionalId)Preconditions.checkNotNull((Object)workflow, (Object)"workflow");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="sessionId")
        public final Builder sessionId(Id sessionId) {
            this.sessionId = (Id)Preconditions.checkNotNull((Object)sessionId, (Object)"sessionId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="sessionUuid")
        public final Builder sessionUuid(UUID sessionUuid) {
            this.sessionUuid = (UUID)Preconditions.checkNotNull((Object)sessionUuid, (Object)"sessionUuid");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="sessionTime")
        public final Builder sessionTime(OffsetDateTime sessionTime) {
            this.sessionTime = (OffsetDateTime)Preconditions.checkNotNull((Object)sessionTime, (Object)"sessionTime");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder retryAttemptName(String retryAttemptName) {
            this.retryAttemptName = Optional.of((Object)retryAttemptName);
            return this;
        }

        @JsonProperty(value="retryAttemptName")
        public final Builder retryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = (Optional)Preconditions.checkNotNull(retryAttemptName, (Object)"retryAttemptName");
            return this;
        }

        @JsonProperty(value="done")
        public final Builder done(boolean done) {
            this.done = done;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="success")
        public final Builder success(boolean success) {
            this.success = success;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="cancelRequested")
        public final Builder cancelRequested(boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="params")
        public final Builder params(Config params) {
            this.params = (Config)Preconditions.checkNotNull((Object)params, (Object)"params");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="createdAt")
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = Optional.of((Object)finishedAt);
            return this;
        }

        @JsonProperty(value="finishedAt")
        public final Builder finishedAt(Optional<Instant> finishedAt) {
            this.finishedAt = (Optional)Preconditions.checkNotNull(finishedAt, (Object)"finishedAt");
            return this;
        }

        public ImmutableRestSessionAttempt build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestSessionAttempt(this);
        }

        private boolean indexIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("project");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("workflow");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sessionId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("sessionUuid");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("sessionTime");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("done");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("success");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("cancelRequested");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("params");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("createdAt");
            }
            return "Cannot build RestSessionAttempt, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestSessionAttempt {
        @Nullable
        Id id;
        int index;
        boolean indexIsSet;
        @Nullable
        IdAndName project;
        @Nullable
        NameOptionalId workflow;
        @Nullable
        Id sessionId;
        @Nullable
        UUID sessionUuid;
        @Nullable
        OffsetDateTime sessionTime;
        Optional<String> retryAttemptName = Optional.absent();
        boolean done;
        boolean doneIsSet;
        boolean success;
        boolean successIsSet;
        boolean cancelRequested;
        boolean cancelRequestedIsSet;
        @Nullable
        Config params;
        @Nullable
        Instant createdAt;
        Optional<Instant> finishedAt = Optional.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="index")
        public void setIndex(int index) {
            this.index = index;
            this.indexIsSet = true;
        }

        @JsonProperty(value="project")
        public void setProject(IdAndName project) {
            this.project = project;
        }

        @JsonProperty(value="workflow")
        public void setWorkflow(NameOptionalId workflow) {
            this.workflow = workflow;
        }

        @JsonProperty(value="sessionId")
        public void setSessionId(Id sessionId) {
            this.sessionId = sessionId;
        }

        @JsonProperty(value="sessionUuid")
        public void setSessionUuid(UUID sessionUuid) {
            this.sessionUuid = sessionUuid;
        }

        @JsonProperty(value="sessionTime")
        public void setSessionTime(OffsetDateTime sessionTime) {
            this.sessionTime = sessionTime;
        }

        @JsonProperty(value="retryAttemptName")
        public void setRetryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = retryAttemptName;
        }

        @JsonProperty(value="done")
        public void setDone(boolean done) {
            this.done = done;
            this.doneIsSet = true;
        }

        @JsonProperty(value="success")
        public void setSuccess(boolean success) {
            this.success = success;
            this.successIsSet = true;
        }

        @JsonProperty(value="cancelRequested")
        public void setCancelRequested(boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
            this.cancelRequestedIsSet = true;
        }

        @JsonProperty(value="params")
        public void setParams(Config params) {
            this.params = params;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="finishedAt")
        public void setFinishedAt(Optional<Instant> finishedAt) {
            this.finishedAt = finishedAt;
        }

        @Override
        public Id getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IdAndName getProject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NameOptionalId getWorkflow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id getSessionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UUID getSessionUuid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime getSessionTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRetryAttemptName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getSuccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCancelRequested() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getFinishedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

