/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.digdag.client.api.RestSessionAttempt;
import io.digdag.client.api.RestSessionAttemptCollection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestSessionAttemptCollection
implements RestSessionAttemptCollection {
    private final ImmutableList<RestSessionAttempt> attempts;

    private ImmutableRestSessionAttemptCollection(ImmutableList<RestSessionAttempt> attempts) {
        this.attempts = attempts;
    }

    @JsonProperty(value="attempts")
    public ImmutableList<RestSessionAttempt> getAttempts() {
        return this.attempts;
    }

    public final ImmutableRestSessionAttemptCollection withAttempts(RestSessionAttempt ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestSessionAttemptCollection((ImmutableList<RestSessionAttempt>)newValue);
    }

    public final ImmutableRestSessionAttemptCollection withAttempts(Iterable<? extends RestSessionAttempt> elements) {
        if (this.attempts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestSessionAttemptCollection((ImmutableList<RestSessionAttempt>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestSessionAttemptCollection && this.equalTo((ImmutableRestSessionAttemptCollection)another);
    }

    private boolean equalTo(ImmutableRestSessionAttemptCollection another) {
        return this.attempts.equals(another.attempts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.attempts.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestSessionAttemptCollection").omitNullValues().add("attempts", this.attempts).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestSessionAttemptCollection fromJson(Json json) {
        Builder builder = ImmutableRestSessionAttemptCollection.builder();
        if (json.attempts != null) {
            builder.addAllAttempts(json.attempts);
        }
        return builder.build();
    }

    public static ImmutableRestSessionAttemptCollection copyOf(RestSessionAttemptCollection instance) {
        if (instance instanceof ImmutableRestSessionAttemptCollection) {
            return (ImmutableRestSessionAttemptCollection)instance;
        }
        return ImmutableRestSessionAttemptCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<RestSessionAttempt> attempts = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(RestSessionAttemptCollection instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllAttempts(instance.getAttempts());
            return this;
        }

        public final Builder addAttempts(RestSessionAttempt element) {
            this.attempts.add((Object)element);
            return this;
        }

        public final Builder addAttempts(RestSessionAttempt ... elements) {
            this.attempts.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="attempts")
        public final Builder attempts(Iterable<? extends RestSessionAttempt> elements) {
            this.attempts = ImmutableList.builder();
            return this.addAllAttempts(elements);
        }

        public final Builder addAllAttempts(Iterable<? extends RestSessionAttempt> elements) {
            this.attempts.addAll(elements);
            return this;
        }

        public ImmutableRestSessionAttemptCollection build() {
            return new ImmutableRestSessionAttemptCollection(this.attempts.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestSessionAttemptCollection {
        List<RestSessionAttempt> attempts = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="attempts")
        public void setAttempts(List<RestSessionAttempt> attempts) {
            this.attempts = attempts;
        }

        @Override
        public List<RestSessionAttempt> getAttempts() {
            throw new UnsupportedOperationException();
        }
    }
}

