/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.Id;
import io.digdag.client.api.RestSessionAttemptRequest;
import io.digdag.client.config.Config;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestSessionAttemptRequest
implements RestSessionAttemptRequest {
    private final Id workflowId;
    private final Instant sessionTime;
    private final Optional<String> retryAttemptName;
    private final Optional<RestSessionAttemptRequest.Resume> resume;
    private final Config params;

    private ImmutableRestSessionAttemptRequest(Id workflowId, Instant sessionTime, Optional<String> retryAttemptName, Optional<RestSessionAttemptRequest.Resume> resume, Config params) {
        this.workflowId = workflowId;
        this.sessionTime = sessionTime;
        this.retryAttemptName = retryAttemptName;
        this.resume = resume;
        this.params = params;
    }

    @Override
    @JsonProperty(value="workflowId")
    public Id getWorkflowId() {
        return this.workflowId;
    }

    @Override
    @JsonProperty(value="sessionTime")
    public Instant getSessionTime() {
        return this.sessionTime;
    }

    @Override
    @JsonProperty(value="retryAttemptName")
    public Optional<String> getRetryAttemptName() {
        return this.retryAttemptName;
    }

    @Override
    @JsonProperty(value="resume")
    public Optional<RestSessionAttemptRequest.Resume> getResume() {
        return this.resume;
    }

    @Override
    @JsonProperty(value="params")
    public Config getParams() {
        return this.params;
    }

    public final ImmutableRestSessionAttemptRequest withWorkflowId(Id value) {
        if (this.workflowId == value) {
            return this;
        }
        Id newValue = (Id)Preconditions.checkNotNull((Object)value, (Object)"workflowId");
        return new ImmutableRestSessionAttemptRequest(newValue, this.sessionTime, this.retryAttemptName, this.resume, this.params);
    }

    public final ImmutableRestSessionAttemptRequest withSessionTime(Instant value) {
        if (this.sessionTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"sessionTime");
        return new ImmutableRestSessionAttemptRequest(this.workflowId, newValue, this.retryAttemptName, this.resume, this.params);
    }

    public final ImmutableRestSessionAttemptRequest withRetryAttemptName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.retryAttemptName.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRestSessionAttemptRequest(this.workflowId, this.sessionTime, (Optional<String>)newValue, this.resume, this.params);
    }

    public final ImmutableRestSessionAttemptRequest withRetryAttemptName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"retryAttemptName");
        if (this.retryAttemptName.equals((Object)value)) {
            return this;
        }
        return new ImmutableRestSessionAttemptRequest(this.workflowId, this.sessionTime, (Optional<String>)value, this.resume, this.params);
    }

    public final ImmutableRestSessionAttemptRequest withResume(RestSessionAttemptRequest.Resume value) {
        Optional newValue = Optional.of((Object)value);
        if (this.resume.isPresent() && this.resume.get() == value) {
            return this;
        }
        return new ImmutableRestSessionAttemptRequest(this.workflowId, this.sessionTime, this.retryAttemptName, (Optional<RestSessionAttemptRequest.Resume>)newValue, this.params);
    }

    public final ImmutableRestSessionAttemptRequest withResume(Optional<RestSessionAttemptRequest.Resume> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"resume");
        if (!this.resume.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.resume.isPresent() && value.isPresent() && this.resume.get() == value.get()) {
            return this;
        }
        return new ImmutableRestSessionAttemptRequest(this.workflowId, this.sessionTime, this.retryAttemptName, (Optional<RestSessionAttemptRequest.Resume>)value, this.params);
    }

    public final ImmutableRestSessionAttemptRequest withParams(Config value) {
        if (this.params == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"params");
        return new ImmutableRestSessionAttemptRequest(this.workflowId, this.sessionTime, this.retryAttemptName, this.resume, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestSessionAttemptRequest && this.equalTo((ImmutableRestSessionAttemptRequest)another);
    }

    private boolean equalTo(ImmutableRestSessionAttemptRequest another) {
        return this.workflowId.equals(another.workflowId) && this.sessionTime.equals(another.sessionTime) && this.retryAttemptName.equals(another.retryAttemptName) && this.resume.equals(another.resume) && this.params.equals(another.params);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.workflowId.hashCode();
        h = h * 17 + this.sessionTime.hashCode();
        h = h * 17 + this.retryAttemptName.hashCode();
        h = h * 17 + this.resume.hashCode();
        h = h * 17 + this.params.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestSessionAttemptRequest").omitNullValues().add("workflowId", (Object)this.workflowId).add("sessionTime", (Object)this.sessionTime).add("retryAttemptName", this.retryAttemptName.orNull()).add("resume", this.resume.orNull()).add("params", (Object)this.params).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestSessionAttemptRequest fromJson(Json json) {
        Builder builder = ImmutableRestSessionAttemptRequest.builder();
        if (json.workflowId != null) {
            builder.workflowId(json.workflowId);
        }
        if (json.sessionTime != null) {
            builder.sessionTime(json.sessionTime);
        }
        if (json.retryAttemptName != null) {
            builder.retryAttemptName(json.retryAttemptName);
        }
        if (json.resume != null) {
            builder.resume(json.resume);
        }
        if (json.params != null) {
            builder.params(json.params);
        }
        return builder.build();
    }

    public static ImmutableRestSessionAttemptRequest copyOf(RestSessionAttemptRequest instance) {
        if (instance instanceof ImmutableRestSessionAttemptRequest) {
            return (ImmutableRestSessionAttemptRequest)instance;
        }
        return ImmutableRestSessionAttemptRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Immutable
    public static final class ResumeFrom
    implements RestSessionAttemptRequest.ResumeFrom {
        private final String fromTaskNamePattern;
        private final Id attemptId;

        private ResumeFrom(String fromTaskNamePattern, Id attemptId) {
            this.fromTaskNamePattern = fromTaskNamePattern;
            this.attemptId = attemptId;
        }

        @Override
        @JsonProperty(value="from")
        public String getFromTaskNamePattern() {
            return this.fromTaskNamePattern;
        }

        @Override
        @JsonProperty(value="attemptId")
        public Id getAttemptId() {
            return this.attemptId;
        }

        public final ResumeFrom withFromTaskNamePattern(String value) {
            if (this.fromTaskNamePattern.equals(value)) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"fromTaskNamePattern");
            return new ResumeFrom(newValue, this.attemptId);
        }

        public final ResumeFrom withAttemptId(Id value) {
            if (this.attemptId == value) {
                return this;
            }
            Id newValue = (Id)Preconditions.checkNotNull((Object)value, (Object)"attemptId");
            return new ResumeFrom(this.fromTaskNamePattern, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ResumeFrom && this.equalTo((ResumeFrom)another);
        }

        private boolean equalTo(ResumeFrom another) {
            return this.fromTaskNamePattern.equals(another.fromTaskNamePattern) && this.attemptId.equals(another.attemptId);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.fromTaskNamePattern.hashCode();
            h = h * 17 + this.attemptId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ResumeFrom").omitNullValues().add("fromTaskNamePattern", (Object)this.fromTaskNamePattern).add("attemptId", (Object)this.attemptId).toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ResumeFrom fromJson(Json json) {
            Builder builder = ResumeFrom.builder();
            if (json.fromTaskNamePattern != null) {
                builder.fromTaskNamePattern(json.fromTaskNamePattern);
            }
            if (json.attemptId != null) {
                builder.attemptId(json.attemptId);
            }
            return builder.build();
        }

        public static ResumeFrom copyOf(RestSessionAttemptRequest.ResumeFrom instance) {
            if (instance instanceof ResumeFrom) {
                return (ResumeFrom)instance;
            }
            return ResumeFrom.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_FROM_TASK_NAME_PATTERN = 1L;
            private static final long INIT_BIT_ATTEMPT_ID = 2L;
            private long initBits = 3L;
            @Nullable
            private String fromTaskNamePattern;
            @Nullable
            private Id attemptId;

            private Builder() {
            }

            public final Builder from(RestSessionAttemptRequest.Resume instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(RestSessionAttemptRequest.ResumeFrom instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RestSessionAttemptRequest.Resume instance;
                if (object instanceof RestSessionAttemptRequest.Resume) {
                    instance = (RestSessionAttemptRequest.Resume)object;
                    this.attemptId(instance.getAttemptId());
                }
                if (object instanceof RestSessionAttemptRequest.ResumeFrom) {
                    instance = (RestSessionAttemptRequest.ResumeFrom)object;
                    this.fromTaskNamePattern(instance.getFromTaskNamePattern());
                }
            }

            @JsonProperty(value="from")
            public final Builder fromTaskNamePattern(String fromTaskNamePattern) {
                this.fromTaskNamePattern = (String)Preconditions.checkNotNull((Object)fromTaskNamePattern, (Object)"fromTaskNamePattern");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="attemptId")
            public final Builder attemptId(Id attemptId) {
                this.attemptId = (Id)Preconditions.checkNotNull((Object)attemptId, (Object)"attemptId");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public ResumeFrom build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ResumeFrom(this.fromTaskNamePattern, this.attemptId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("fromTaskNamePattern");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("attemptId");
                }
                return "Cannot build ResumeFrom, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        static final class Json
        implements RestSessionAttemptRequest.ResumeFrom {
            @Nullable
            String fromTaskNamePattern;
            @Nullable
            Id attemptId;

            Json() {
            }

            @JsonProperty(value="from")
            public void setFromTaskNamePattern(String fromTaskNamePattern) {
                this.fromTaskNamePattern = fromTaskNamePattern;
            }

            @JsonProperty(value="attemptId")
            public void setAttemptId(Id attemptId) {
                this.attemptId = attemptId;
            }

            @Override
            public String getFromTaskNamePattern() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Id getAttemptId() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Immutable
    public static final class ResumeFailed
    implements RestSessionAttemptRequest.ResumeFailed {
        private final Id attemptId;

        private ResumeFailed(Id attemptId) {
            this.attemptId = attemptId;
        }

        @Override
        @JsonProperty(value="attemptId")
        public Id getAttemptId() {
            return this.attemptId;
        }

        public final ResumeFailed withAttemptId(Id value) {
            if (this.attemptId == value) {
                return this;
            }
            Id newValue = (Id)Preconditions.checkNotNull((Object)value, (Object)"attemptId");
            return new ResumeFailed(newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ResumeFailed && this.equalTo((ResumeFailed)another);
        }

        private boolean equalTo(ResumeFailed another) {
            return this.attemptId.equals(another.attemptId);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.attemptId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ResumeFailed").omitNullValues().add("attemptId", (Object)this.attemptId).toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ResumeFailed fromJson(Json json) {
            Builder builder = ResumeFailed.builder();
            if (json.attemptId != null) {
                builder.attemptId(json.attemptId);
            }
            return builder.build();
        }

        public static ResumeFailed copyOf(RestSessionAttemptRequest.ResumeFailed instance) {
            if (instance instanceof ResumeFailed) {
                return (ResumeFailed)instance;
            }
            return ResumeFailed.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_ATTEMPT_ID = 1L;
            private long initBits = 1L;
            @Nullable
            private Id attemptId;

            private Builder() {
            }

            public final Builder from(RestSessionAttemptRequest.Resume instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(RestSessionAttemptRequest.ResumeFailed instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof RestSessionAttemptRequest.Resume) {
                    RestSessionAttemptRequest.Resume instance = (RestSessionAttemptRequest.Resume)object;
                    this.attemptId(instance.getAttemptId());
                }
            }

            @JsonProperty(value="attemptId")
            public final Builder attemptId(Id attemptId) {
                this.attemptId = (Id)Preconditions.checkNotNull((Object)attemptId, (Object)"attemptId");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ResumeFailed build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ResumeFailed(this.attemptId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("attemptId");
                }
                return "Cannot build ResumeFailed, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        static final class Json
        implements RestSessionAttemptRequest.ResumeFailed {
            @Nullable
            Id attemptId;

            Json() {
            }

            @JsonProperty(value="attemptId")
            public void setAttemptId(Id attemptId) {
                this.attemptId = attemptId;
            }

            @Override
            public Id getAttemptId() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WORKFLOW_ID = 1L;
        private static final long INIT_BIT_SESSION_TIME = 2L;
        private static final long INIT_BIT_PARAMS = 4L;
        private long initBits = 7L;
        @Nullable
        private Id workflowId;
        @Nullable
        private Instant sessionTime;
        private Optional<String> retryAttemptName = Optional.absent();
        private Optional<RestSessionAttemptRequest.Resume> resume = Optional.absent();
        @Nullable
        private Config params;

        private Builder() {
        }

        public final Builder from(RestSessionAttemptRequest instance) {
            Optional<RestSessionAttemptRequest.Resume> resumeOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.workflowId(instance.getWorkflowId());
            this.sessionTime(instance.getSessionTime());
            Optional<String> retryAttemptNameOptional = instance.getRetryAttemptName();
            if (retryAttemptNameOptional.isPresent()) {
                this.retryAttemptName(retryAttemptNameOptional);
            }
            if ((resumeOptional = instance.getResume()).isPresent()) {
                this.resume(resumeOptional);
            }
            this.params(instance.getParams());
            return this;
        }

        @JsonProperty(value="workflowId")
        public final Builder workflowId(Id workflowId) {
            this.workflowId = (Id)Preconditions.checkNotNull((Object)workflowId, (Object)"workflowId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="sessionTime")
        public final Builder sessionTime(Instant sessionTime) {
            this.sessionTime = (Instant)Preconditions.checkNotNull((Object)sessionTime, (Object)"sessionTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder retryAttemptName(String retryAttemptName) {
            this.retryAttemptName = Optional.of((Object)retryAttemptName);
            return this;
        }

        @JsonProperty(value="retryAttemptName")
        public final Builder retryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = (Optional)Preconditions.checkNotNull(retryAttemptName, (Object)"retryAttemptName");
            return this;
        }

        public final Builder resume(RestSessionAttemptRequest.Resume resume) {
            this.resume = Optional.of((Object)resume);
            return this;
        }

        @JsonProperty(value="resume")
        public final Builder resume(Optional<RestSessionAttemptRequest.Resume> resume) {
            this.resume = (Optional)Preconditions.checkNotNull(resume, (Object)"resume");
            return this;
        }

        @JsonProperty(value="params")
        public final Builder params(Config params) {
            this.params = (Config)Preconditions.checkNotNull((Object)params, (Object)"params");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRestSessionAttemptRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestSessionAttemptRequest(this.workflowId, this.sessionTime, this.retryAttemptName, this.resume, this.params);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("workflowId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sessionTime");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("params");
            }
            return "Cannot build RestSessionAttemptRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestSessionAttemptRequest {
        @Nullable
        Id workflowId;
        @Nullable
        Instant sessionTime;
        Optional<String> retryAttemptName = Optional.absent();
        Optional<RestSessionAttemptRequest.Resume> resume = Optional.absent();
        @Nullable
        Config params;

        Json() {
        }

        @JsonProperty(value="workflowId")
        public void setWorkflowId(Id workflowId) {
            this.workflowId = workflowId;
        }

        @JsonProperty(value="sessionTime")
        public void setSessionTime(Instant sessionTime) {
            this.sessionTime = sessionTime;
        }

        @JsonProperty(value="retryAttemptName")
        public void setRetryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = retryAttemptName;
        }

        @JsonProperty(value="resume")
        public void setResume(Optional<RestSessionAttemptRequest.Resume> resume) {
            this.resume = resume;
        }

        @JsonProperty(value="params")
        public void setParams(Config params) {
            this.params = params;
        }

        @Override
        public Id getWorkflowId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getSessionTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRetryAttemptName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<RestSessionAttemptRequest.Resume> getResume() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getParams() {
            throw new UnsupportedOperationException();
        }
    }
}

