/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.digdag.client.api.RestSession;
import io.digdag.client.api.RestSessionCollection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestSessionCollection
implements RestSessionCollection {
    private final ImmutableList<RestSession> sessions;

    private ImmutableRestSessionCollection(ImmutableList<RestSession> sessions) {
        this.sessions = sessions;
    }

    @JsonProperty(value="sessions")
    public ImmutableList<RestSession> getSessions() {
        return this.sessions;
    }

    public final ImmutableRestSessionCollection withSessions(RestSession ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestSessionCollection((ImmutableList<RestSession>)newValue);
    }

    public final ImmutableRestSessionCollection withSessions(Iterable<? extends RestSession> elements) {
        if (this.sessions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestSessionCollection((ImmutableList<RestSession>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestSessionCollection && this.equalTo((ImmutableRestSessionCollection)another);
    }

    private boolean equalTo(ImmutableRestSessionCollection another) {
        return this.sessions.equals(another.sessions);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.sessions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestSessionCollection").omitNullValues().add("sessions", this.sessions).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestSessionCollection fromJson(Json json) {
        Builder builder = ImmutableRestSessionCollection.builder();
        if (json.sessions != null) {
            builder.addAllSessions(json.sessions);
        }
        return builder.build();
    }

    public static ImmutableRestSessionCollection copyOf(RestSessionCollection instance) {
        if (instance instanceof ImmutableRestSessionCollection) {
            return (ImmutableRestSessionCollection)instance;
        }
        return ImmutableRestSessionCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<RestSession> sessions = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(RestSessionCollection instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllSessions(instance.getSessions());
            return this;
        }

        public final Builder addSessions(RestSession element) {
            this.sessions.add((Object)element);
            return this;
        }

        public final Builder addSessions(RestSession ... elements) {
            this.sessions.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="sessions")
        public final Builder sessions(Iterable<? extends RestSession> elements) {
            this.sessions = ImmutableList.builder();
            return this.addAllSessions(elements);
        }

        public final Builder addAllSessions(Iterable<? extends RestSession> elements) {
            this.sessions.addAll(elements);
            return this;
        }

        public ImmutableRestSessionCollection build() {
            return new ImmutableRestSessionCollection(this.sessions.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestSessionCollection {
        List<RestSession> sessions = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="sessions")
        public void setSessions(List<RestSession> sessions) {
            this.sessions = sessions;
        }

        @Override
        public List<RestSession> getSessions() {
            throw new UnsupportedOperationException();
        }
    }
}

