/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.RestSetSecretRequest;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableRestSetSecretRequest
implements RestSetSecretRequest {
    private final String value;

    private ImmutableRestSetSecretRequest(String value) {
        this.value = value;
    }

    @Override
    @JsonProperty(value="value")
    public String value() {
        return this.value;
    }

    public final ImmutableRestSetSecretRequest withValue(String value) {
        if (this.value.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        return new ImmutableRestSetSecretRequest(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestSetSecretRequest && this.equalTo((ImmutableRestSetSecretRequest)another);
    }

    private boolean equalTo(ImmutableRestSetSecretRequest another) {
        return this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestSetSecretRequest").omitNullValues().add("value", (Object)this.value).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestSetSecretRequest fromJson(Json json) {
        Builder builder = ImmutableRestSetSecretRequest.builder();
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static ImmutableRestSetSecretRequest copyOf(RestSetSecretRequest instance) {
        if (instance instanceof ImmutableRestSetSecretRequest) {
            return (ImmutableRestSetSecretRequest)instance;
        }
        return ImmutableRestSetSecretRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(RestSetSecretRequest instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.value(instance.value());
            return this;
        }

        @JsonProperty(value="value")
        public final Builder value(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRestSetSecretRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestSetSecretRequest(this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build RestSetSecretRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestSetSecretRequest {
        @Nullable
        String value;

        Json() {
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            throw new UnsupportedOperationException();
        }
    }
}

