/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import io.digdag.client.api.Id;
import io.digdag.client.api.RestTask;
import io.digdag.client.config.Config;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestTask
implements RestTask {
    private final Id id;
    private final String fullName;
    private final Optional<Id> parentId;
    private final Config config;
    private final ImmutableList<Id> upstreams;
    private final boolean isGroup;
    private final String state;
    private final boolean cancelRequested;
    private final Config exportParams;
    private final Config storeParams;
    private final Config stateParams;
    private final Instant updatedAt;
    private final Optional<Instant> retryAt;
    private final Optional<Instant> startedAt;
    private final Config error;

    private ImmutableRestTask(Builder builder) {
        this.id = builder.id;
        this.fullName = builder.fullName;
        this.parentId = builder.parentId;
        this.config = builder.config;
        this.upstreams = builder.upstreams.build();
        this.isGroup = builder.isGroup;
        this.state = builder.state;
        this.exportParams = builder.exportParams;
        this.storeParams = builder.storeParams;
        this.stateParams = builder.stateParams;
        this.updatedAt = builder.updatedAt;
        this.retryAt = builder.retryAt;
        this.startedAt = builder.startedAt;
        this.error = builder.error;
        this.cancelRequested = builder.cancelRequestedIsSet() ? builder.cancelRequested : RestTask.super.getCancelRequested();
    }

    private ImmutableRestTask(Id id, String fullName, Optional<Id> parentId, Config config, ImmutableList<Id> upstreams, boolean isGroup, String state, boolean cancelRequested, Config exportParams, Config storeParams, Config stateParams, Instant updatedAt, Optional<Instant> retryAt, Optional<Instant> startedAt, Config error) {
        this.id = id;
        this.fullName = fullName;
        this.parentId = parentId;
        this.config = config;
        this.upstreams = upstreams;
        this.isGroup = isGroup;
        this.state = state;
        this.cancelRequested = cancelRequested;
        this.exportParams = exportParams;
        this.storeParams = storeParams;
        this.stateParams = stateParams;
        this.updatedAt = updatedAt;
        this.retryAt = retryAt;
        this.startedAt = startedAt;
        this.error = error;
    }

    @Override
    @JsonProperty(value="id")
    public Id getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="fullName")
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @JsonProperty(value="parentId")
    public Optional<Id> getParentId() {
        return this.parentId;
    }

    @Override
    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    @JsonProperty(value="upstreams")
    public ImmutableList<Id> getUpstreams() {
        return this.upstreams;
    }

    @Override
    @JsonProperty(value="isGroup")
    public boolean isGroup() {
        return this.isGroup;
    }

    @Override
    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="cancelRequested")
    public boolean getCancelRequested() {
        return this.cancelRequested;
    }

    @Override
    @JsonProperty(value="exportParams")
    public Config getExportParams() {
        return this.exportParams;
    }

    @Override
    @JsonProperty(value="storeParams")
    public Config getStoreParams() {
        return this.storeParams;
    }

    @Override
    @JsonProperty(value="stateParams")
    public Config getStateParams() {
        return this.stateParams;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="retryAt")
    public Optional<Instant> getRetryAt() {
        return this.retryAt;
    }

    @Override
    @JsonProperty(value="startedAt")
    public Optional<Instant> getStartedAt() {
        return this.startedAt;
    }

    @Override
    @JsonProperty(value="error")
    public Config getError() {
        return this.error;
    }

    public final ImmutableRestTask withId(Id value) {
        if (this.id == value) {
            return this;
        }
        Id newValue = (Id)Preconditions.checkNotNull((Object)value, (Object)"id");
        return new ImmutableRestTask(newValue, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withFullName(String value) {
        if (this.fullName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"fullName");
        return new ImmutableRestTask(this.id, newValue, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withParentId(Id value) {
        Optional newValue = Optional.of((Object)value);
        if (this.parentId.isPresent() && this.parentId.get() == value) {
            return this;
        }
        return new ImmutableRestTask(this.id, this.fullName, (Optional<Id>)newValue, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withParentId(Optional<Id> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"parentId");
        if (!this.parentId.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.parentId.isPresent() && value.isPresent() && this.parentId.get() == value.get()) {
            return this;
        }
        return new ImmutableRestTask(this.id, this.fullName, (Optional<Id>)value, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"config");
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, newValue, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withUpstreams(Id ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, (ImmutableList<Id>)newValue, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withUpstreams(Iterable<? extends Id> elements) {
        if (this.upstreams == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, (ImmutableList<Id>)newValue, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withIsGroup(boolean value) {
        if (this.isGroup == value) {
            return this;
        }
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, value, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withState(String value) {
        if (this.state.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"state");
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, newValue, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withCancelRequested(boolean value) {
        if (this.cancelRequested == value) {
            return this;
        }
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, value, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withExportParams(Config value) {
        if (this.exportParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"exportParams");
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, newValue, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withStoreParams(Config value) {
        if (this.storeParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"storeParams");
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, newValue, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withStateParams(Config value) {
        if (this.stateParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"stateParams");
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, newValue, this.updatedAt, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withUpdatedAt(Instant value) {
        if (this.updatedAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"updatedAt");
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, newValue, this.retryAt, this.startedAt, this.error);
    }

    public final ImmutableRestTask withRetryAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.retryAt.isPresent() && this.retryAt.get() == value) {
            return this;
        }
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, (Optional<Instant>)newValue, this.startedAt, this.error);
    }

    public final ImmutableRestTask withRetryAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"retryAt");
        if (!this.retryAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.retryAt.isPresent() && value.isPresent() && this.retryAt.get() == value.get()) {
            return this;
        }
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, (Optional<Instant>)value, this.startedAt, this.error);
    }

    public final ImmutableRestTask withStartedAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.startedAt.isPresent() && this.startedAt.get() == value) {
            return this;
        }
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, (Optional<Instant>)newValue, this.error);
    }

    public final ImmutableRestTask withStartedAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"startedAt");
        if (!this.startedAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.startedAt.isPresent() && value.isPresent() && this.startedAt.get() == value.get()) {
            return this;
        }
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, (Optional<Instant>)value, this.error);
    }

    public final ImmutableRestTask withError(Config value) {
        if (this.error == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"error");
        return new ImmutableRestTask(this.id, this.fullName, this.parentId, this.config, this.upstreams, this.isGroup, this.state, this.cancelRequested, this.exportParams, this.storeParams, this.stateParams, this.updatedAt, this.retryAt, this.startedAt, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestTask && this.equalTo((ImmutableRestTask)another);
    }

    private boolean equalTo(ImmutableRestTask another) {
        return this.id.equals(another.id) && this.fullName.equals(another.fullName) && this.parentId.equals(another.parentId) && this.config.equals(another.config) && this.upstreams.equals(another.upstreams) && this.isGroup == another.isGroup && this.state.equals(another.state) && this.cancelRequested == another.cancelRequested && this.exportParams.equals(another.exportParams) && this.storeParams.equals(another.storeParams) && this.stateParams.equals(another.stateParams) && this.updatedAt.equals(another.updatedAt) && this.retryAt.equals(another.retryAt) && this.startedAt.equals(another.startedAt) && this.error.equals(another.error);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.fullName.hashCode();
        h = h * 17 + this.parentId.hashCode();
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.upstreams.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.isGroup);
        h = h * 17 + this.state.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.cancelRequested);
        h = h * 17 + this.exportParams.hashCode();
        h = h * 17 + this.storeParams.hashCode();
        h = h * 17 + this.stateParams.hashCode();
        h = h * 17 + this.updatedAt.hashCode();
        h = h * 17 + this.retryAt.hashCode();
        h = h * 17 + this.startedAt.hashCode();
        h = h * 17 + this.error.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestTask").omitNullValues().add("id", (Object)this.id).add("fullName", (Object)this.fullName).add("parentId", this.parentId.orNull()).add("config", (Object)this.config).add("upstreams", this.upstreams).add("isGroup", this.isGroup).add("state", (Object)this.state).add("cancelRequested", this.cancelRequested).add("exportParams", (Object)this.exportParams).add("storeParams", (Object)this.storeParams).add("stateParams", (Object)this.stateParams).add("updatedAt", (Object)this.updatedAt).add("retryAt", this.retryAt.orNull()).add("startedAt", this.startedAt.orNull()).add("error", (Object)this.error).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestTask fromJson(Json json) {
        Builder builder = ImmutableRestTask.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.fullName != null) {
            builder.fullName(json.fullName);
        }
        if (json.parentId != null) {
            builder.parentId(json.parentId);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.upstreams != null) {
            builder.addAllUpstreams(json.upstreams);
        }
        if (json.isGroupIsSet) {
            builder.isGroup(json.isGroup);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.cancelRequestedIsSet) {
            builder.cancelRequested(json.cancelRequested);
        }
        if (json.exportParams != null) {
            builder.exportParams(json.exportParams);
        }
        if (json.storeParams != null) {
            builder.storeParams(json.storeParams);
        }
        if (json.stateParams != null) {
            builder.stateParams(json.stateParams);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.retryAt != null) {
            builder.retryAt(json.retryAt);
        }
        if (json.startedAt != null) {
            builder.startedAt(json.startedAt);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        return builder.build();
    }

    public static ImmutableRestTask copyOf(RestTask instance) {
        if (instance instanceof ImmutableRestTask) {
            return (ImmutableRestTask)instance;
        }
        return ImmutableRestTask.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_FULL_NAME = 2L;
        private static final long INIT_BIT_CONFIG = 4L;
        private static final long INIT_BIT_IS_GROUP = 8L;
        private static final long INIT_BIT_STATE = 16L;
        private static final long INIT_BIT_EXPORT_PARAMS = 32L;
        private static final long INIT_BIT_STORE_PARAMS = 64L;
        private static final long INIT_BIT_STATE_PARAMS = 128L;
        private static final long INIT_BIT_UPDATED_AT = 256L;
        private static final long INIT_BIT_ERROR = 512L;
        private static final long OPT_BIT_CANCEL_REQUESTED = 1L;
        private long initBits = 1023L;
        private long optBits;
        @Nullable
        private Id id;
        @Nullable
        private String fullName;
        private Optional<Id> parentId = Optional.absent();
        @Nullable
        private Config config;
        private ImmutableList.Builder<Id> upstreams = ImmutableList.builder();
        private boolean isGroup;
        @Nullable
        private String state;
        private boolean cancelRequested;
        @Nullable
        private Config exportParams;
        @Nullable
        private Config storeParams;
        @Nullable
        private Config stateParams;
        @Nullable
        private Instant updatedAt;
        private Optional<Instant> retryAt = Optional.absent();
        private Optional<Instant> startedAt = Optional.absent();
        @Nullable
        private Config error;

        private Builder() {
        }

        public final Builder from(RestTask instance) {
            Optional<Instant> startedAtOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.fullName(instance.getFullName());
            Optional<Id> parentIdOptional = instance.getParentId();
            if (parentIdOptional.isPresent()) {
                this.parentId(parentIdOptional);
            }
            this.config(instance.getConfig());
            this.addAllUpstreams(instance.getUpstreams());
            this.isGroup(instance.isGroup());
            this.state(instance.getState());
            this.cancelRequested(instance.getCancelRequested());
            this.exportParams(instance.getExportParams());
            this.storeParams(instance.getStoreParams());
            this.stateParams(instance.getStateParams());
            this.updatedAt(instance.getUpdatedAt());
            Optional<Instant> retryAtOptional = instance.getRetryAt();
            if (retryAtOptional.isPresent()) {
                this.retryAt(retryAtOptional);
            }
            if ((startedAtOptional = instance.getStartedAt()).isPresent()) {
                this.startedAt(startedAtOptional);
            }
            this.error(instance.getError());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(Id id) {
            this.id = (Id)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="fullName")
        public final Builder fullName(String fullName) {
            this.fullName = (String)Preconditions.checkNotNull((Object)fullName, (Object)"fullName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder parentId(Id parentId) {
            this.parentId = Optional.of((Object)parentId);
            return this;
        }

        @JsonProperty(value="parentId")
        public final Builder parentId(Optional<Id> parentId) {
            this.parentId = (Optional)Preconditions.checkNotNull(parentId, (Object)"parentId");
            return this;
        }

        @JsonProperty(value="config")
        public final Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addUpstreams(Id element) {
            this.upstreams.add((Object)element);
            return this;
        }

        public final Builder addUpstreams(Id ... elements) {
            this.upstreams.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="upstreams")
        public final Builder upstreams(Iterable<? extends Id> elements) {
            this.upstreams = ImmutableList.builder();
            return this.addAllUpstreams(elements);
        }

        public final Builder addAllUpstreams(Iterable<? extends Id> elements) {
            this.upstreams.addAll(elements);
            return this;
        }

        @JsonProperty(value="isGroup")
        public final Builder isGroup(boolean isGroup) {
            this.isGroup = isGroup;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(String state) {
            this.state = (String)Preconditions.checkNotNull((Object)state, (Object)"state");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="cancelRequested")
        public final Builder cancelRequested(boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="exportParams")
        public final Builder exportParams(Config exportParams) {
            this.exportParams = (Config)Preconditions.checkNotNull((Object)exportParams, (Object)"exportParams");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="storeParams")
        public final Builder storeParams(Config storeParams) {
            this.storeParams = (Config)Preconditions.checkNotNull((Object)storeParams, (Object)"storeParams");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="stateParams")
        public final Builder stateParams(Config stateParams) {
            this.stateParams = (Config)Preconditions.checkNotNull((Object)stateParams, (Object)"stateParams");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="updatedAt")
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = (Instant)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder retryAt(Instant retryAt) {
            this.retryAt = Optional.of((Object)retryAt);
            return this;
        }

        @JsonProperty(value="retryAt")
        public final Builder retryAt(Optional<Instant> retryAt) {
            this.retryAt = (Optional)Preconditions.checkNotNull(retryAt, (Object)"retryAt");
            return this;
        }

        public final Builder startedAt(Instant startedAt) {
            this.startedAt = Optional.of((Object)startedAt);
            return this;
        }

        @JsonProperty(value="startedAt")
        public final Builder startedAt(Optional<Instant> startedAt) {
            this.startedAt = (Optional)Preconditions.checkNotNull(startedAt, (Object)"startedAt");
            return this;
        }

        @JsonProperty(value="error")
        public final Builder error(Config error) {
            this.error = (Config)Preconditions.checkNotNull((Object)error, (Object)"error");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public ImmutableRestTask build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestTask(this);
        }

        private boolean cancelRequestedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fullName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("isGroup");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("exportParams");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("storeParams");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("stateParams");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("error");
            }
            return "Cannot build RestTask, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestTask {
        @Nullable
        Id id;
        @Nullable
        String fullName;
        Optional<Id> parentId = Optional.absent();
        @Nullable
        Config config;
        List<Id> upstreams = ImmutableList.of();
        boolean isGroup;
        boolean isGroupIsSet;
        @Nullable
        String state;
        boolean cancelRequested;
        boolean cancelRequestedIsSet;
        @Nullable
        Config exportParams;
        @Nullable
        Config storeParams;
        @Nullable
        Config stateParams;
        @Nullable
        Instant updatedAt;
        Optional<Instant> retryAt = Optional.absent();
        Optional<Instant> startedAt = Optional.absent();
        @Nullable
        Config error;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="fullName")
        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        @JsonProperty(value="parentId")
        public void setParentId(Optional<Id> parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @JsonProperty(value="upstreams")
        public void setUpstreams(List<Id> upstreams) {
            this.upstreams = upstreams;
        }

        @JsonProperty(value="isGroup")
        public void setIsGroup(boolean isGroup) {
            this.isGroup = isGroup;
            this.isGroupIsSet = true;
        }

        @JsonProperty(value="state")
        public void setState(String state) {
            this.state = state;
        }

        @JsonProperty(value="cancelRequested")
        public void setCancelRequested(boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
            this.cancelRequestedIsSet = true;
        }

        @JsonProperty(value="exportParams")
        public void setExportParams(Config exportParams) {
            this.exportParams = exportParams;
        }

        @JsonProperty(value="storeParams")
        public void setStoreParams(Config storeParams) {
            this.storeParams = storeParams;
        }

        @JsonProperty(value="stateParams")
        public void setStateParams(Config stateParams) {
            this.stateParams = stateParams;
        }

        @JsonProperty(value="updatedAt")
        public void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="retryAt")
        public void setRetryAt(Optional<Instant> retryAt) {
            this.retryAt = retryAt;
        }

        @JsonProperty(value="startedAt")
        public void setStartedAt(Optional<Instant> startedAt) {
            this.startedAt = startedAt;
        }

        @JsonProperty(value="error")
        public void setError(Config error) {
            this.error = error;
        }

        @Override
        public Id getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFullName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Id> getParentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> getUpstreams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCancelRequested() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getExportParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getStoreParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getStateParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getRetryAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getStartedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getError() {
            throw new UnsupportedOperationException();
        }
    }
}

