/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.digdag.client.api.RestTask;
import io.digdag.client.api.RestTaskCollection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestTaskCollection
implements RestTaskCollection {
    private final ImmutableList<RestTask> tasks;

    private ImmutableRestTaskCollection(ImmutableList<RestTask> tasks) {
        this.tasks = tasks;
    }

    @JsonProperty(value="tasks")
    public ImmutableList<RestTask> getTasks() {
        return this.tasks;
    }

    public final ImmutableRestTaskCollection withTasks(RestTask ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestTaskCollection((ImmutableList<RestTask>)newValue);
    }

    public final ImmutableRestTaskCollection withTasks(Iterable<? extends RestTask> elements) {
        if (this.tasks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestTaskCollection((ImmutableList<RestTask>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestTaskCollection && this.equalTo((ImmutableRestTaskCollection)another);
    }

    private boolean equalTo(ImmutableRestTaskCollection another) {
        return this.tasks.equals(another.tasks);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.tasks.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestTaskCollection").omitNullValues().add("tasks", this.tasks).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestTaskCollection fromJson(Json json) {
        Builder builder = ImmutableRestTaskCollection.builder();
        if (json.tasks != null) {
            builder.addAllTasks(json.tasks);
        }
        return builder.build();
    }

    public static ImmutableRestTaskCollection copyOf(RestTaskCollection instance) {
        if (instance instanceof ImmutableRestTaskCollection) {
            return (ImmutableRestTaskCollection)instance;
        }
        return ImmutableRestTaskCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<RestTask> tasks = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(RestTaskCollection instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllTasks(instance.getTasks());
            return this;
        }

        public final Builder addTasks(RestTask element) {
            this.tasks.add((Object)element);
            return this;
        }

        public final Builder addTasks(RestTask ... elements) {
            this.tasks.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="tasks")
        public final Builder tasks(Iterable<? extends RestTask> elements) {
            this.tasks = ImmutableList.builder();
            return this.addAllTasks(elements);
        }

        public final Builder addAllTasks(Iterable<? extends RestTask> elements) {
            this.tasks.addAll(elements);
            return this;
        }

        public ImmutableRestTaskCollection build() {
            return new ImmutableRestTaskCollection(this.tasks.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestTaskCollection {
        List<RestTask> tasks = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="tasks")
        public void setTasks(List<RestTask> tasks) {
            this.tasks = tasks;
        }

        @Override
        public List<RestTask> getTasks() {
            throw new UnsupportedOperationException();
        }
    }
}

