/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import io.digdag.client.api.RestVersionCheckResult;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestVersionCheckResult
implements RestVersionCheckResult {
    private final String serverVersion;
    private final boolean upgradeRecommended;
    private final boolean apiCompatible;

    private ImmutableRestVersionCheckResult(String serverVersion, boolean upgradeRecommended, boolean apiCompatible) {
        this.serverVersion = serverVersion;
        this.upgradeRecommended = upgradeRecommended;
        this.apiCompatible = apiCompatible;
    }

    @Override
    @JsonProperty(value="serverVersion")
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    @JsonProperty(value="upgradeRecommended")
    public boolean getUpgradeRecommended() {
        return this.upgradeRecommended;
    }

    @Override
    @JsonProperty(value="apiCompatible")
    public boolean getApiCompatible() {
        return this.apiCompatible;
    }

    public final ImmutableRestVersionCheckResult withServerVersion(String value) {
        if (this.serverVersion.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"serverVersion");
        return new ImmutableRestVersionCheckResult(newValue, this.upgradeRecommended, this.apiCompatible);
    }

    public final ImmutableRestVersionCheckResult withUpgradeRecommended(boolean value) {
        if (this.upgradeRecommended == value) {
            return this;
        }
        return new ImmutableRestVersionCheckResult(this.serverVersion, value, this.apiCompatible);
    }

    public final ImmutableRestVersionCheckResult withApiCompatible(boolean value) {
        if (this.apiCompatible == value) {
            return this;
        }
        return new ImmutableRestVersionCheckResult(this.serverVersion, this.upgradeRecommended, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestVersionCheckResult && this.equalTo((ImmutableRestVersionCheckResult)another);
    }

    private boolean equalTo(ImmutableRestVersionCheckResult another) {
        return this.serverVersion.equals(another.serverVersion) && this.upgradeRecommended == another.upgradeRecommended && this.apiCompatible == another.apiCompatible;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.serverVersion.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.upgradeRecommended);
        h = h * 17 + Booleans.hashCode((boolean)this.apiCompatible);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestVersionCheckResult").omitNullValues().add("serverVersion", (Object)this.serverVersion).add("upgradeRecommended", this.upgradeRecommended).add("apiCompatible", this.apiCompatible).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestVersionCheckResult fromJson(Json json) {
        Builder builder = ImmutableRestVersionCheckResult.builder();
        if (json.serverVersion != null) {
            builder.serverVersion(json.serverVersion);
        }
        if (json.upgradeRecommendedIsSet) {
            builder.upgradeRecommended(json.upgradeRecommended);
        }
        if (json.apiCompatibleIsSet) {
            builder.apiCompatible(json.apiCompatible);
        }
        return builder.build();
    }

    public static ImmutableRestVersionCheckResult copyOf(RestVersionCheckResult instance) {
        if (instance instanceof ImmutableRestVersionCheckResult) {
            return (ImmutableRestVersionCheckResult)instance;
        }
        return ImmutableRestVersionCheckResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SERVER_VERSION = 1L;
        private static final long INIT_BIT_UPGRADE_RECOMMENDED = 2L;
        private static final long INIT_BIT_API_COMPATIBLE = 4L;
        private long initBits = 7L;
        @Nullable
        private String serverVersion;
        private boolean upgradeRecommended;
        private boolean apiCompatible;

        private Builder() {
        }

        public final Builder from(RestVersionCheckResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.serverVersion(instance.getServerVersion());
            this.upgradeRecommended(instance.getUpgradeRecommended());
            this.apiCompatible(instance.getApiCompatible());
            return this;
        }

        @JsonProperty(value="serverVersion")
        public final Builder serverVersion(String serverVersion) {
            this.serverVersion = (String)Preconditions.checkNotNull((Object)serverVersion, (Object)"serverVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="upgradeRecommended")
        public final Builder upgradeRecommended(boolean upgradeRecommended) {
            this.upgradeRecommended = upgradeRecommended;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="apiCompatible")
        public final Builder apiCompatible(boolean apiCompatible) {
            this.apiCompatible = apiCompatible;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRestVersionCheckResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestVersionCheckResult(this.serverVersion, this.upgradeRecommended, this.apiCompatible);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serverVersion");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("upgradeRecommended");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("apiCompatible");
            }
            return "Cannot build RestVersionCheckResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestVersionCheckResult {
        @Nullable
        String serverVersion;
        boolean upgradeRecommended;
        boolean upgradeRecommendedIsSet;
        boolean apiCompatible;
        boolean apiCompatibleIsSet;

        Json() {
        }

        @JsonProperty(value="serverVersion")
        public void setServerVersion(String serverVersion) {
            this.serverVersion = serverVersion;
        }

        @JsonProperty(value="upgradeRecommended")
        public void setUpgradeRecommended(boolean upgradeRecommended) {
            this.upgradeRecommended = upgradeRecommended;
            this.upgradeRecommendedIsSet = true;
        }

        @JsonProperty(value="apiCompatible")
        public void setApiCompatible(boolean apiCompatible) {
            this.apiCompatible = apiCompatible;
            this.apiCompatibleIsSet = true;
        }

        @Override
        public String getServerVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getUpgradeRecommended() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getApiCompatible() {
            throw new UnsupportedOperationException();
        }
    }
}

