/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.Id;
import io.digdag.client.api.IdAndName;
import io.digdag.client.api.RestWorkflowDefinition;
import io.digdag.client.config.Config;
import java.time.ZoneId;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestWorkflowDefinition
implements RestWorkflowDefinition {
    private final Id id;
    private final String name;
    private final IdAndName project;
    private final String revision;
    private final ZoneId timeZone;
    private final Config config;

    private ImmutableRestWorkflowDefinition(Id id, String name, IdAndName project, String revision, ZoneId timeZone, Config config) {
        this.id = id;
        this.name = name;
        this.project = project;
        this.revision = revision;
        this.timeZone = timeZone;
        this.config = config;
    }

    @Override
    @JsonProperty(value="id")
    public Id getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="project")
    public IdAndName getProject() {
        return this.project;
    }

    @Override
    @JsonProperty(value="revision")
    public String getRevision() {
        return this.revision;
    }

    @Override
    @JsonProperty(value="timezone")
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    public final ImmutableRestWorkflowDefinition withId(Id value) {
        if (this.id == value) {
            return this;
        }
        Id newValue = (Id)Preconditions.checkNotNull((Object)value, (Object)"id");
        return new ImmutableRestWorkflowDefinition(newValue, this.name, this.project, this.revision, this.timeZone, this.config);
    }

    public final ImmutableRestWorkflowDefinition withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableRestWorkflowDefinition(this.id, newValue, this.project, this.revision, this.timeZone, this.config);
    }

    public final ImmutableRestWorkflowDefinition withProject(IdAndName value) {
        if (this.project == value) {
            return this;
        }
        IdAndName newValue = (IdAndName)Preconditions.checkNotNull((Object)value, (Object)"project");
        return new ImmutableRestWorkflowDefinition(this.id, this.name, newValue, this.revision, this.timeZone, this.config);
    }

    public final ImmutableRestWorkflowDefinition withRevision(String value) {
        if (this.revision.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"revision");
        return new ImmutableRestWorkflowDefinition(this.id, this.name, this.project, newValue, this.timeZone, this.config);
    }

    public final ImmutableRestWorkflowDefinition withTimeZone(ZoneId value) {
        if (this.timeZone == value) {
            return this;
        }
        ZoneId newValue = (ZoneId)Preconditions.checkNotNull((Object)value, (Object)"timeZone");
        return new ImmutableRestWorkflowDefinition(this.id, this.name, this.project, this.revision, newValue, this.config);
    }

    public final ImmutableRestWorkflowDefinition withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"config");
        return new ImmutableRestWorkflowDefinition(this.id, this.name, this.project, this.revision, this.timeZone, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestWorkflowDefinition && this.equalTo((ImmutableRestWorkflowDefinition)another);
    }

    private boolean equalTo(ImmutableRestWorkflowDefinition another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.project.equals(another.project) && this.revision.equals(another.revision) && this.timeZone.equals(another.timeZone) && this.config.equals(another.config);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.project.hashCode();
        h = h * 17 + this.revision.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        h = h * 17 + this.config.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestWorkflowDefinition").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("project", (Object)this.project).add("revision", (Object)this.revision).add("timeZone", (Object)this.timeZone).add("config", (Object)this.config).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestWorkflowDefinition fromJson(Json json) {
        Builder builder = ImmutableRestWorkflowDefinition.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.project != null) {
            builder.project(json.project);
        }
        if (json.revision != null) {
            builder.revision(json.revision);
        }
        if (json.timeZone != null) {
            builder.timeZone(json.timeZone);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        return builder.build();
    }

    public static ImmutableRestWorkflowDefinition copyOf(RestWorkflowDefinition instance) {
        if (instance instanceof ImmutableRestWorkflowDefinition) {
            return (ImmutableRestWorkflowDefinition)instance;
        }
        return ImmutableRestWorkflowDefinition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_PROJECT = 4L;
        private static final long INIT_BIT_REVISION = 8L;
        private static final long INIT_BIT_TIME_ZONE = 16L;
        private static final long INIT_BIT_CONFIG = 32L;
        private long initBits = 63L;
        @Nullable
        private Id id;
        @Nullable
        private String name;
        @Nullable
        private IdAndName project;
        @Nullable
        private String revision;
        @Nullable
        private ZoneId timeZone;
        @Nullable
        private Config config;

        private Builder() {
        }

        public final Builder from(RestWorkflowDefinition instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.project(instance.getProject());
            this.revision(instance.getRevision());
            this.timeZone(instance.getTimeZone());
            this.config(instance.getConfig());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(Id id) {
            this.id = (Id)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="project")
        public final Builder project(IdAndName project) {
            this.project = (IdAndName)Preconditions.checkNotNull((Object)project, (Object)"project");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="revision")
        public final Builder revision(String revision) {
            this.revision = (String)Preconditions.checkNotNull((Object)revision, (Object)"revision");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="timezone")
        public final Builder timeZone(ZoneId timeZone) {
            this.timeZone = (ZoneId)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="config")
        public final Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableRestWorkflowDefinition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestWorkflowDefinition(this.id, this.name, this.project, this.revision, this.timeZone, this.config);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("project");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("revision");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("timeZone");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("config");
            }
            return "Cannot build RestWorkflowDefinition, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestWorkflowDefinition {
        @Nullable
        Id id;
        @Nullable
        String name;
        @Nullable
        IdAndName project;
        @Nullable
        String revision;
        @Nullable
        ZoneId timeZone;
        @Nullable
        Config config;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="project")
        public void setProject(IdAndName project) {
            this.project = project;
        }

        @JsonProperty(value="revision")
        public void setRevision(String revision) {
            this.revision = revision;
        }

        @JsonProperty(value="timezone")
        public void setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        @JsonProperty(value="config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @Override
        public Id getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IdAndName getProject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRevision() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoneId getTimeZone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }
    }
}

