/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.digdag.client.api.RestWorkflowDefinition;
import io.digdag.client.api.RestWorkflowDefinitionCollection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestWorkflowDefinitionCollection
implements RestWorkflowDefinitionCollection {
    private final ImmutableList<RestWorkflowDefinition> workflows;

    private ImmutableRestWorkflowDefinitionCollection(ImmutableList<RestWorkflowDefinition> workflows) {
        this.workflows = workflows;
    }

    @JsonProperty(value="workflows")
    public ImmutableList<RestWorkflowDefinition> getWorkflows() {
        return this.workflows;
    }

    public final ImmutableRestWorkflowDefinitionCollection withWorkflows(RestWorkflowDefinition ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRestWorkflowDefinitionCollection((ImmutableList<RestWorkflowDefinition>)newValue);
    }

    public final ImmutableRestWorkflowDefinitionCollection withWorkflows(Iterable<? extends RestWorkflowDefinition> elements) {
        if (this.workflows == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRestWorkflowDefinitionCollection((ImmutableList<RestWorkflowDefinition>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestWorkflowDefinitionCollection && this.equalTo((ImmutableRestWorkflowDefinitionCollection)another);
    }

    private boolean equalTo(ImmutableRestWorkflowDefinitionCollection another) {
        return this.workflows.equals(another.workflows);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.workflows.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestWorkflowDefinitionCollection").omitNullValues().add("workflows", this.workflows).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestWorkflowDefinitionCollection fromJson(Json json) {
        Builder builder = ImmutableRestWorkflowDefinitionCollection.builder();
        if (json.workflows != null) {
            builder.addAllWorkflows(json.workflows);
        }
        return builder.build();
    }

    public static ImmutableRestWorkflowDefinitionCollection copyOf(RestWorkflowDefinitionCollection instance) {
        if (instance instanceof ImmutableRestWorkflowDefinitionCollection) {
            return (ImmutableRestWorkflowDefinitionCollection)instance;
        }
        return ImmutableRestWorkflowDefinitionCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<RestWorkflowDefinition> workflows = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(RestWorkflowDefinitionCollection instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllWorkflows(instance.getWorkflows());
            return this;
        }

        public final Builder addWorkflows(RestWorkflowDefinition element) {
            this.workflows.add((Object)element);
            return this;
        }

        public final Builder addWorkflows(RestWorkflowDefinition ... elements) {
            this.workflows.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="workflows")
        public final Builder workflows(Iterable<? extends RestWorkflowDefinition> elements) {
            this.workflows = ImmutableList.builder();
            return this.addAllWorkflows(elements);
        }

        public final Builder addAllWorkflows(Iterable<? extends RestWorkflowDefinition> elements) {
            this.workflows.addAll(elements);
            return this;
        }

        public ImmutableRestWorkflowDefinitionCollection build() {
            return new ImmutableRestWorkflowDefinitionCollection(this.workflows.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestWorkflowDefinitionCollection {
        List<RestWorkflowDefinition> workflows = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="workflows")
        public void setWorkflows(List<RestWorkflowDefinition> workflows) {
            this.workflows = workflows;
        }

        @Override
        public List<RestWorkflowDefinition> getWorkflows() {
            throw new UnsupportedOperationException();
        }
    }
}

