/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.client.api.IdAndName;
import io.digdag.client.api.RestWorkflowSessionTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRestWorkflowSessionTime
implements RestWorkflowSessionTime {
    private final IdAndName project;
    private final String revision;
    private final OffsetDateTime sessionTime;
    private final ZoneId timeZone;

    private ImmutableRestWorkflowSessionTime(IdAndName project, String revision, OffsetDateTime sessionTime, ZoneId timeZone) {
        this.project = project;
        this.revision = revision;
        this.sessionTime = sessionTime;
        this.timeZone = timeZone;
    }

    @Override
    @JsonProperty(value="project")
    public IdAndName getProject() {
        return this.project;
    }

    @Override
    @JsonProperty(value="revision")
    public String getRevision() {
        return this.revision;
    }

    @Override
    @JsonProperty(value="sessionTime")
    public OffsetDateTime getSessionTime() {
        return this.sessionTime;
    }

    @Override
    @JsonProperty(value="timezone")
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public final ImmutableRestWorkflowSessionTime withProject(IdAndName value) {
        if (this.project == value) {
            return this;
        }
        IdAndName newValue = (IdAndName)Preconditions.checkNotNull((Object)value, (Object)"project");
        return new ImmutableRestWorkflowSessionTime(newValue, this.revision, this.sessionTime, this.timeZone);
    }

    public final ImmutableRestWorkflowSessionTime withRevision(String value) {
        if (this.revision.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"revision");
        return new ImmutableRestWorkflowSessionTime(this.project, newValue, this.sessionTime, this.timeZone);
    }

    public final ImmutableRestWorkflowSessionTime withSessionTime(OffsetDateTime value) {
        if (this.sessionTime == value) {
            return this;
        }
        OffsetDateTime newValue = (OffsetDateTime)Preconditions.checkNotNull((Object)value, (Object)"sessionTime");
        return new ImmutableRestWorkflowSessionTime(this.project, this.revision, newValue, this.timeZone);
    }

    public final ImmutableRestWorkflowSessionTime withTimeZone(ZoneId value) {
        if (this.timeZone == value) {
            return this;
        }
        ZoneId newValue = (ZoneId)Preconditions.checkNotNull((Object)value, (Object)"timeZone");
        return new ImmutableRestWorkflowSessionTime(this.project, this.revision, this.sessionTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestWorkflowSessionTime && this.equalTo((ImmutableRestWorkflowSessionTime)another);
    }

    private boolean equalTo(ImmutableRestWorkflowSessionTime another) {
        return this.project.equals(another.project) && this.revision.equals(another.revision) && this.sessionTime.equals(another.sessionTime) && this.timeZone.equals(another.timeZone);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.project.hashCode();
        h = h * 17 + this.revision.hashCode();
        h = h * 17 + this.sessionTime.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RestWorkflowSessionTime").omitNullValues().add("project", (Object)this.project).add("revision", (Object)this.revision).add("sessionTime", (Object)this.sessionTime).add("timeZone", (Object)this.timeZone).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRestWorkflowSessionTime fromJson(Json json) {
        Builder builder = ImmutableRestWorkflowSessionTime.builder();
        if (json.project != null) {
            builder.project(json.project);
        }
        if (json.revision != null) {
            builder.revision(json.revision);
        }
        if (json.sessionTime != null) {
            builder.sessionTime(json.sessionTime);
        }
        if (json.timeZone != null) {
            builder.timeZone(json.timeZone);
        }
        return builder.build();
    }

    public static ImmutableRestWorkflowSessionTime copyOf(RestWorkflowSessionTime instance) {
        if (instance instanceof ImmutableRestWorkflowSessionTime) {
            return (ImmutableRestWorkflowSessionTime)instance;
        }
        return ImmutableRestWorkflowSessionTime.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PROJECT = 1L;
        private static final long INIT_BIT_REVISION = 2L;
        private static final long INIT_BIT_SESSION_TIME = 4L;
        private static final long INIT_BIT_TIME_ZONE = 8L;
        private long initBits = 15L;
        @Nullable
        private IdAndName project;
        @Nullable
        private String revision;
        @Nullable
        private OffsetDateTime sessionTime;
        @Nullable
        private ZoneId timeZone;

        private Builder() {
        }

        public final Builder from(RestWorkflowSessionTime instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.project(instance.getProject());
            this.revision(instance.getRevision());
            this.sessionTime(instance.getSessionTime());
            this.timeZone(instance.getTimeZone());
            return this;
        }

        @JsonProperty(value="project")
        public final Builder project(IdAndName project) {
            this.project = (IdAndName)Preconditions.checkNotNull((Object)project, (Object)"project");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="revision")
        public final Builder revision(String revision) {
            this.revision = (String)Preconditions.checkNotNull((Object)revision, (Object)"revision");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="sessionTime")
        public final Builder sessionTime(OffsetDateTime sessionTime) {
            this.sessionTime = (OffsetDateTime)Preconditions.checkNotNull((Object)sessionTime, (Object)"sessionTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="timezone")
        public final Builder timeZone(ZoneId timeZone) {
            this.timeZone = (ZoneId)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableRestWorkflowSessionTime build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRestWorkflowSessionTime(this.project, this.revision, this.sessionTime, this.timeZone);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("project");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("revision");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sessionTime");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("timeZone");
            }
            return "Cannot build RestWorkflowSessionTime, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RestWorkflowSessionTime {
        @Nullable
        IdAndName project;
        @Nullable
        String revision;
        @Nullable
        OffsetDateTime sessionTime;
        @Nullable
        ZoneId timeZone;

        Json() {
        }

        @JsonProperty(value="project")
        public void setProject(IdAndName project) {
            this.project = project;
        }

        @JsonProperty(value="revision")
        public void setRevision(String revision) {
            this.revision = revision;
        }

        @JsonProperty(value="sessionTime")
        public void setSessionTime(OffsetDateTime sessionTime) {
            this.sessionTime = sessionTime;
        }

        @JsonProperty(value="timezone")
        public void setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public IdAndName getProject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRevision() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime getSessionTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoneId getTimeZone() {
            throw new UnsupportedOperationException();
        }
    }
}

